/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.library;

import com.spacekiller.util.FileResource;
import com.spacekiller.util.Resource;
import com.spacekiller.util.URIResource;
import com.spacekiller.util.URLResource;
import com.spacekiller.util.media.DefaultMediaCrate;
import com.spacekiller.util.media.DefaultMediaCrateEntry;
import com.spacekiller.util.media.DirectoryMediaCrate;
import com.spacekiller.util.media.MediaContext;
import com.spacekiller.util.media.MediaCrate;
import com.spacekiller.util.media.MediaCrateEntry;
import com.spacekiller.util.media.MediaEndpoint;
import com.spacekiller.util.media.MediaLibrary;
import com.spacekiller.util.media.MediaResource;
import com.spacekiller.util.media.MediaUtil;
import com.spacekiller.util.media.library.BaseMediaContext;
import com.spacekiller.util.media.library.CrateFileMediaCrate;
import com.spacekiller.util.media.library.m3u.M3uMediaCrate;
import com.spacekiller.util.media.library.remote.MediaClient;
import com.spacekiller.util.media.library.remote.RemoteMediaCrate;
import com.spacekiller.util.media.library.remote.RemoteMediaLibrary;
import com.spacekiller.util.media.library.serato.SeratoMediaCrate;
import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CrateFile {
    private static final Logger logger = Logger.getLogger(CrateFile.class.getName());
    public static final String MEDIA_CRATES_FILE_EXTENSION = ".crates";
    private static final int HEADER_MAGIC = 1131574387;
    private static final int LEGACY_MAGIC = -1105627446;
    private static final int CRATE_MAGIC = -904300802;
    private static final int FOOTER_MAGIC = -98994513;
    private static final int VERSION_0 = 0;
    private static final int VERSION_1 = 1;
    private static final int VERSION_2 = 2;
    private static final int VERSION_3 = 3;
    private static final int VERSION = 3;
    private static final int CRATE_TYPE_DEFAULT = 1;
    private static final int CRATE_TYPE_DIRECTORY = 2;
    private static final int CRATE_TYPE_FILE = 3;
    private static final int CRATE_TYPE_SERATO = 10;
    private static final int CRATE_TYPE_M3U = 13;
    private static final int CRATE_TYPE_REMOTE = 23;
    private static final int RESOURCE_NULL = 0;
    private static final int RESOURCE_FILE = 1;
    private static final int RESOURCE_URL = 2;
    private static final int RESOURCE_URI = 3;
    private static final int RESOURCE_REMOTE = 4;
    private static final int REMOTE_LIBRARY = 42;
    private final File file;
    private final MediaLibrary library;
    private final MediaContext context;
    private Component parentComponent;

    public CrateFile(File file, MediaLibrary library, MediaContext context, Component parentComponent) {
        if (file == null) {
            throw new NullPointerException("file");
        }
        if (library == null) {
            throw new NullPointerException("library");
        }
        if (context == null) {
            throw new NullPointerException("context");
        }
        this.file = file;
        this.library = library;
        this.context = context;
        this.parentComponent = parentComponent;
    }

    public final File getFile() {
        return this.file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeMediaCrateFile(MediaCrate[] crates) throws IOException {
        FileOutputStream fos = new FileOutputStream(this.file);
        try {
            DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(fos));
            try {
                dos.writeInt(1131574387);
                dos.writeInt(3);
                this.writeMediaLibraries(crates, dos);
                this.writeMediaCrates(crates, dos);
                dos.writeInt(-98994513);
            }
            finally {
                dos.close();
            }
        }
        finally {
            fos.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isMediaCrateFile(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        try {
            DataInputStream dis;
            block11: {
                block10: {
                    boolean bl;
                    dis = new DataInputStream(new BufferedInputStream(fis));
                    try {
                        int magic = dis.readInt();
                        if (magic == 1131574387 || magic == -1105627446) break block10;
                        bl = false;
                    }
                    catch (Throwable throwable) {
                        dis.close();
                        throw throwable;
                    }
                    dis.close();
                    return bl;
                }
                int version = dis.readInt();
                if (version >= 0 && version <= 3) break block11;
                boolean bl = false;
                dis.close();
                return bl;
            }
            boolean bl = true;
            dis.close();
            return bl;
        }
        finally {
            fis.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaCrate[] readMediaCrateFile() throws IOException, ClassNotFoundException {
        FileInputStream fis = new FileInputStream(this.file);
        try {
            MediaCrate[] mediaCrateArray;
            DataInputStream dis = new DataInputStream(new BufferedInputStream(fis));
            try {
                int magic = dis.readInt();
                if (magic != 1131574387 && magic != -1105627446) {
                    throw new StreamCorruptedException("Invalid media crate file header: " + magic + " != " + 1131574387);
                }
                int version = dis.readInt();
                if (version < 0 || version > 3) {
                    throw new StreamCorruptedException("Unsupported media crate file version: " + version + " (current=" + 3 + ")");
                }
                if (version >= 1) {
                    this.readMediaLibraries(dis, version);
                }
                MediaCrate[] crates = this.readMediaCrates(dis, version);
                int footer = dis.readInt();
                if (footer != -98994513) {
                    throw new StreamCorruptedException("Invalid media crate file footer: " + footer + " != " + -98994513);
                }
                mediaCrateArray = crates;
            }
            catch (Throwable throwable) {
                dis.close();
                throw throwable;
            }
            dis.close();
            return mediaCrateArray;
        }
        finally {
            fis.close();
        }
    }

    protected void readMediaLibraries(DataInput in, int version) throws IOException, ClassNotFoundException {
        int libCount = in.readInt();
        if (libCount < 1) {
            if (libCount < 0) {
                throw new StreamCorruptedException("Invalid media library reference count: " + libCount);
            }
            return;
        }
        for (int i = 0; i < libCount; ++i) {
            int libType = in.readInt();
            if (libType == 42) {
                MediaLibrary oldLib;
                BaseMediaContext mediaContext;
                String libraryId = in.readUTF();
                MediaEndpoint endpoint = null;
                try {
                    endpoint = MediaUtil.readEndpoint((DataInput)in);
                }
                catch (ClassNotFoundException e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
                String userName = null;
                if (version >= 3 && (userName = in.readUTF()).length() < 1) {
                    userName = null;
                }
                if (libraryId.length() < 1 || (mediaContext = this.getDefaultMediaContext()) == null || (oldLib = mediaContext.getMediaLibrary(libraryId)) != null && oldLib instanceof RemoteMediaLibrary) continue;
                SocketAddress socketAddr = endpoint == null ? null : endpoint.getSocketAddress();
                String libraryName = endpoint == null ? null : endpoint.getLibraryName();
                boolean remoteDecoding = endpoint == null ? false : endpoint.isRemoteDecoding();
                MediaClient client = new MediaClient("MediaClient-" + libraryName, (MediaContext)mediaContext, this.parentComponent);
                client.setEndpoint(socketAddr);
                client.setLibraryName(libraryName);
                client.setRemoteDecoding(remoteDecoding);
                client.setDefaultUserName(userName);
                RemoteMediaLibrary remoteLibrary = new RemoteMediaLibrary(libraryId, mediaContext, client);
                mediaContext.registerMediaLibrary(remoteLibrary);
                continue;
            }
            throw new StreamCorruptedException("Unsupported media library reference type: " + libType);
        }
    }

    protected BaseMediaContext getDefaultMediaContext() {
        MediaContext mc = this.library.getContext();
        if (mc != null && mc instanceof BaseMediaContext) {
            return (BaseMediaContext)mc;
        }
        return null;
    }

    protected void writeMediaLibraries(MediaCrate[] crates, DataOutput out) throws IOException {
        HashSet dstLibraries = new HashSet();
        this.enumerateMediaLibraries(crates, dstLibraries);
        ArrayList libraryList = new ArrayList(dstLibraries.size());
        libraryList.addAll(dstLibraries);
        int libraryCount = libraryList.size();
        ArrayList<RemoteMediaLibrary> remoteLibraryList = new ArrayList<RemoteMediaLibrary>();
        for (int i = 0; i < libraryCount; ++i) {
            MediaLibrary lib = (MediaLibrary)libraryList.get(i);
            if (lib == null || !(lib instanceof RemoteMediaLibrary)) continue;
            RemoteMediaLibrary remoteLibrary = (RemoteMediaLibrary)lib;
            remoteLibraryList.add(remoteLibrary);
        }
        int remoteLibCount = remoteLibraryList.size();
        out.writeInt(remoteLibCount);
        for (int i = 0; i < remoteLibCount; ++i) {
            RemoteMediaLibrary remoteLibrary = (RemoteMediaLibrary)remoteLibraryList.get(i);
            String libraryId = remoteLibrary.getId();
            if (libraryId == null) {
                libraryId = "";
            }
            MediaEndpoint endpoint = new MediaEndpoint();
            String userName = null;
            MediaClient client = remoteLibrary.getClient();
            if (client != null) {
                String libraryName = client.getLibraryName();
                boolean remoteDecoding = client.isRemoteDecoding();
                SocketAddress socketAddress = client.getEndpoint();
                userName = client.getDefaultUserName();
                endpoint.setSocketAddress(socketAddress);
                endpoint.setLibraryName(libraryName);
                endpoint.setRemoteDecoding(remoteDecoding);
            }
            out.writeInt(42);
            out.writeUTF(libraryId);
            MediaUtil.writeEndpoint((MediaEndpoint)endpoint, (DataOutput)out);
            if (userName == null) {
                userName = "";
            }
            out.writeUTF(userName);
        }
    }

    protected void enumerateMediaLibraries(MediaCrate[] crates, Set dstLibraries) throws IOException {
        int crateCount = crates == null ? 0 : crates.length;
        for (int i = 0; i < crateCount; ++i) {
            MediaCrate crate = crates[i];
            this.enumerateMediaLibraries(crate, dstLibraries);
        }
    }

    protected void enumerateMediaLibraries(MediaCrate crate, Set dstLibraries) throws IOException {
        if (crate == null) {
            return;
        }
        if (crate instanceof DirectoryMediaCrate) {
            return;
        }
        if (crate instanceof CrateFileMediaCrate) {
            return;
        }
        if (crate instanceof SeratoMediaCrate) {
            return;
        }
        if (crate instanceof M3uMediaCrate) {
            return;
        }
        if (crate instanceof RemoteMediaCrate) {
            RemoteMediaCrate remoteCrate = (RemoteMediaCrate)crate;
            MediaLibrary lib = remoteCrate.getLibrary();
            if (lib != null) {
                dstLibraries.add(lib);
            }
            return;
        }
        if (!(crate instanceof DefaultMediaCrate)) {
            return;
        }
        int entryCount = crate.getEntryCount();
        for (int i = 0; i < entryCount; ++i) {
            MediaResource mr;
            MediaLibrary lib;
            Resource res;
            MediaCrateEntry entry = crate.getEntryAt(i);
            if (entry == null || (res = entry.getResource()) == null || !(res instanceof MediaResource) || (lib = (mr = (MediaResource)res).getLibrary()) == null) continue;
            dstLibraries.add(lib);
        }
        int crateCount = crate.getCrateCount();
        for (int i = 0; i < crateCount; ++i) {
            MediaCrate subCrate = crate.getCrateAt(i);
            this.enumerateMediaLibraries(subCrate, dstLibraries);
        }
    }

    protected void writeMediaCrates(MediaCrate[] crates, DataOutput out) throws IOException {
        int crateCount = crates == null ? 0 : crates.length;
        out.writeInt(crateCount);
        for (int i = 0; i < crateCount; ++i) {
            MediaCrate crate = crates[i];
            this.writeMediaCrate(crate, out);
        }
    }

    protected MediaCrate[] readMediaCrates(DataInput in, int version) throws IOException {
        int crateCount = in.readInt();
        if (crateCount < 1) {
            return null;
        }
        MediaCrate[] crates = new MediaCrate[crateCount];
        for (int i = 0; i < crateCount; ++i) {
            crates[i] = this.readMediaCrate(in, version);
        }
        return crates;
    }

    protected void writeMediaCrate(MediaCrate crate, DataOutput out) throws IOException {
        out.writeInt(-904300802);
        String crateId = crate.getId();
        if (crateId == null) {
            crateId = "";
        }
        out.writeUTF(crateId);
        String crateName = crate.getName();
        if (crateName == null) {
            crateName = "";
        }
        out.writeUTF(crateName);
        String crateDescr = crate.getDescription();
        if (crateDescr == null) {
            crateDescr = "";
        }
        out.writeUTF(crateDescr);
        if (crate instanceof DirectoryMediaCrate) {
            DirectoryMediaCrate dirCrate = (DirectoryMediaCrate)crate;
            out.writeInt(2);
            boolean recursive = dirCrate.isRecursive();
            out.writeBoolean(recursive);
            String path = dirCrate.getPath();
            if (path == null) {
                path = "";
            }
            out.writeUTF(path);
            return;
        }
        if (crate instanceof CrateFileMediaCrate) {
            CrateFileMediaCrate crateFileCrate = (CrateFileMediaCrate)crate;
            String path = crateFileCrate.getPath();
            crateFileCrate.saveCrateFile();
            out.writeInt(3);
            if (path == null) {
                path = "";
            }
            out.writeUTF(path);
            return;
        }
        if (crate instanceof SeratoMediaCrate) {
            SeratoMediaCrate seratoCrate = (SeratoMediaCrate)crate;
            String path = seratoCrate.getPath();
            seratoCrate.saveCrateRecursive();
            out.writeInt(10);
            if (path == null) {
                path = "";
            }
            out.writeUTF(path);
            return;
        }
        if (crate instanceof M3uMediaCrate) {
            M3uMediaCrate m3uCrate = (M3uMediaCrate)crate;
            String path = m3uCrate.getPath();
            m3uCrate.saveCrate();
            out.writeInt(13);
            if (path == null) {
                path = "";
            }
            out.writeUTF(path);
            return;
        }
        if (crate instanceof RemoteMediaCrate) {
            RemoteMediaLibrary remoteLibrary;
            String remoteLibraryId;
            RemoteMediaCrate remoteCrate = (RemoteMediaCrate)crate;
            remoteCrate.saveCrateRecursive();
            boolean remoteReadOnly = remoteCrate.isReadOnly();
            String remoteCrateId = remoteCrate.getCrateId();
            if (remoteCrateId == null) {
                remoteCrateId = "";
            }
            if ((remoteLibraryId = (remoteLibrary = (RemoteMediaLibrary)remoteCrate.getLibrary()).getId()) == null) {
                remoteLibraryId = "";
            }
            out.writeInt(23);
            out.writeBoolean(remoteReadOnly);
            out.writeUTF(remoteCrateId);
            out.writeUTF(remoteLibraryId);
            return;
        }
        if (!(crate instanceof DefaultMediaCrate)) {
            throw new IllegalArgumentException("Unsupported crate type: " + crate.getClass());
        }
        out.writeInt(1);
        int entryCount = crate.getEntryCount();
        out.writeInt(entryCount);
        for (int i = 0; i < entryCount; ++i) {
            MediaCrateEntry entry = crate.getEntryAt(i);
            this.writeMediaCrateEntry(entry, out);
        }
        int crateCount = crate.getCrateCount();
        MediaCrate[] subCrates = crateCount < 1 ? null : new MediaCrate[crateCount];
        for (int i = 0; i < crateCount; ++i) {
            subCrates[i] = crate.getCrateAt(i);
        }
        this.writeMediaCrates(subCrates, out);
    }

    protected MediaCrate readMediaCrate(DataInput in, int version) throws IOException {
        int magic = in.readInt();
        if (magic != -904300802) {
            throw new StreamCorruptedException("Invalid crate magic: " + magic + " != " + -904300802);
        }
        String crateId = null;
        if (version >= 2) {
            crateId = in.readUTF();
        }
        String crateName = in.readUTF();
        String crateDescr = in.readUTF();
        int crateType = in.readInt();
        switch (crateType) {
            case 2: {
                boolean recursive = in.readBoolean();
                String path = in.readUTF();
                DirectoryMediaCrate crate = new DirectoryMediaCrate(crateId, crateName, path, recursive);
                this.context.registerMediaCrate((MediaCrate)crate);
                crate.setDescription(crateDescr);
                crate.setDirty(false);
                return crate;
            }
            case 3: {
                String path = in.readUTF();
                CrateFileMediaCrate crate = new CrateFileMediaCrate(crateId, this.parentComponent, this.library, crateName, path);
                this.context.registerMediaCrate((MediaCrate)crate);
                crate.setDescription(crateDescr);
                crate.setDirty(false);
                return crate;
            }
            case 10: {
                String path = in.readUTF();
                SeratoMediaCrate crate = new SeratoMediaCrate(crateId, crateName, path);
                this.context.registerMediaCrate((MediaCrate)crate);
                crate.setDescription(crateDescr);
                crate.setDirty(false);
                return crate;
            }
            case 13: {
                String path = in.readUTF();
                M3uMediaCrate crate = new M3uMediaCrate(crateId, crateName, path);
                this.context.registerMediaCrate((MediaCrate)crate);
                crate.setDescription(crateDescr);
                crate.setDirty(false);
                return crate;
            }
            case 23: {
                boolean remoteReadOnly = in.readBoolean();
                String remoteCrateId = in.readUTF();
                String remoteLibraryId = in.readUTF();
                RemoteMediaLibrary remoteLibrary = null;
                MediaContext context = this.library.getContext();
                MediaLibrary lib = context.getMediaLibrary(remoteLibraryId);
                if (lib != null && lib instanceof RemoteMediaLibrary) {
                    remoteLibrary = (RemoteMediaLibrary)lib;
                }
                if (remoteLibrary == null) {
                    throw new StreamCorruptedException("Unknown remote media library: " + remoteLibraryId);
                }
                RemoteMediaCrate crate = new RemoteMediaCrate(crateId, crateName, remoteLibrary, remoteCrateId, remoteReadOnly);
                context.registerMediaCrate((MediaCrate)crate);
                crate.setDescription(crateDescr);
                crate.setDirty(false);
                return crate;
            }
            case 1: {
                DefaultMediaCrate crate = new DefaultMediaCrate(crateId, crateName);
                this.context.registerMediaCrate((MediaCrate)crate);
                crate.setDescription(crateDescr);
                int entryCount = in.readInt();
                for (int i = 0; i < entryCount; ++i) {
                    MediaCrateEntry entry = this.readMediaCrateEntry(in, version, (MediaCrate)crate);
                    if (entry == null) continue;
                    crate.addEntry(entry);
                }
                MediaCrate[] subCrates = this.readMediaCrates(in, version);
                if (subCrates != null) {
                    for (MediaCrate subCrate : subCrates) {
                        if (subCrate == null) continue;
                        crate.addCrate(subCrate);
                    }
                }
                crate.setDirty(false);
                return crate;
            }
        }
        throw new StreamCorruptedException("Invalid crate type: " + crateType);
    }

    protected void writeMediaCrateEntry(MediaCrateEntry entry, DataOutput out) throws IOException {
        Resource res = entry.getResource();
        if (res == null) {
            out.writeInt(0);
            return;
        }
        if (res.isFile()) {
            File f = res.getFile();
            String path = f.getPath();
            out.writeInt(1);
            out.writeUTF(path);
            return;
        }
        if (res instanceof URLResource) {
            URLResource urlRes = (URLResource)res;
            URL url = urlRes.getURL();
            String s = url.toString();
            out.writeInt(2);
            out.writeUTF(s);
            return;
        }
        if (res instanceof URIResource) {
            URIResource uriRes = (URIResource)res;
            URI uri = uriRes.getURI();
            String s = uri.toString();
            out.writeInt(3);
            out.writeUTF(s);
            return;
        }
        if (res instanceof MediaResource) {
            MediaResource medRes = (MediaResource)res;
            MediaLibrary medLib = medRes.getLibrary();
            String libId = medLib.getId();
            String path = medRes.getPath();
            out.writeInt(4);
            out.writeUTF(libId);
            out.writeUTF(path);
            return;
        }
        throw new IllegalArgumentException("Unsupported resource type: " + res.getClass());
    }

    protected MediaCrateEntry readMediaCrateEntry(DataInput in, int version, MediaCrate crate) throws IOException {
        FileResource resource = null;
        int resType = in.readInt();
        switch (resType) {
            case 0: {
                return null;
            }
            case 1: {
                String path = in.readUTF();
                File f = new File(path);
                resource = new FileResource(f);
                break;
            }
            case 2: {
                String s = in.readUTF();
                URL url = new URL(s);
                resource = new URLResource(url);
                break;
            }
            case 3: {
                String s = in.readUTF();
                try {
                    URI uri = new URI(s);
                    resource = new URIResource(uri);
                    break;
                }
                catch (URISyntaxException e) {
                    throw new IOException("" + e);
                }
            }
            case 4: {
                String libId = in.readUTF();
                String path = in.readUTF();
                MediaLibrary remoteLib = this.context.getMediaLibrary(libId);
                if (remoteLib == null) {
                    throw new IOException("Remote media library not found #" + libId + " for resource: " + path);
                }
                resource = new MediaResource(remoteLib, path);
                break;
            }
            default: {
                throw new StreamCorruptedException("Invalid crate entry resource type: " + resType);
            }
        }
        return new DefaultMediaCrateEntry(crate, (Resource)resource);
    }
}

