/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.library;

import com.spacekiller.util.media.AbstractMediaCrate;
import com.spacekiller.util.media.DefaultMediaCrate;
import com.spacekiller.util.media.MediaContext;
import com.spacekiller.util.media.MediaCrate;
import com.spacekiller.util.media.MediaCrateEntry;
import com.spacekiller.util.media.MediaLibrary;
import com.spacekiller.util.media.library.CrateFile;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CrateFileMediaCrate
extends DefaultMediaCrate {
    private static final Logger logger = Logger.getLogger(CrateFileMediaCrate.class.getName());
    private Component parentComponent;
    private MediaLibrary library;
    private String path;
    private transient boolean corrupted;
    private transient Thread crateInitThread;

    public CrateFileMediaCrate(String id, Component parentComponent, MediaLibrary library, File crateFile) {
        this(id, parentComponent, library, CrateFileMediaCrate.parseCrateNamePrefix(crateFile), crateFile.getPath());
    }

    public CrateFileMediaCrate(String id, Component parentComponent, MediaLibrary library, String name, String crateFilePath) {
        super(id, name);
        if (library == null) {
            throw new NullPointerException("MediaLibrary");
        }
        this.parentComponent = parentComponent;
        this.library = library;
        this.path = crateFilePath;
        this.crates = null;
    }

    protected void setId(String id) {
        super.setId(id);
    }

    public String getPath() {
        return this.path;
    }

    protected void setPath(String path) {
        this.path = path;
    }

    public MediaLibrary getLibrary() {
        if (this.library != null) {
            return this.library;
        }
        return super.getLibrary();
    }

    public void addEntry(MediaCrateEntry entry) {
        throw new UnsupportedOperationException("Crate file cannot directly contain media entries!");
    }

    public void insertEntryAt(MediaCrateEntry entry, int index) {
        throw new UnsupportedOperationException("Crate file cannot directly contain media entries!");
    }

    public void getCrates(Collection dst) {
        this.lazyInitCrates(dst);
    }

    public int getCrateCount() {
        this.lazyInitCrates(null);
        return super.getCrateCount();
    }

    public MediaCrate getCrateAt(int index) {
        this.lazyInitCrates(null);
        return super.getCrateAt(index);
    }

    public int getCrateIndex(MediaCrate crate) {
        this.lazyInitCrates(null);
        return super.getCrateIndex(crate);
    }

    public void addCrate(MediaCrate crate) {
        this.lazyInitCrates(null);
        super.addCrate(crate);
    }

    public void insertCrateAt(MediaCrate crate, int index) {
        this.lazyInitCrates(null);
        super.insertCrateAt(crate, index);
    }

    public int removeCrate(MediaCrate crate) {
        this.lazyInitCrates(null);
        return super.removeCrate(crate);
    }

    public MediaCrate removeCrateAt(int index) {
        this.lazyInitCrates(null);
        return super.removeCrateAt(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void lazyInitCrates(Collection dst) {
        if (this.crates != null) {
            if (dst != null) {
                List list = this.crates;
                synchronized (list) {
                    dst.addAll(this.crates);
                }
            }
            return;
        }
        Thread thread = Thread.currentThread();
        CrateFileMediaCrate crateFileMediaCrate = this;
        synchronized (crateFileMediaCrate) {
            if (this.crates != null) {
                if (dst != null) {
                    List list = this.crates;
                    synchronized (list) {
                        dst.addAll(this.crates);
                    }
                }
                return;
            }
            if (thread == this.crateInitThread) {
                throw new IllegalStateException("Recursive invocation !");
            }
            while (this.crateInitThread != null) {
                try {
                    ((Object)((Object)this)).wait();
                }
                catch (InterruptedException e) {}
            }
            if (this.crates != null) {
                if (dst != null) {
                    List e = this.crates;
                    synchronized (e) {
                        dst.addAll(this.crates);
                    }
                }
                return;
            }
            this.crateInitThread = thread;
        }
        ArrayList<MediaCrate> listCrates = null;
        try {
            this.corrupted = true;
            listCrates = new ArrayList<MediaCrate>();
            try {
                if (this.path != null) {
                    MediaCrate[] crates;
                    File file = new File(this.path);
                    MediaLibrary mediaLibrary = this.getLibrary();
                    MediaContext mediaContext = mediaLibrary.getContext();
                    CrateFile crateFile = new CrateFile(file, mediaLibrary, mediaContext, this.parentComponent);
                    if (file.exists() && file.isFile() && (crates = crateFile.readMediaCrateFile()) != null) {
                        for (MediaCrate crate : crates) {
                            if (crate instanceof AbstractMediaCrate) {
                                AbstractMediaCrate amc = (AbstractMediaCrate)crate;
                                this.setChildParent(amc, (AbstractMediaCrate)this);
                            }
                            listCrates.add(crate);
                            if (dst == null) continue;
                            dst.add(crate);
                        }
                    }
                }
                this.corrupted = false;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        finally {
            CrateFileMediaCrate crateFileMediaCrate2 = this;
            synchronized (crateFileMediaCrate2) {
                this.crates = listCrates;
                this.crateInitThread = null;
                ((Object)((Object)this)).notifyAll();
            }
        }
    }

    public String toString() {
        return String.valueOf(this.path);
    }

    public static String parseCrateNamePrefix(File crateFile) {
        if (crateFile == null) {
            return "root";
        }
        String name = crateFile.getName();
        int x = name.lastIndexOf(46);
        if (x >= 0) {
            name = name.substring(0, x);
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveCrateFile() throws IOException {
        if (!this.isDirty()) {
            return;
        }
        this.lazyInitCrates(null);
        File file = new File(this.path);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Saving media crate file: " + file);
        }
        CrateFileMediaCrate crateFileMediaCrate = this;
        synchronized (crateFileMediaCrate) {
            if (this.corrupted) {
                throw new StreamCorruptedException("Existing crate file seems to be corrupted: " + this.path);
            }
        }
        boolean backup = true;
        File backupFile = null;
        if (backup && file.exists() && file.isFile()) {
            backupFile = new File(this.path + ".bak");
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Backup crate file: " + file + " -> " + backupFile);
            }
            if (backupFile.exists() && !backupFile.delete()) {
                throw new IOException("Failed to delete old crate backup file: " + backupFile);
            }
            if (!file.renameTo(backupFile)) {
                throw new IOException("Failed to rename old crate file: " + file + " -> " + backupFile);
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Writing crate file: " + file);
        }
        boolean success = false;
        try {
            MediaCrate[] crateArray;
            List list = this.crates;
            synchronized (list) {
                crateArray = this.crates.toArray(new MediaCrate[this.crates.size()]);
            }
            MediaLibrary mediaLibrary = this.getLibrary();
            MediaContext mediaContext = mediaLibrary.getContext();
            CrateFile crateFile = new CrateFile(file, mediaLibrary, mediaContext, this.parentComponent);
            crateFile.writeMediaCrateFile(crateArray);
            this.setDirty(false);
            success = true;
        }
        finally {
            if (!success) {
                if (file.delete()) {
                    if (backupFile != null) {
                        if (backupFile.renameTo(file)) {
                            logger.info("Restored backup file: " + backupFile + " -> " + file);
                        } else {
                            logger.warning("Failed to restore backup file: " + backupFile + " -> " + file);
                        }
                    }
                } else {
                    logger.warning("Failed to delete corrupted file: " + file);
                }
            }
        }
    }

    protected boolean isRecursiveChild(MediaCrate child) {
        CrateFileMediaCrate cfmc;
        String path;
        if (super.isRecursiveChild(child)) {
            return true;
        }
        if (child == null) {
            return false;
        }
        if (child instanceof CrateFileMediaCrate && (path = (cfmc = (CrateFileMediaCrate)child).getPath()) != null && path.length() > 0) {
            for (CrateFileMediaCrate crate = this; crate != null; crate = crate.getParent()) {
                if (!(crate instanceof CrateFileMediaCrate) || !path.equals(this.path)) continue;
                logger.warning("Recursive child detected: " + path + ", crate=" + (Object)((Object)crate) + ", this=" + (Object)((Object)this));
                return true;
            }
        }
        return false;
    }
}

