/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.library;

import java.io.IOException;
import java.io.InputStream;

public class DebugInputStream
extends InputStream {
    private InputStream stream;

    public DebugInputStream(InputStream stream) {
        this.stream = stream;
        System.out.println("DEBUG: Opened stream: " + this);
    }

    public String toString() {
        return super.toString() + "[" + this.stream + "]";
    }

    @Override
    public synchronized void close() throws IOException {
        System.out.println("DEBUG: Closing stream: " + this);
        if (this.stream != null) {
            this.stream.close();
        }
        System.out.println("DEBUG: Closed stream: " + this);
        this.stream = null;
    }

    @Override
    public int read() throws IOException {
        return this.stream.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.stream.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.stream.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.stream.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.stream.available();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.stream.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.stream.reset();
    }

    @Override
    public boolean markSupported() {
        return this.stream.markSupported();
    }
}

