/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.library;

import com.spacekiller.util.Resource;
import com.spacekiller.util.media.AudioEntry;
import com.spacekiller.util.media.MediaContext;
import com.spacekiller.util.media.MediaEntry;
import com.spacekiller.util.media.MediaMarker;
import com.spacekiller.util.media.MutableMediaEntry;
import com.spacekiller.util.media.PictureEntry;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamCorruptedException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class DirectoryCacheEntry
implements MutableMediaEntry,
Resource {
    private static final int VERSION_0 = 0;
    private static final int VERSION = 0;
    private String path;
    private long lastModified;
    private List crateNames;
    private List entryNames;

    public String toString() {
        return this.path;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Resource getResource() {
        return this;
    }

    public void setResource(Resource v) {
        throw new UnsupportedOperationException();
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long v) {
        this.lastModified = v;
    }

    public List getCrateNames() {
        return this.crateNames;
    }

    public void setCrateNames(List crateNames) {
        this.crateNames = crateNames;
    }

    public List getEntryNames() {
        return this.entryNames;
    }

    public void setEntryNames(List entryNames) {
        this.entryNames = entryNames;
    }

    public void writeEntry(DataOutput out, Resource resource) throws IOException {
        this.writeEntry(out);
    }

    public void writeEntry(DataOutput out) throws IOException {
        List entryList;
        out.writeByte(0);
        out.writeLong(this.lastModified);
        out.writeUTF(this.path);
        List crateList = this.crateNames;
        int crateCount = crateList == null ? 0 : crateList.size();
        out.writeInt(crateCount);
        if (crateCount > 0) {
            for (int i = 0; i < crateCount; ++i) {
                out.writeUTF((String)crateList.get(i));
            }
        }
        int entryCount = (entryList = this.entryNames) == null ? 0 : entryList.size();
        out.writeInt(entryCount);
        if (entryCount > 0) {
            for (int i = 0; i < entryCount; ++i) {
                out.writeUTF((String)entryList.get(i));
            }
        }
    }

    public void readEntry(DataInput in, MediaContext context) throws IOException {
        byte version = in.readByte();
        if (version > 0 || version < 0) {
            throw new StreamCorruptedException("Unsupported version: " + version + " > " + 0);
        }
        this.lastModified = in.readLong();
        this.path = in.readUTF();
        ArrayList<String> crateList = this.crateNames;
        int crateCount = in.readInt();
        if (crateCount > 0) {
            if (crateList == null) {
                this.crateNames = crateList = new ArrayList<String>(crateCount);
            } else {
                crateList.clear();
            }
            for (int i = 0; i < crateCount; ++i) {
                crateList.add(in.readUTF());
            }
        } else if (crateList != null) {
            crateList.clear();
        }
        ArrayList<String> entryList = this.entryNames;
        int entryCount = in.readInt();
        if (entryCount > 0) {
            if (entryList == null) {
                this.entryNames = entryList = new ArrayList<String>(entryCount);
            } else {
                entryList.clear();
            }
            for (int i = 0; i < entryCount; ++i) {
                entryList.add(in.readUTF());
            }
        } else if (entryList != null) {
            entryList.clear();
        }
    }

    public boolean isExisting() {
        throw new UnsupportedOperationException();
    }

    public long getFileSize() {
        throw new UnsupportedOperationException();
    }

    public long getFirstScanned() {
        throw new UnsupportedOperationException();
    }

    public long getLastScanned() {
        throw new UnsupportedOperationException();
    }

    public int getLastScannerChecksum() {
        throw new UnsupportedOperationException();
    }

    public long getLastAnalyzed() {
        throw new UnsupportedOperationException();
    }

    public int getLastAnalyzerChecksum() {
        throw new UnsupportedOperationException();
    }

    public String getFormat() {
        throw new UnsupportedOperationException();
    }

    public String getTitle() {
        throw new UnsupportedOperationException();
    }

    public String getArtist() {
        throw new UnsupportedOperationException();
    }

    public String getAlbum() {
        throw new UnsupportedOperationException();
    }

    public String getAlbumArtist() {
        throw new UnsupportedOperationException();
    }

    public int getAlbumTrack() {
        throw new UnsupportedOperationException();
    }

    public String getGenre() {
        throw new UnsupportedOperationException();
    }

    public String getYear() {
        throw new UnsupportedOperationException();
    }

    public double getDuration() {
        throw new UnsupportedOperationException();
    }

    public double getUserRating() {
        throw new UnsupportedOperationException();
    }

    public String getUserComment() {
        throw new UnsupportedOperationException();
    }

    public MediaMarker[] getMarkers() {
        throw new UnsupportedOperationException();
    }

    public AudioEntry getAudioEntry() {
        throw new UnsupportedOperationException();
    }

    public PictureEntry getPictureEntry() {
        throw new UnsupportedOperationException();
    }

    public MediaEntry cloneEntry() throws CloneNotSupportedException {
        throw new UnsupportedOperationException();
    }

    public void setAlbum(String v) {
        throw new UnsupportedOperationException();
    }

    public void setAlbumArtist(String v) {
        throw new UnsupportedOperationException();
    }

    public void setAlbumTrack(int v) {
        throw new UnsupportedOperationException();
    }

    public void setArtist(String v) {
        throw new UnsupportedOperationException();
    }

    public void setDuration(double v) {
        throw new UnsupportedOperationException();
    }

    public void setExisting(boolean v) {
        throw new UnsupportedOperationException();
    }

    public void setFileSize(long v) {
        throw new UnsupportedOperationException();
    }

    public void setFirstScanned(long v) {
        throw new UnsupportedOperationException();
    }

    public void setFormat(String v) {
        throw new UnsupportedOperationException();
    }

    public void setGenre(String v) {
        throw new UnsupportedOperationException();
    }

    public void setLastAnalyzed(long v) {
        throw new UnsupportedOperationException();
    }

    public void setLastAnalyzerChecksum(int v) {
        throw new UnsupportedOperationException();
    }

    public void setLastScanned(long v) {
        throw new UnsupportedOperationException();
    }

    public void setLastScannerChecksum(int v) {
        throw new UnsupportedOperationException();
    }

    public void setMarkers(MediaMarker[] v) {
        throw new UnsupportedOperationException();
    }

    public void setTitle(String v) {
        throw new UnsupportedOperationException();
    }

    public void setUserRating(double v) {
        throw new UnsupportedOperationException();
    }

    public void setUserComment(String v) {
        throw new UnsupportedOperationException();
    }

    public void setYear(String v) {
        throw new UnsupportedOperationException();
    }

    public void setAudioEntry(AudioEntry audioEntry) {
        throw new UnsupportedOperationException();
    }

    public void setPictureEntry(PictureEntry pictureEntry) {
        throw new UnsupportedOperationException();
    }

    public boolean mergeEntry(MediaEntry me) {
        throw new UnsupportedOperationException();
    }

    public boolean isFile() {
        return false;
    }

    public File getFile() throws IOException {
        throw new UnsupportedOperationException();
    }

    public URI getURI() throws IOException, URISyntaxException {
        throw new UnsupportedOperationException();
    }

    public URL getURL() throws IOException, MalformedURLException {
        throw new UnsupportedOperationException();
    }

    public InputStream createInputStream() throws IOException {
        throw new UnsupportedOperationException();
    }

    public int getFlags() {
        throw new UnsupportedOperationException();
    }

    public void setFlags(int flags) {
        throw new UnsupportedOperationException();
    }

    public boolean isCorrupted() {
        throw new UnsupportedOperationException();
    }

    public boolean isInfinite() {
        throw new UnsupportedOperationException();
    }
}

