/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.library;

import com.spacekiller.util.Resource;
import com.spacekiller.util.media.MediaAnalyzer;
import com.spacekiller.util.media.MediaCrateEntry;
import com.spacekiller.util.media.MediaEntry;
import com.spacekiller.util.media.MediaLibrary;
import com.spacekiller.util.media.MediaResource;
import com.spacekiller.util.media.MediaScanner;
import com.spacekiller.util.media.MutableMediaEntry;
import com.spacekiller.util.media.UnknownMediaEntry;
import com.spacekiller.util.media.library.BaseMediaContext;
import com.spacekiller.util.media.library.BaseMediaLibrary;
import com.spacekiller.util.media.library.LibraryFile;
import com.spacekiller.util.media.library.remote.RemoteMediaLibrary;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LibraryFileMediaLibrary
extends BaseMediaLibrary {
    private static final Logger logger = Logger.getLogger(LibraryFileMediaLibrary.class.getName());
    private static final int SCANNER_VERSION = 2;
    private static final int FLAGS_FORCE_RESCAN_OR_ANALYZE = 24;
    private final LibraryFile libraryFile;
    private final MediaScanner scanner;
    private final MediaAnalyzer analyzer;

    public LibraryFileMediaLibrary(String id, BaseMediaContext context, LibraryFile libraryFile, MediaScanner scanner, MediaAnalyzer analyzer) {
        super(id, context);
        this.libraryFile = libraryFile;
        this.scanner = scanner;
        this.analyzer = analyzer;
    }

    public boolean containsMediaEntry(Resource resource) throws IOException {
        if (resource == null) {
            return false;
        }
        if (resource instanceof MediaResource) {
            MediaResource remoteResource = (MediaResource)resource;
            MediaLibrary remoteLibrary = remoteResource.getLibrary();
            return remoteLibrary.containsMediaEntry((Resource)remoteResource);
        }
        return this.libraryFile.containsMediaEntry(resource);
    }

    public MediaEntry getMediaEntry(Resource resource) throws IOException {
        if (resource == null) {
            return null;
        }
        int flags = 0;
        return this.getMediaEntryImpl(resource, flags);
    }

    public MediaEntry getMediaEntry(Resource resource, int flags) throws IOException {
        if (resource == null) {
            return null;
        }
        return this.getMediaEntryImpl(resource, flags);
    }

    public void getMediaEntries(List crateEntryList, int off, int len, int flags, Collection dstMediaEntries) throws IOException {
        int end = off + len;
        for (int i = off; i < end; ++i) {
            MediaEntry me;
            MediaResource mr;
            MediaLibrary lib;
            MediaCrateEntry mce = (MediaCrateEntry)crateEntryList.get(i);
            if (mce == null) {
                dstMediaEntries.add(null);
                continue;
            }
            Resource res = mce.getResource();
            if (res == null) {
                dstMediaEntries.add(null);
                continue;
            }
            if (res instanceof MediaResource && (lib = (mr = (MediaResource)res).getLibrary()) != this && lib instanceof RemoteMediaLibrary) {
                Resource nex;
                int k;
                for (k = i + 1; k < end && (mce = (MediaCrateEntry)crateEntryList.get(k)) != null && (nex = mce.getResource()) != null && nex instanceof MediaResource && (mr = (MediaResource)nex).getLibrary() == lib; ++k) {
                }
                if (--k == i) {
                    me = lib.getMediaEntry(res, flags);
                    dstMediaEntries.add(me);
                    continue;
                }
                lib.getMediaEntries(crateEntryList, i, k - i + 1, flags, dstMediaEntries);
                i = k;
                continue;
            }
            me = this.getMediaEntryImpl(res, flags);
            dstMediaEntries.add(me);
        }
    }

    protected MediaEntry getMediaEntryImpl(Resource resource, int flags) throws IOException {
        MediaAnalyzer analyzer;
        boolean analyze;
        MediaScanner scanner;
        MediaResource mediaResource;
        MediaLibrary remoteLibrary;
        if (resource instanceof MediaResource && (remoteLibrary = (mediaResource = (MediaResource)resource).getLibrary()) != this) {
            return remoteLibrary.getMediaEntry((Resource)mediaResource, flags);
        }
        MediaEntry entry = this.libraryFile.getMediaEntry(resource);
        if (entry != null) {
            boolean rescan;
            if (flags == 0) {
                return entry;
            }
            boolean bl = rescan = (flags & 0x18) != 0;
            if (!rescan) {
                File file;
                if (entry.getLastScannerChecksum() != 2) {
                    rescan = true;
                } else if (resource.isFile() && (file = resource.getFile()) != null && (flags & 1) != 0 && file.exists() && file.isFile()) {
                    long lastMod;
                    long fileSize;
                    if (!rescan && (flags & 2) != 0 && (fileSize = file.length()) != entry.getFileSize()) {
                        rescan = true;
                    }
                    if (!rescan && (flags & 4) != 0 && (lastMod = file.lastModified()) != entry.getLastModified()) {
                        rescan = true;
                    }
                }
                if (!rescan) {
                    return entry;
                }
            }
        }
        if ((scanner = this.scanner) == null) {
            return entry;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Scanning media resource: " + resource);
        }
        long scanTime = System.currentTimeMillis();
        if ((entry = scanner.scanMediaResource(resource, entry)) == null) {
            entry = new UnknownMediaEntry(resource);
        }
        if (entry instanceof MutableMediaEntry) {
            String title;
            File file;
            MutableMediaEntry ame = (MutableMediaEntry)entry;
            if (resource.isFile() && (file = resource.getFile()) != null) {
                if (file.exists() && file.isFile()) {
                    ame.setExisting(true);
                    ame.setFileSize(file.length());
                    ame.setLastModified(file.lastModified());
                } else {
                    ame.setExisting(false);
                }
            }
            ame.setLastScannerChecksum(2);
            ame.setLastScanned(scanTime);
            if (ame.getFirstScanned() == 0L) {
                ame.setFirstScanned(scanTime);
            }
            if ((title = entry.getTitle()) == null && (title = resource.toString()) != null) {
                int x = title.lastIndexOf(47);
                if (x >= 0) {
                    title = title.substring(x + 1);
                }
                if ((x = title.lastIndexOf(92)) >= 0) {
                    title = title.substring(x + 1);
                }
                if (title.length() > 0) {
                    ame.setTitle(title);
                }
            }
            this.libraryFile.putMediaEntry(resource, entry);
        }
        boolean bl = analyze = (flags & 0x10) != 0;
        if (analyze && (analyzer = this.analyzer) != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Analyzing media resource: " + resource);
            }
            try {
                MediaEntry analyzed = analyzer.analyzeMediaResource(resource, entry, (MediaLibrary)this);
                if (analyzed != null) {
                    entry = analyzed;
                    this.libraryFile.putMediaEntry(resource, entry);
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        return entry;
    }

    public void putMediaEntry(Resource resource, MediaEntry entry) throws IOException {
        if (resource instanceof MediaResource) {
            MediaResource remoteResource = (MediaResource)resource;
            MediaLibrary remoteLibrary = remoteResource.getLibrary();
            remoteLibrary.putMediaEntry(resource, entry);
            return;
        }
        this.libraryFile.putMediaEntry(resource, entry);
    }

    public void setUserRating(MutableMediaEntry entry, double rating) throws IOException {
        Resource resource = entry.getResource();
        if (resource == null) {
            return;
        }
        entry.setUserRating(rating);
        if (resource instanceof MediaResource) {
            MediaResource remoteResource = (MediaResource)resource;
            MediaLibrary remoteLibrary = remoteResource.getLibrary();
            remoteLibrary.setUserRating(entry, rating);
            return;
        }
        this.libraryFile.putMediaEntry(resource, (MediaEntry)entry);
    }

    public void setUserComment(MutableMediaEntry entry, String comment) throws IOException {
        Resource resource = entry.getResource();
        if (resource == null) {
            return;
        }
        entry.setUserComment(comment);
        if (resource instanceof MediaResource) {
            MediaResource remoteResource = (MediaResource)resource;
            MediaLibrary remoteLibrary = remoteResource.getLibrary();
            remoteLibrary.setUserComment(entry, comment);
            return;
        }
        this.libraryFile.putMediaEntry(resource, (MediaEntry)entry);
    }

    public void flush() throws IOException {
        this.libraryFile.flush();
    }
}

