/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.library;

import com.spacekiller.util.Resource;
import com.spacekiller.util.media.MediaContext;
import com.spacekiller.util.media.MediaEntry;
import com.spacekiller.util.media.library.CachedRandomAccessFile;
import com.spacekiller.util.media.library.LibraryFile;
import com.spacekiller.util.media.library.LibraryFileV1;
import com.spacekiller.util.media.library.LibraryFileV2;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.StreamCorruptedException;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LibraryFileUtil {
    private static final Logger logger = Logger.getLogger(LibraryFileUtil.class.getName());
    private static final int DEFAULT_BUFFER_SIZE = 65536;
    public static final String LIBRARY_FILE_EXTENSION = ".mlf";
    public static final int HEADER_MAGIC = -1105627430;

    private LibraryFileUtil() {
    }

    public static String getLibraryFileExtension() {
        return LIBRARY_FILE_EXTENSION;
    }

    protected static CachedRandomAccessFile createCachedRandomAccessFile(File file, String mode) throws IOException {
        int cacheSize = 1024;
        return new CachedRandomAccessFile(file, mode, cacheSize);
    }

    public static LibraryFile openLibraryFile(MediaContext context, File file, boolean readOnly) throws IOException {
        int bufSize = 65536;
        String mode = readOnly ? "r" : "rw";
        boolean success = false;
        CachedRandomAccessFile raf = LibraryFileUtil.createCachedRandomAccessFile(file, mode);
        try {
            int ver;
            raf.seek(0L);
            if (raf.length() > 0L) {
                int magic = raf.readInt();
                if (magic != -1105627430) {
                    throw new StreamCorruptedException("Invalid media library file: magic=" + magic + " != " + -1105627430 + ", file=" + file);
                }
                ver = raf.readInt();
            } else {
                ver = 2;
            }
            raf.seek(0L);
            LibraryFile milf = null;
            if (ver == 0) {
                boolean lazyLoad = true;
                boolean autoRecover = true;
                LibraryFileV1 milf1 = new LibraryFileV1(context, file, raf, lazyLoad, autoRecover);
                milf = milf1;
                if (!readOnly) {
                    ver = 2;
                    LibraryFileUtil.migrateLibraryFile(milf, context, file, raf, ver);
                    raf.close();
                    raf = LibraryFileUtil.createCachedRandomAccessFile(file, mode);
                } else {
                    success = true;
                    LibraryFile libraryFile = milf;
                    return libraryFile;
                }
            }
            if (ver == 2) {
                LibraryFileV2 milf2 = new LibraryFileV2(context, file, raf, bufSize);
                milf = milf2;
                if (milf.isDirty()) {
                    LibraryFileUtil.recoverLibraryFile(milf, context, file, raf, ver);
                }
                success = true;
                LibraryFile libraryFile = milf;
                return libraryFile;
            }
            throw new StreamCorruptedException("Unsupported media library file: version=" + ver + ", file=" + file);
        }
        finally {
            if (!success) {
                raf.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void migrateLibraryFile(LibraryFile milf, MediaContext context, File file, RandomAccessFile raf, int ver) throws IOException {
        LibraryFileV2 milf2;
        int bufSize = 65536;
        logger.info("Migrating old media library file: " + file);
        LinkedList list = new LinkedList();
        milf.getAllMediaEntries(list);
        logger.info("migrateLibraryFile: entries=" + list.size());
        String path2 = file.getPath() + ".mig";
        File file2 = new File(path2);
        String mode = "rw";
        CachedRandomAccessFile raf2 = LibraryFileUtil.createCachedRandomAccessFile(file2, mode);
        try {
            raf2.setLength(0L);
            milf2 = new LibraryFileV2(context, file2, raf2, bufSize);
            try {
                for (MediaEntry me : list) {
                    Resource res = me.getResource();
                    if (res == null) continue;
                    milf2.putMediaEntry(res, me);
                }
            }
            finally {
                milf2.close();
            }
        }
        finally {
            raf2.close();
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.info("migrateLibraryFile: Checking new library file: " + file2);
        }
        raf2 = LibraryFileUtil.createCachedRandomAccessFile(file2, mode);
        try {
            milf2 = new LibraryFileV2(context, file2, raf2, bufSize);
            try {
                milf2.check();
            }
            finally {
                milf2.close();
            }
        }
        finally {
            raf2.close();
        }
        milf.close();
        raf.close();
        String bkpFilePath = file.getPath() + ".bkp";
        File bkpFile = new File(bkpFilePath);
        if (logger.isLoggable(Level.INFO)) {
            logger.info("migrateLibraryFile: Renaming old library file: " + file + " -> " + bkpFilePath);
        }
        if (bkpFile.exists() && bkpFile.isFile() && !bkpFile.delete()) {
            throw new IOException("Unable to delete old backup file: " + bkpFile);
        }
        if (!file.renameTo(bkpFile)) {
            throw new IOException("Unable to rename old library file: " + file + " -> " + bkpFilePath);
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.info("migrateLibraryFile: Renaming new library file: " + file2 + " -> " + file);
        }
        if (!file2.renameTo(file)) {
            throw new IOException("Unable to rename old library file: " + file + " -> " + bkpFilePath);
        }
        logger.info("migrateLibraryFile: Completed successfully.");
    }

    protected static void recoverLibraryFile(LibraryFile milf, MediaContext context, File file, RandomAccessFile raf, int ver) throws IOException {
        try {
            long blockCount = milf.check();
            logger.info("Number of blocks: " + blockCount);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        try {
            boolean force = true;
            milf.recover(force);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }
}

