/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.library;

import com.spacekiller.util.Resource;
import com.spacekiller.util.buffer.ByteArrayDataInput;
import com.spacekiller.util.collect.Int2ObjectMap;
import com.spacekiller.util.media.DefaultMediaEntry;
import com.spacekiller.util.media.MediaContext;
import com.spacekiller.util.media.MediaEntry;
import com.spacekiller.util.media.MutableMediaEntry;
import com.spacekiller.util.media.UnknownMediaEntry;
import com.spacekiller.util.media.library.DirectoryCacheEntry;
import com.spacekiller.util.media.library.LibraryFile;
import com.spacekiller.util.media.library.LibraryScanner;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LibraryFileV1
implements LibraryFile {
    private static final Logger logger = Logger.getLogger(LibraryFileV1.class.getName());
    protected static final int VERSION_0 = 0;
    protected static final int VERSION = 0;
    private static final byte DIRTY = 127;
    private static final byte CLEAN = -50;
    private static final int FILE_HEADER_LENGTH = 17;
    private static final int FILE_DIRTY_OFFSET = 8;
    private static final int BLOCK_HEADER_LENGTH = 9;
    private static final int BLOCK_DIRTY_OFFSET = 8;
    private static final int BLOCK_INDEX = 1;
    private static final int BLOCK_DATA = 2;
    private static final int BLOCK_FOOTER = -1;
    public static final int INDEX_ENTRY_LENGTH = 12;
    public static final int DATA_HEADER_LENGTH = 8;
    public static final int NULL = 0;
    public static final int TYPE_DEFAULT_MEDIA_ENTRY = 1976;
    public static final int TYPE_UNKNOWN_MEDIA_ENTRY = 9999;
    public static final int TYPE_DIRECTORY_CACHE_ENTRY = 7438;
    private MediaContext context;
    private File file;
    private RandomAccessFile raf;
    private boolean closed;
    private long footerOffset = -1L;
    private boolean dirty;
    private byte[] buf;
    private ByteArrayDataInput bdi;
    private ByteArrayOutputStream baos;
    private DataOutputStream dos;
    private Map newDataEntries;
    private int flushInterval;
    private List indexBlocks;
    private List dataBlocks;
    private Int2ObjectMap index;
    private int defaultIndexBlockSize = 49165;
    private int defaultDataBlockSize = 262157;
    private boolean autoRecover;

    public LibraryFileV1(MediaContext context, File file, RandomAccessFile raf, boolean lazy, boolean autoRecover) throws IOException {
        boolean exists;
        this.autoRecover = autoRecover;
        this.context = context;
        this.file = file;
        this.raf = raf;
        int bufSize = 1024;
        this.buf = new byte[bufSize];
        this.bdi = new ByteArrayDataInput(this.buf, 0, this.buf.length);
        this.baos = new ByteArrayOutputStream(bufSize);
        this.dos = new DataOutputStream(this.baos);
        this.newDataEntries = new HashMap();
        this.flushInterval = 1024;
        boolean bl = exists = raf.length() > 0L;
        if (exists) {
            if (!lazy) {
                this.loadIndex();
            }
        } else {
            this.initIndex();
            this.removeAllMediaEntries();
        }
    }

    protected synchronized void initIndex() {
        this.index = new Int2ObjectMap(1024);
        this.indexBlocks = new ArrayList();
        this.dataBlocks = new ArrayList();
    }

    protected synchronized void loadIndex() throws IOException {
        block3: {
            if (this.index != null) {
                throw new IllegalStateException("Index is already loaded.");
            }
            this.initIndex();
            try {
                this.loadLibraryIndex();
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
                this.setDirty(true);
                if (!this.autoRecover) break block3;
                logger.warning("Recovering dirty MediaLibraryFile: " + this.file);
                boolean forceRecover = true;
                this.recover(forceRecover);
                logger.info("Recovered dirty MediaLibraryFile: " + this.file);
            }
        }
    }

    public MediaContext getContext() {
        return this.context;
    }

    public File getFile() {
        return this.file;
    }

    protected synchronized void loadLibraryIndex() throws IOException {
        long offset;
        int blockLen;
        long firstOffset;
        this.raf.seek(0L);
        int magic = this.raf.readInt();
        if (magic != -1105627430) {
            throw new StreamCorruptedException("Invalid media library file: " + magic + " != " + -1105627430);
        }
        int ver = this.raf.readInt();
        if (ver < 0 || ver > 0) {
            throw new StreamCorruptedException("Invalid media library file version: " + ver + " (current=" + 0 + ")");
        }
        byte dirt = this.raf.readByte();
        if (dirt != -50) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.warning("Dirty or corrupted media library file: dirt=" + dirt + " != " + -50);
            }
            this.setDirty(true);
        }
        if ((firstOffset = this.raf.readLong()) < 17L) {
            throw new StreamCorruptedException("Invalid first media library offset: " + firstOffset + " < " + 17);
        }
        long fileSize = this.raf.length();
        if (firstOffset > fileSize) {
            throw new StreamCorruptedException("Invalid first media library offset: " + firstOffset + " > " + fileSize);
        }
        long startTime = System.currentTimeMillis();
        long blockCount = 0L;
        logger.info("loadLibraryIndex: fileSize=" + fileSize);
        for (offset = firstOffset; offset < fileSize; offset += (long)blockLen) {
            ++blockCount;
            this.raf.seek(offset);
            blockLen = this.raf.readInt();
            if (blockLen < 9) {
                throw new StreamCorruptedException("Invalid media library block length: " + blockLen + " < " + 9);
            }
            int blockType = this.raf.readInt();
            byte blockDirt = this.raf.readByte();
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Block: ofs=" + offset + ", len=" + blockLen + ", type=" + blockType + ", dirt=" + blockDirt);
            }
            if (blockDirt != -50) {
                if (logger.isLoggable(Level.WARNING)) {
                    logger.warning("Dirty or corrupted media library block: type=" + blockType + ", ofs=" + offset + ", len=" + blockLen + ", dirt=" + blockDirt);
                }
                this.setDirty(true);
            }
            if (blockType == 2) {
                int head = this.raf.readInt();
                if (head > blockLen) {
                    throw new StreamCorruptedException("Invalid data head: " + head + " > " + blockLen);
                }
                if (head < 0) {
                    throw new StreamCorruptedException("Invalid data head: " + head);
                }
                this.dataBlocks.add(new DataBlock(offset, blockLen, head));
                if (!logger.isLoggable(Level.FINER)) continue;
                logger.finer("DataBlock: ofs=" + offset + ", len=" + blockLen + ", head=" + head);
                continue;
            }
            if (blockType == 1) {
                int head = this.raf.readInt();
                int numEntries = (head - 4) / 12;
                for (int i = 0; i < numEntries; ++i) {
                    long entryOfs = this.raf.getFilePointer();
                    long dataOfs = this.raf.readLong();
                    int hash = this.raf.readInt();
                    if (dataOfs == 0L) continue;
                    IndexEntry xe = (IndexEntry)this.index.get(hash);
                    xe = new IndexEntry(entryOfs, xe);
                    this.index.put(hash, (Object)xe);
                }
                this.indexBlocks.add(new IndexBlock(offset, blockLen, head));
                if (!logger.isLoggable(Level.FINER)) continue;
                logger.finer("IndexBlock: ofs=" + offset + ", len=" + blockLen + ", head=" + head);
                continue;
            }
            if (blockType != -1) continue;
            long expectedSize = offset + (long)blockLen;
            if (fileSize == expectedSize) break;
            if (logger.isLoggable(Level.WARNING)) {
                logger.warning("Unexpected file size: " + fileSize + " != " + expectedSize);
            }
            this.setDirty(true);
        }
        if (offset <= fileSize) {
            this.footerOffset = offset;
        } else {
            if (logger.isLoggable(Level.WARNING)) {
                logger.warning("Invalid block offset: " + offset + " > " + fileSize);
            }
            this.setDirty(true);
            this.footerOffset = -1L;
        }
        long endTime = System.currentTimeMillis();
        long elapsedTime = endTime - startTime;
        logger.info("loadLibraryIndex: Completed. time=" + elapsedTime + ", blocks=" + blockCount);
    }

    protected synchronized void writeFileHeader() throws IOException {
        this.raf.seek(0L);
        this.raf.writeInt(-1105627430);
        this.raf.writeInt(0);
        if (this.raf.getFilePointer() != 8L) {
            throw new StreamCorruptedException("Unexpected dirty offset: " + this.raf.getFilePointer() + " != " + 8);
        }
        this.raf.writeByte(127);
        this.raf.writeLong(17L);
        if (this.raf.getFilePointer() != 17L) {
            throw new StreamCorruptedException("Unexpected header length: " + this.raf.getFilePointer() + " != " + 17);
        }
    }

    protected synchronized void writeDirtyFlag(byte flag) throws IOException {
        this.raf.seek(8L);
        this.raf.writeByte(flag);
    }

    @Override
    public synchronized boolean containsMediaEntry(Resource resource) throws IOException {
        String path;
        if (this.index == null) {
            this.loadIndex();
        }
        if (this.newDataEntries.containsKey(path = resource.toString())) {
            return true;
        }
        int hash = path.hashCode();
        IndexEntry xe = (IndexEntry)this.index.get(hash);
        if (xe == null) {
            return false;
        }
        while (xe != null) {
            this.raf.seek(xe.ofs);
            long dataOfs = this.raf.readLong();
            if (dataOfs > 0L) {
                int len;
                MediaEntry me;
                Resource res;
                this.raf.seek(dataOfs);
                int type = this.raf.readInt();
                if (type > 0 && (res = (me = this.readEntry(type, len = this.raf.readInt())).getResource()) != null && path.equals(res.toString())) {
                    return true;
                }
            }
            xe = xe.next;
        }
        return false;
    }

    @Override
    public synchronized MediaEntry getMediaEntry(Resource resource) throws IOException {
        String path;
        DataEntry de;
        if (this.index == null) {
            this.loadIndex();
        }
        if ((de = (DataEntry)this.newDataEntries.get(path = resource.toString())) != null) {
            return this.readEntry(de);
        }
        int hash = path.hashCode();
        IndexEntry xe = (IndexEntry)this.index.get(hash);
        if (xe == null) {
            return null;
        }
        while (xe != null) {
            this.raf.seek(xe.ofs);
            long dataOfs = this.raf.readLong();
            if (dataOfs > 0L) {
                int len;
                MediaEntry me;
                Resource res;
                this.raf.seek(dataOfs);
                int type = this.raf.readInt();
                if (type > 0 && (res = (me = this.readEntry(type, len = this.raf.readInt())).getResource()) != null && path.equals(res.toString())) {
                    return me;
                }
            }
            xe = xe.next;
        }
        return null;
    }

    public Iterator getMediaEntryIterator() throws IOException {
        LinkedList list = new LinkedList();
        this.getAllMediaEntries(list);
        return list.iterator();
    }

    @Override
    public LibraryScanner createLibraryScanner() throws IOException {
        return new Scanner();
    }

    @Override
    public synchronized void getAllMediaEntries(Collection dst) throws IOException {
        MediaEntry me;
        if (this.index == null) {
            this.loadIndex();
        }
        for (IndexEntry xe : this.index) {
            while (xe != null) {
                this.raf.seek(xe.ofs);
                long dataOfs = this.raf.readLong();
                if (dataOfs > 0L) {
                    this.raf.seek(dataOfs);
                    int type = this.raf.readInt();
                    if (type > 0) {
                        int len = this.raf.readInt();
                        me = this.readEntry(type, len);
                        Resource res = me.getResource();
                        if (res != null) {
                            String path = res.toString();
                            DataEntry de = (DataEntry)this.newDataEntries.get(path);
                            if (de == null) {
                                dst.add(me);
                            }
                        } else {
                            dst.add(me);
                        }
                    }
                }
                xe = xe.next;
            }
        }
        for (DataEntry de : this.newDataEntries.values()) {
            me = this.readEntry(de);
            if (me == null) continue;
            dst.add(me);
        }
    }

    @Override
    public synchronized boolean removeMediaEntry(Resource resource) throws IOException {
        String path = resource.toString();
        DataEntry de = (DataEntry)this.newDataEntries.get(path);
        if (de != null) {
            de.type = 0;
            de.data = null;
            return true;
        }
        this.newDataEntries.put(path, new DataEntry());
        if (this.newDataEntries.size() >= this.flushInterval) {
            this.flush();
        }
        return true;
    }

    @Override
    public synchronized void putMediaEntry(Resource resource, MediaEntry entry) throws IOException {
        String path = resource.toString();
        int type = this.getEntryType(entry);
        if (type < 0) {
            throw new IOException("Unsupported media entry type: " + type);
        }
        int hash = path.hashCode();
        this.baos.reset();
        entry.writeEntry((DataOutput)this.dos);
        this.dos.flush();
        byte[] data = this.baos.toByteArray();
        this.newDataEntries.put(path, new DataEntry(type, hash, data));
        if (this.newDataEntries.size() >= this.flushInterval) {
            this.flush();
        }
    }

    public int getEntryType(MediaEntry entry) {
        Class<?> type = entry.getClass();
        if (type == DefaultMediaEntry.class) {
            return 1976;
        }
        if (type == UnknownMediaEntry.class) {
            return 9999;
        }
        if (type == DirectoryCacheEntry.class) {
            return 7438;
        }
        return -1;
    }

    protected MutableMediaEntry createEntry(int type) throws IllegalArgumentException {
        switch (type) {
            case 1976: {
                return new DefaultMediaEntry();
            }
            case 9999: {
                return new UnknownMediaEntry();
            }
            case 7438: {
                return new DirectoryCacheEntry();
            }
            case 0: {
                throw new IllegalArgumentException("Cannot create null entry!");
            }
        }
        throw new IllegalArgumentException("Unsupported media entry type: " + type);
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.flush();
        this.raf.close();
        this.closed = true;
    }

    public synchronized boolean isClosed() {
        return this.closed;
    }

    @Override
    public synchronized void flush() throws IOException {
        Block blk;
        int i;
        int count = this.newDataEntries.size();
        if (count < 1) {
            return;
        }
        if (this.index == null) {
            this.loadIndex();
        }
        this.writeDirtyFlag((byte)127);
        long dataOfs = -1L;
        int len = -1;
        for (Map.Entry m : this.newDataEntries.entrySet()) {
            String path = (String)m.getKey();
            DataEntry de = (DataEntry)m.getValue();
            int hash = de.hash;
            IndexEntry first = (IndexEntry)this.index.get(hash);
            IndexEntry xe = first;
            if (xe != null) {
                IndexEntry prev = null;
                while (xe != null) {
                    this.raf.seek(xe.ofs);
                    dataOfs = this.raf.readLong();
                    if (dataOfs > 0L) {
                        MediaEntry me;
                        Resource res;
                        this.raf.seek(dataOfs);
                        int type = this.raf.readInt();
                        if (type > 0 && (res = (me = this.readEntry(type, len = this.raf.readInt())).getResource()) != null && path.equals(res.toString())) break;
                    }
                    prev = xe;
                    xe = xe.next;
                }
                if (xe != null) {
                    if (de.type == 0) {
                        this.raf.seek(dataOfs);
                        this.raf.writeInt(0);
                        this.raf.seek(xe.ofs);
                        this.raf.writeLong(0L);
                        if (prev == null) {
                            first = xe.next;
                            if (first == null) {
                                this.index.delete(hash);
                                continue;
                            }
                            this.index.put(hash, (Object)xe.next);
                            continue;
                        }
                        prev.next = xe.next;
                        continue;
                    }
                    byte[] data = de.data;
                    if (data.length <= len) {
                        this.raf.seek(dataOfs);
                        this.raf.writeInt(de.type);
                        this.raf.writeInt(data.length);
                        this.raf.write(data);
                        continue;
                    }
                    dataOfs = this.appendDataEntry(de);
                    this.raf.seek(xe.ofs);
                    this.raf.writeLong(dataOfs);
                    this.raf.writeInt(hash);
                    continue;
                }
            }
            if (de.type == 0) continue;
            dataOfs = this.appendDataEntry(de);
            long indexOfs = this.appendIndexEntry(dataOfs, de.hash);
            xe = new IndexEntry(indexOfs, first);
            this.index.put(hash, (Object)xe);
        }
        this.newDataEntries.clear();
        count = this.indexBlocks.size();
        for (i = 0; i < count; ++i) {
            blk = (IndexBlock)this.indexBlocks.get(i);
            if (!blk.dirty) continue;
            this.raf.seek(blk.ofs + 8L);
            this.raf.writeByte(-50);
            blk.dirty = false;
        }
        count = this.dataBlocks.size();
        for (i = 0; i < count; ++i) {
            blk = (DataBlock)this.dataBlocks.get(i);
            if (!((DataBlock)blk).dirty) continue;
            this.raf.seek(((DataBlock)blk).ofs + 8L);
            this.raf.writeByte(-50);
            ((DataBlock)blk).dirty = false;
        }
        this.raf.seek(this.footerOffset);
        this.raf.writeInt(9);
        this.raf.writeInt(-1);
        this.raf.writeByte(-50);
        this.writeDirtyFlag((byte)-50);
    }

    protected synchronized long appendDataEntry(DataEntry de) throws IOException {
        DataBlock blk;
        int dataLen = de.data.length;
        int entryLen = 8 + dataLen;
        int num = this.dataBlocks.size();
        for (int i = num - 1; i >= 0; --i) {
            blk = (DataBlock)this.dataBlocks.get(i);
            if (blk.head + entryLen > blk.len) continue;
            int head = blk.head;
            long entryOfs = blk.ofs + (long)head;
            blk.dirty = true;
            blk.head = head += entryLen;
            long dirtyOfs = blk.ofs + 8L;
            this.raf.seek(dirtyOfs);
            this.raf.writeByte(127);
            this.raf.writeInt(head);
            this.raf.seek(entryOfs);
            this.writeDataEntry(de);
            return entryOfs;
        }
        long blockOfs = this.footerOffset;
        int head = 13;
        long entryOfs = blockOfs + (long)head;
        int newBlockSize = (head += entryLen) + entryLen;
        if (newBlockSize < this.defaultDataBlockSize) {
            newBlockSize = this.defaultDataBlockSize;
        }
        this.footerOffset += (long)newBlockSize;
        this.raf.setLength(this.footerOffset);
        this.raf.seek(blockOfs);
        this.raf.writeInt(newBlockSize);
        this.raf.writeInt(2);
        this.raf.writeByte(127);
        this.raf.writeInt(head);
        blk = new DataBlock(blockOfs, newBlockSize, head);
        blk.dirty = true;
        this.dataBlocks.add(blk);
        this.raf.seek(entryOfs);
        this.writeDataEntry(de);
        return entryOfs;
    }

    protected synchronized long appendIndexEntry(long dataOfs, int hash) throws IOException {
        IndexBlock blk;
        int num = this.indexBlocks.size();
        for (int i = num - 1; i >= 0; --i) {
            blk = (IndexBlock)this.indexBlocks.get(i);
            if (blk.head + 12 > blk.len) continue;
            int head = blk.head;
            long entryOfs = blk.ofs + (long)head;
            blk.dirty = true;
            blk.head = head += 12;
            long dirtyOfs = blk.ofs + 8L;
            this.raf.seek(dirtyOfs);
            this.raf.writeByte(127);
            this.raf.writeInt(head);
            this.raf.seek(entryOfs);
            this.raf.writeLong(dataOfs);
            this.raf.writeInt(hash);
            return entryOfs;
        }
        long blockOfs = this.footerOffset;
        int head = 13;
        long entryOfs = blockOfs + (long)head;
        int newBlockSize = (head += 12) + 12;
        if (newBlockSize < this.defaultIndexBlockSize) {
            newBlockSize = this.defaultIndexBlockSize;
        }
        this.footerOffset += (long)newBlockSize;
        this.raf.setLength(this.footerOffset);
        this.raf.seek(blockOfs);
        this.raf.writeInt(newBlockSize);
        this.raf.writeInt(1);
        this.raf.writeByte(127);
        this.raf.writeInt(head);
        blk = new IndexBlock(blockOfs, newBlockSize, head);
        blk.dirty = true;
        this.indexBlocks.add(blk);
        this.raf.seek(entryOfs);
        this.raf.writeLong(dataOfs);
        this.raf.writeInt(hash);
        return entryOfs;
    }

    private MediaEntry readEntry(int type, int len) throws IOException {
        if (len > this.buf.length) {
            this.buf = new byte[len];
        }
        this.raf.readFully(this.buf, 0, len);
        this.bdi.setBuffer(this.buf, 0, len);
        MutableMediaEntry me = this.createEntry(type);
        if (me != null) {
            me.readEntry((DataInput)this.bdi, this.context);
        }
        return me;
    }

    private MediaEntry readEntry(DataEntry de) throws IOException {
        int type = de.type;
        if (type == 0) {
            return null;
        }
        byte[] data = de.data;
        this.bdi.setBuffer(data, 0, data.length);
        MutableMediaEntry me = this.createEntry(type);
        if (me != null) {
            me.readEntry((DataInput)this.bdi, this.context);
        }
        return me;
    }

    private void writeDataEntry(DataEntry de) throws IOException {
        byte[] data = de.data;
        int dataLen = data.length;
        this.raf.writeInt(de.type);
        this.raf.writeInt(dataLen);
        this.raf.write(data);
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    protected void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    @Override
    public long check() throws IOException {
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void recover(boolean force) throws IOException {
        logger.info("recover: " + this.file);
        logger.info("Reading old media entries...");
        LinkedList mediaEntryList = new LinkedList();
        try {
            this.getAllMediaEntries(mediaEntryList);
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            if (!force) {
                throw new IOException("Failed to recover media entries: " + e);
            }
        }
        finally {
            int count = mediaEntryList.size();
            logger.info("Number of recovered media entries: " + count);
        }
        this.raf.close();
        File backupFile = new File(this.file.getPath() + ".bkp");
        if (backupFile.exists() && backupFile.isFile()) {
            logger.info("Deleting old library backup file: " + backupFile);
            if (!backupFile.delete()) {
                throw new IOException("Failed to delete old backup file: " + backupFile);
            }
        }
        logger.info("Renaming old library file: " + this.file + " -> " + backupFile);
        if (!this.file.renameTo(backupFile)) {
            throw new IOException("Failed to rename library backup file: " + this.file + " -> " + backupFile);
        }
        this.index.clear();
        this.indexBlocks.clear();
        this.dataBlocks.clear();
        this.footerOffset = -1L;
        logger.info("Creating new library file: " + this.file);
        this.raf = new RandomAccessFile(this.file, "rw");
        boolean success = false;
        try {
            this.writeFileHeader();
            this.writeDirtyFlag((byte)-50);
            this.footerOffset = 17L;
            int count = mediaEntryList.size();
            logger.info("Writing recovered media entries: " + count);
            for (MediaEntry me : mediaEntryList) {
                Resource res = me.getResource();
                if (res == null) continue;
                this.putMediaEntry(res, me);
            }
            this.flush();
            success = true;
            logger.info("Successfully recovered media library file: " + this.file);
        }
        finally {
            if (!success) {
                this.raf.close();
            }
        }
        this.setDirty(false);
    }

    @Override
    public synchronized long compact() throws IOException {
        File f = this.file;
        if (f == null) {
            return 0L;
        }
        logger.info("Compacting media library file: " + f);
        this.flush();
        long oldFileSize = f.length();
        logger.info("Current media library file size: " + oldFileSize);
        boolean force = false;
        this.recover(force);
        long newFileSize = f.length();
        long deltaFileSize = newFileSize - oldFileSize;
        logger.info("Compacted media library file size: " + newFileSize + " (" + deltaFileSize + ")");
        return deltaFileSize;
    }

    @Override
    public synchronized void removeAllMediaEntries() throws IOException {
        File f = this.file;
        if (f == null) {
            return;
        }
        logger.info("Removing all media entries: " + f);
        if (this.index == null) {
            this.initIndex();
        }
        this.index.clear();
        this.newDataEntries.clear();
        this.indexBlocks.clear();
        this.dataBlocks.clear();
        this.raf.setLength(0L);
        this.writeFileHeader();
        this.writeDirtyFlag((byte)-50);
        this.footerOffset = 17L;
    }

    protected class Scanner
    implements LibraryScanner {
        private Iterator iter;
        private MediaEntry entry;

        public Scanner() throws IOException {
            LinkedList list = new LinkedList();
            LibraryFileV1.this.getAllMediaEntries(list);
            this.iter = list.iterator();
        }

        @Override
        public boolean next() throws IOException {
            if (this.iter.hasNext()) {
                this.entry = (MediaEntry)this.iter.next();
                return true;
            }
            return false;
        }

        @Override
        public MediaEntry getMediaEntry() throws IOException {
            return this.entry;
        }
    }

    protected static class DataBlock
    extends Block {
        protected int head;

        public DataBlock(long ofs, int len, int head) {
            super(ofs, len);
            this.head = head;
        }
    }

    protected static class IndexBlock
    extends Block {
        protected int head;

        public IndexBlock(long ofs, int len, int head) {
            super(ofs, len);
            this.head = head;
        }
    }

    protected static abstract class Block {
        protected long ofs;
        protected int len;
        protected boolean dirty;

        public Block(long ofs, int len) {
            this.ofs = ofs;
            this.len = len;
        }
    }

    protected static class IndexEntry {
        protected long ofs;
        protected IndexEntry next;

        public IndexEntry(long ofs, IndexEntry next) {
            this.ofs = ofs;
            this.next = next;
        }
    }

    protected static class DataEntry {
        protected int type;
        protected int hash;
        protected byte[] data;

        public DataEntry() {
        }

        public DataEntry(int type, int hash, byte[] data) {
            this.type = type;
            this.hash = hash;
            this.data = data;
        }
    }
}

