/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.library;

import com.spacekiller.util.Resource;
import com.spacekiller.util.buffer.ByteArrayDataInput;
import com.spacekiller.util.media.DefaultMediaEntry;
import com.spacekiller.util.media.MediaContext;
import com.spacekiller.util.media.MediaEntry;
import com.spacekiller.util.media.MutableMediaEntry;
import com.spacekiller.util.media.UnknownMediaEntry;
import com.spacekiller.util.media.library.CachedRandomAccessFile;
import com.spacekiller.util.media.library.DirectoryCacheEntry;
import com.spacekiller.util.media.library.LibraryFile;
import com.spacekiller.util.media.library.LibraryScanner;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.StreamCorruptedException;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LibraryFileV2
implements LibraryFile {
    private static final Logger logger = Logger.getLogger(LibraryFileV2.class.getName());
    protected static final int VERSION_2 = 2;
    protected static final int VERSION = 2;
    private static final byte DIRTY = 127;
    private static final byte CLEAN = -50;
    private static final int FILE_HEADER_LENGTH = 17;
    private static final int PAGE_TYPE_INDEX = 1111;
    private static final int PAGE_TYPE_BLOCK = 2222;
    private static final int PAGE_TYPE_HOLE = 5555;
    private static final int PAGE_TYPE_FOOTER = 7777;
    private static final int PAGE_HEADER_LENGTH = 9;
    private static final int PAGE_HEADER_OFFSET_DIRTY = 8;
    private static final int INDEX_HEADER_LENGTH = 8;
    private static final int INDEX_SLOT_LENGTH = 8;
    private static final int BLOCK_PAGE_HEADER_LENGTH = 12;
    private static final int BLOCK_HEADER_LENGTH = 20;
    private static final int BLOCK_HEADER_OFFSET_TYPE = 12;
    public static final int MAX_ENTRY_DATA_LENGTH = 0x100000;
    public static final int DEFAULT_BLOCK_PAGE_DATA_LENGTH = 0x100000;
    public static final int INIT_INDEX_TABLE_LENGTH = 1024;
    public static final long MAX_INDEX_ENTRIES = 0x7FFFFFFEL;
    public static final long NULL = 0L;
    public static final int TYPE_DELETED = 0;
    public static final int TYPE_DEFAULT_MEDIA_ENTRY = 1976;
    public static final int TYPE_UNKNOWN_MEDIA_ENTRY = 9999;
    public static final int TYPE_DIRECTORY_CACHE_ENTRY = 7438;
    private MediaContext context;
    private File file;
    private CachedRandomAccessFile raf;
    private boolean closed;
    private long headerLength = -1L;
    private long footerOffset = -1L;
    private boolean dirty;
    private byte[] buf;
    private ByteArrayDataInput bdi;
    private Baos baos;
    private DataOutputStream dos;
    private Page firstPage;
    private Page lastPage;
    private Index index;
    private long indexThreshold;
    private IndexPage indexPage;
    private long entryCount;
    private int modCount;
    private double indexThresholdFactor = 0.8;

    public LibraryFileV2(MediaContext context, File file, CachedRandomAccessFile raf, int bufSize) throws IOException {
        this.context = context;
        this.file = file;
        this.raf = raf;
        this.buf = new byte[bufSize];
        this.bdi = new ByteArrayDataInput(this.buf, 0, this.buf.length);
        this.baos = new Baos(bufSize);
        this.dos = new DataOutputStream(this.baos);
        this.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void open() throws IOException {
        LibraryFileV2 libraryFileV2 = this;
        synchronized (libraryFileV2) {
            HolePage firstPage = null;
            HolePage lastPage = null;
            long dirtyPageCount = 0L;
            long headerLength = -1L;
            long footerOffset = -1L;
            long entryCount = 0L;
            CachedRandomAccessFile cachedRandomAccessFile = this.raf;
            synchronized (cachedRandomAccessFile) {
                long fileLen = this.raf.length();
                if (fileLen > 0L) {
                    this.raf.seek(0L);
                    int magic = this.raf.readInt();
                    if (magic != -1105627430) {
                        throw new StreamCorruptedException("Invalid media library file: " + magic + " != " + -1105627430);
                    }
                    int ver = this.raf.readInt();
                    if (ver < 2 || ver > 2) {
                        throw new StreamCorruptedException("Invalid media library file version: " + ver + " (current=" + 2 + ")");
                    }
                    byte dirt = this.raf.readByte();
                    if (dirt != -50) {
                        if (logger.isLoggable(Level.WARNING)) {
                            logger.warning("Dirty or corrupted media library file: dirt=" + dirt + " != " + -50);
                        }
                        this.setDirty(true);
                    }
                    if ((headerLength = this.raf.readLong()) < 17L) {
                        throw new StreamCorruptedException("Invalid first media library offset: " + headerLength + " < " + 17);
                    }
                    if (headerLength > fileLen) {
                        throw new StreamCorruptedException("Invalid first media library offset: " + headerLength + " > " + fileLen);
                    }
                    long pagePos = headerLength;
                    HolePage prevPage = null;
                    while (true) {
                        Page page;
                        if (pagePos + 9L > fileLen) {
                            if (pagePos == fileLen) break;
                            this.setDirty(true);
                            break;
                        }
                        this.raf.seek(pagePos);
                        int pageLen = this.raf.readInt();
                        if (pageLen < 9) {
                            throw new StreamCorruptedException("Invalid page length: " + pageLen + " < " + 9);
                        }
                        int pageType = this.raf.readInt();
                        boolean pageDirty = this.raf.readByte() != -50;
                        switch (pageType) {
                            case 1111: {
                                int tabLen;
                                long count = this.raf.readLong();
                                if (count < 0L) {
                                    logger.warning("Invalid index block count: " + count);
                                    pageDirty = true;
                                    count = 0L;
                                }
                                if (count > 0x7FFFFFFEL) {
                                    logger.warning("Invalid index block count: " + count + " > " + 0x7FFFFFFEL);
                                    pageDirty = true;
                                    count = 0L;
                                }
                                if ((tabLen = (pageLen - 9 - 8) / 8) < 1) {
                                    logger.warning("Invalid index table length: " + tabLen);
                                    pageDirty = true;
                                    tabLen = 0;
                                }
                                IndexPage indexPage = new IndexPage(pagePos, pageLen, pageType, tabLen);
                                indexPage.dirty = pageDirty;
                                indexPage.count = count;
                                page = indexPage;
                                break;
                            }
                            case 2222: {
                                int blockCount = this.raf.readInt();
                                int startOffset = this.raf.readInt();
                                int endOffset = this.raf.readInt();
                                if (blockCount < 0) {
                                    logger.warning("Invalid block count: " + blockCount);
                                    pageDirty = true;
                                    blockCount = 0;
                                }
                                if (startOffset < 0) {
                                    logger.warning("Invalid block start offset: " + startOffset);
                                    pageDirty = true;
                                    startOffset = -1;
                                }
                                if (startOffset >= pageLen) {
                                    logger.warning("Invalid block start offset: " + startOffset + " >= " + pageLen);
                                    pageDirty = true;
                                    startOffset = -1;
                                }
                                if (endOffset > pageLen) {
                                    logger.warning("Invalid block end offset: " + endOffset + " > " + pageLen);
                                    pageDirty = true;
                                    endOffset = -1;
                                }
                                if (endOffset < startOffset) {
                                    logger.warning("Invalid block end offset: " + endOffset + " < " + startOffset);
                                    pageDirty = true;
                                    endOffset = -1;
                                }
                                entryCount += (long)blockCount;
                                BlockPage blockPage = new BlockPage(pagePos, pageLen, pageType);
                                blockPage.dirty = pageDirty;
                                blockPage.type = pageType;
                                blockPage.len = pageLen;
                                blockPage.count = blockCount;
                                blockPage.startOffset = startOffset;
                                blockPage.endOffset = endOffset;
                                page = blockPage;
                                break;
                            }
                            case 5555: {
                                HolePage holePage = new HolePage(pagePos, pageLen, pageType);
                                holePage.dirty = pageDirty;
                                holePage.type = pageType;
                                holePage.len = pageLen;
                                page = holePage;
                                break;
                            }
                            case 7777: {
                                footerOffset = pagePos;
                                page = null;
                                break;
                            }
                            default: {
                                throw new StreamCorruptedException("Invalid page type: #" + pageType + ", pagePos=" + pagePos + ", file=" + this.file);
                            }
                        }
                        if (page != null) {
                            if (pageDirty) {
                                ++dirtyPageCount;
                            }
                            if (prevPage == null) {
                                firstPage = page;
                            } else {
                                page.prev = prevPage;
                                prevPage.next = page;
                            }
                            lastPage = page;
                        }
                        prevPage = page;
                        pagePos += (long)pageLen;
                    }
                    if (footerOffset < 0L) {
                        footerOffset = pagePos;
                        this.setDirty(true);
                    }
                    this.headerLength = headerLength;
                    this.footerOffset = footerOffset;
                } else {
                    headerLength = 17L;
                    footerOffset = 17L;
                    this.headerLength = headerLength;
                    this.footerOffset = footerOffset;
                    this.writeHeader();
                    this.writeFooter();
                }
            }
            this.firstPage = firstPage;
            this.lastPage = lastPage;
            this.entryCount = entryCount;
            if (dirtyPageCount > 0L) {
                this.setDirty(true);
            }
            this.openIndex();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeHeader() throws IOException {
        LibraryFileV2 libraryFileV2 = this;
        synchronized (libraryFileV2) {
            CachedRandomAccessFile cachedRandomAccessFile = this.raf;
            synchronized (cachedRandomAccessFile) {
                this.raf.seek(0L);
                this.raf.writeInt(-1105627430);
                this.raf.writeInt(2);
                this.raf.writeByte(-50);
                this.raf.writeLong(this.headerLength);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeFooter() throws IOException {
        LibraryFileV2 libraryFileV2 = this;
        synchronized (libraryFileV2) {
            CachedRandomAccessFile cachedRandomAccessFile = this.raf;
            synchronized (cachedRandomAccessFile) {
                this.raf.seek(this.footerOffset);
                this.raf.writeInt(9);
                this.raf.writeInt(7777);
                this.raf.writeByte(-50);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void openIndex() throws IOException {
        LibraryFileV2 libraryFileV2 = this;
        synchronized (libraryFileV2) {
            long indexThreshold;
            IndexPage indexPage = null;
            Page p = this.firstPage;
            while (p != null) {
                if (p instanceof IndexPage) {
                    indexPage = (IndexPage)p;
                    break;
                }
                p = p.next;
            }
            if (indexPage == null) {
                indexPage = this.createIndexPage(1024);
            }
            this.indexThreshold = indexThreshold = this.computeIndexThreshold(indexPage.tabLen);
            this.indexPage = indexPage;
            this.index = indexPage;
        }
    }

    protected long computeIndexThreshold(long tabLen) {
        return (long)((double)tabLen * this.indexThresholdFactor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IndexPage rebuildIndex(int tabLen) throws IOException {
        IndexPage newIndexPage;
        LibraryFileV2 libraryFileV2 = this;
        synchronized (libraryFileV2) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("rebuildIndex: tabLen=" + tabLen + ", entryCount=" + this.entryCount + ", file=" + this.file);
            }
            CachedRandomAccessFile cachedRandomAccessFile = this.raf;
            synchronized (cachedRandomAccessFile) {
                int indexTableLen = tabLen;
                newIndexPage = this.createIndexPage(indexTableLen);
                Page p = this.firstPage;
                while (p != null) {
                    if (p instanceof BlockPage) {
                        int len;
                        int off;
                        BlockPage page = (BlockPage)p;
                        int end = page.endOffset;
                        if (off < 21) {
                            throw new StreamCorruptedException("Invalid page start offset: " + off + " < " + 21);
                        }
                        if (end > page.len) {
                            throw new StreamCorruptedException("Invalid page end offset: " + end + " > " + page.len);
                        }
                        if (end < off) {
                            throw new StreamCorruptedException("Invalid page start/end offset: " + end + " < " + off);
                        }
                        for (off = page.startOffset; off < end; off += 20 + len) {
                            long pos = page.pos + (long)off;
                            this.raf.seek(pos);
                            this.raf.readLong();
                            int hash = this.raf.readInt();
                            int type = this.raf.readInt();
                            len = this.raf.readInt();
                            if (len < 0) {
                                throw new StreamCorruptedException("Invalid entry data length: " + len + " < 0, pos=" + pos + ", type=" + type + ", page=" + page);
                            }
                            if (len > 0x100000) {
                                throw new StreamCorruptedException("Invalid entry data length: " + len + " > " + 0x100000 + ", pos=" + pos + ", type=" + type + ", page=" + page);
                            }
                            if (type == 0) continue;
                            int slot = newIndexPage.slot(hash);
                            long old = newIndexPage.read(slot);
                            this.raf.seek(pos);
                            this.raf.writeLong(old);
                            newIndexPage.write(slot, pos);
                        }
                    }
                    p = p.next;
                }
            }
        }
        return newIndexPage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IndexPage createIndexPage(int indexTableLen) throws IOException {
        IndexPage newPage;
        int pageLen = 17 + indexTableLen * 8;
        LibraryFileV2 libraryFileV2 = this;
        synchronized (libraryFileV2) {
            boolean clean = true;
            long pos = this.createPage(1111, pageLen, clean);
            newPage = new IndexPage(pos, pageLen, 1111, indexTableLen);
            if (this.lastPage == null) {
                this.firstPage = newPage;
            } else {
                newPage.prev = this.lastPage;
                this.lastPage.next = newPage;
            }
            this.lastPage = newPage;
        }
        return newPage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BlockPage createBlockPage(int blockDataLen) throws IOException {
        BlockPage newPage;
        int pageLen = 21 + blockDataLen;
        LibraryFileV2 libraryFileV2 = this;
        synchronized (libraryFileV2) {
            boolean clean = false;
            long pos = this.createPage(2222, pageLen, clean);
            newPage = new BlockPage(pos, pageLen, 2222);
            newPage.startOffset = 21;
            newPage.endOffset = 21;
            if (this.lastPage == null) {
                this.firstPage = newPage;
            } else {
                newPage.prev = this.lastPage;
                this.lastPage.next = newPage;
            }
            this.lastPage = newPage;
        }
        return newPage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long createPage(int pageType, int pageLen, boolean clean) throws IOException {
        long pos;
        if (pageLen < 9) {
            throw new IllegalArgumentException("Invalid page length: " + pageLen + " < " + 9);
        }
        LibraryFileV2 libraryFileV2 = this;
        synchronized (libraryFileV2) {
            pos = this.footerOffset;
            this.footerOffset += (long)pageLen;
            CachedRandomAccessFile cachedRandomAccessFile = this.raf;
            synchronized (cachedRandomAccessFile) {
                this.writeFooter();
                this.raf.seek(pos);
                this.raf.writeInt(pageLen);
                this.raf.writeInt(pageType);
                this.raf.writeByte(127);
                if (clean) {
                    int n;
                    Arrays.fill(this.buf, (byte)0);
                    for (int num = pageLen - 9; num > 0; num -= n) {
                        n = Math.min(num, this.buf.length);
                        this.raf.write(this.buf, 0, n);
                    }
                }
                this.raf.seek(pos + 8L);
                this.raf.writeByte(-50);
            }
        }
        return pos;
    }

    @Override
    public boolean containsMediaEntry(Resource resource) throws IOException {
        return this.getMediaEntry(resource) != null;
    }

    @Override
    public MediaEntry getMediaEntry(Resource resource) throws IOException {
        String path = resource.toString();
        int hash = path.hashCode();
        LibraryFileV2 libraryFileV2 = this;
        synchronized (libraryFileV2) {
            int slot = this.index.slot(hash);
            CachedRandomAccessFile cachedRandomAccessFile = this.raf;
            synchronized (cachedRandomAccessFile) {
                long pos = this.index.read(slot);
                if (pos == 0L) {
                    return null;
                }
                if (pos >= this.footerOffset) {
                    throw new StreamCorruptedException("Invalid entry position: " + pos + " >= " + this.footerOffset);
                }
                while (true) {
                    if (pos < 17L) {
                        throw new StreamCorruptedException("Invalid entry position: " + pos + " < " + 17);
                    }
                    this.raf.seek(pos);
                    long nex = this.raf.readLong();
                    int h = this.raf.readInt();
                    if (h == hash) {
                        int typ = this.raf.readInt();
                        int len = this.raf.readInt();
                        if (len < 0) {
                            throw new StreamCorruptedException("Invalid entry data length: " + len + " < 0");
                        }
                        if (len > 0x100000) {
                            throw new StreamCorruptedException("Invalid entry data length: " + len + " > " + 0x100000);
                        }
                        MediaEntry me = this.readEntry(typ, len);
                        if (me != null && resource.equals(me.getResource())) {
                            return me;
                        }
                    }
                    if (nex == 0L) {
                        return null;
                    }
                    if (nex >= pos) {
                        throw new StreamCorruptedException("Invalid entry position: " + nex + " >= " + pos);
                    }
                    pos = nex;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putMediaEntry(Resource resource, MediaEntry entry) throws IOException {
        int type = this.getEntryType(entry);
        if (type < 0) {
            throw new IOException("Unsupported media entry type: " + type);
        }
        String path = resource.toString();
        int hash = path.hashCode();
        LibraryFileV2 libraryFileV2 = this;
        synchronized (libraryFileV2) {
            this.baos.reset();
            entry.writeEntry((DataOutput)this.dos);
            this.dos.flush();
            int dataLen = this.baos.size();
            int slot = this.index.slot(hash);
            CachedRandomAccessFile cachedRandomAccessFile = this.raf;
            synchronized (cachedRandomAccessFile) {
                long nextSlotPos;
                long nex;
                long firstPos = this.index.read(slot);
                if (firstPos >= this.footerOffset) {
                    throw new StreamCorruptedException("Invalid entry position: " + firstPos + " >= " + this.footerOffset);
                }
                long pre = 0L;
                long pos = firstPos;
                while (pos != 0L) {
                    if (pos < 17L) {
                        throw new StreamCorruptedException("Invalid entry position: " + pos + " < " + 17);
                    }
                    this.raf.seek(pos);
                    nex = this.raf.readLong();
                    int h = this.raf.readInt();
                    if (h == hash) {
                        int typ = this.raf.readInt();
                        int len = this.raf.readInt();
                        if (len < 0) {
                            throw new StreamCorruptedException("Invalid entry data length: " + len + " < 0");
                        }
                        if (len > 0x100000) {
                            throw new StreamCorruptedException("Invalid entry data length: " + len + " > " + 0x100000);
                        }
                        MediaEntry me = this.readEntry(typ, len);
                        if (me != null && resource.equals(me.getResource())) {
                            if (len == dataLen) {
                                this.raf.seek(pos + 20L);
                                int num = this.baos.writeTo(this.raf);
                                if (num != dataLen) {
                                    throw new IOException("Unexpected entry data size: " + num + " != " + dataLen);
                                }
                                return;
                            }
                            this.raf.seek(pos + 12L);
                            this.raf.writeInt(0);
                            --this.entryCount;
                            if (pre == 0L) {
                                this.index.write(slot, nex);
                            } else {
                                this.raf.seek(pre);
                                this.raf.writeLong(nex);
                            }
                            pos = pre;
                        }
                    }
                    if (nex == 0L) {
                        pos = 0L;
                        break;
                    }
                    if (nex >= pos && pos != 0L) {
                        throw new StreamCorruptedException("Invalid entry position: " + nex + " >= " + pos);
                    }
                    pre = pos;
                    pos = nex;
                }
                if (pos == 0L) {
                    pos = this.allocate(20 + dataLen);
                }
                if (pos > firstPos) {
                    nextSlotPos = firstPos;
                    this.index.write(slot, pos);
                } else {
                    long prevSlotPos = firstPos;
                    while (true) {
                        if (prevSlotPos < 17L) {
                            throw new StreamCorruptedException("Invalid entry position: " + prevSlotPos + " < " + 17);
                        }
                        this.raf.seek(prevSlotPos);
                        nex = this.raf.readLong();
                        if (pos > nex) {
                            this.raf.seek(prevSlotPos);
                            this.raf.writeLong(pos);
                            nextSlotPos = nex;
                            break;
                        }
                        prevSlotPos = nex;
                    }
                }
                this.raf.seek(pos);
                this.raf.writeLong(nextSlotPos);
                this.raf.writeInt(hash);
                this.raf.writeInt(type);
                this.raf.writeInt(dataLen);
                int num = this.baos.writeTo(this.raf);
                this.raf.flush();
                if (num != dataLen) {
                    throw new IOException("Unexpected entry data size: " + num + " != " + dataLen);
                }
                ++this.entryCount;
                if (this.entryCount > this.indexThreshold) {
                    long newTabLen = this.entryCount * 2L;
                    if (newTabLen < 1024L) {
                        newTabLen = 1024L;
                    }
                    if (newTabLen > Integer.MAX_VALUE) {
                        throw new IllegalStateException("Invalid newTabLen: " + newTabLen);
                    }
                    IndexPage oldIndexPage = this.indexPage;
                    long indexThreshold = this.computeIndexThreshold(newTabLen);
                    long ms = System.currentTimeMillis();
                    IndexPage newIndexPage = this.rebuildIndex((int)newTabLen);
                    long rebuildTime = System.currentTimeMillis() - ms;
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer("New Index: entryCount=" + this.entryCount + ", time=" + rebuildTime + " ms.");
                    }
                    this.indexPage = newIndexPage;
                    this.index = newIndexPage;
                    this.indexThreshold = indexThreshold;
                    if (oldIndexPage != null) {
                        long oldPos = oldIndexPage.pos;
                        if (oldPos < this.headerLength) {
                            throw new StreamCorruptedException("Invalid page position: " + oldPos + " < " + this.headerLength);
                        }
                        if (oldPos >= this.footerOffset) {
                            throw new StreamCorruptedException("Invalid page position: " + oldPos + " >= " + this.footerOffset);
                        }
                        this.raf.seek(oldPos);
                        this.raf.readInt();
                        this.raf.writeInt(5555);
                    }
                }
            }
            ++this.modCount;
        }
    }

    @Override
    public boolean removeMediaEntry(Resource resource) throws IOException {
        String path = resource.toString();
        int hash = path.hashCode();
        LibraryFileV2 libraryFileV2 = this;
        synchronized (libraryFileV2) {
            int slot = this.index.slot(hash);
            CachedRandomAccessFile cachedRandomAccessFile = this.raf;
            synchronized (cachedRandomAccessFile) {
                long pos = this.index.read(slot);
                if (pos == 0L) {
                    return false;
                }
                if (pos >= this.footerOffset) {
                    throw new StreamCorruptedException("Invalid entry position: " + pos + " >= " + this.footerOffset);
                }
                long pre = 0L;
                while (true) {
                    if (pos < 17L) {
                        throw new StreamCorruptedException("Invalid entry position: " + pos + " < " + 17);
                    }
                    this.raf.seek(pos);
                    long nex = this.raf.readLong();
                    int h = this.raf.readInt();
                    if (h == hash) {
                        int typ = this.raf.readInt();
                        int len = this.raf.readInt();
                        if (len < 0) {
                            throw new StreamCorruptedException("Invalid entry data length: " + len + " < 0");
                        }
                        if (len > 0x100000) {
                            throw new StreamCorruptedException("Invalid entry data length: " + len + " > " + 0x100000);
                        }
                        MediaEntry me = this.readEntry(typ, len);
                        if (me != null && resource.equals(me.getResource())) {
                            this.raf.seek(pos + 12L);
                            this.raf.writeInt(0);
                            --this.entryCount;
                            if (pre == 0L) {
                                this.index.write(slot, nex);
                            } else {
                                this.raf.seek(pre);
                                this.raf.writeLong(nex);
                            }
                            this.raf.flush();
                            return true;
                        }
                    }
                    if (nex == 0L) {
                        return false;
                    }
                    if (nex >= pos && pos != 0L) {
                        throw new StreamCorruptedException("Invalid entry position: " + nex + " >= " + pos);
                    }
                    pre = pos;
                    pos = nex;
                }
            }
        }
    }

    @Override
    public LibraryScanner createLibraryScanner() throws IOException {
        return new ScannerImpl();
    }

    @Override
    public void getAllMediaEntries(Collection dst) throws IOException {
        LibraryScanner scanner = this.createLibraryScanner();
        while (scanner.next()) {
            dst.add(scanner.getMediaEntry());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllMediaEntries() throws IOException {
        LibraryFileV2 libraryFileV2 = this;
        synchronized (libraryFileV2) {
            CachedRandomAccessFile cachedRandomAccessFile = this.raf;
            synchronized (cachedRandomAccessFile) {
                this.raf.setLength(0L);
            }
            this.open();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        LibraryFileV2 libraryFileV2 = this;
        synchronized (libraryFileV2) {
            if (this.raf != null) {
                CachedRandomAccessFile cachedRandomAccessFile = this.raf;
                synchronized (cachedRandomAccessFile) {
                    if (this.closed) {
                        return;
                    }
                    this.raf.flush();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        LibraryFileV2 libraryFileV2 = this;
        synchronized (libraryFileV2) {
            if (this.raf != null) {
                CachedRandomAccessFile cachedRandomAccessFile = this.raf;
                synchronized (cachedRandomAccessFile) {
                    if (this.closed) {
                        return;
                    }
                    this.flush();
                    this.raf.close();
                    this.closed = true;
                }
            }
        }
    }

    protected int getEntryType(MediaEntry entry) {
        Class<?> type = entry.getClass();
        if (type == DefaultMediaEntry.class) {
            return 1976;
        }
        if (type == UnknownMediaEntry.class) {
            return 9999;
        }
        if (type == DirectoryCacheEntry.class) {
            return 7438;
        }
        return -1;
    }

    protected MutableMediaEntry createEntry(int type) throws IllegalArgumentException {
        switch (type) {
            case 1976: {
                return new DefaultMediaEntry();
            }
            case 9999: {
                return new UnknownMediaEntry();
            }
            case 7438: {
                return new DirectoryCacheEntry();
            }
            case 0: {
                return null;
            }
        }
        throw new IllegalArgumentException("Unsupported media entry type: " + type);
    }

    private MediaEntry readEntry(int type, int len) throws IOException {
        if (len > this.buf.length) {
            this.buf = new byte[len];
        }
        this.raf.readFully(this.buf, 0, len);
        this.bdi.setBuffer(this.buf, 0, len);
        MutableMediaEntry me = this.createEntry(type);
        if (me != null) {
            me.readEntry((DataInput)this.bdi, this.context);
        }
        return me;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean scan(ScannerImpl s) throws IOException {
        BlockPage page = s.page;
        int offset = s.offset;
        int length = s.length;
        Page p = page;
        LibraryFileV2 libraryFileV2 = this;
        synchronized (libraryFileV2) {
            CachedRandomAccessFile cachedRandomAccessFile = this.raf;
            synchronized (cachedRandomAccessFile) {
                if (length < 0 && p == null) {
                    s.origModCount = this.modCount;
                    p = this.firstPage;
                    offset = 0;
                    length = 0;
                } else if (this.modCount != s.origModCount) {
                    long minPos = 0L;
                    if (page != null) {
                        minPos = page.pos + (long)offset + (long)length;
                        page = null;
                    }
                    s.origModCount = this.modCount;
                    p = this.firstPage;
                    while (p != null) {
                        if (p instanceof BlockPage && minPos > p.pos && minPos < p.pos + (long)p.len) {
                            long pos;
                            page = p;
                            length = 0;
                            for (offset = page.startOffset; offset < page.endOffset && (pos = page.pos + (long)offset + 12L) < minPos; offset += length) {
                                this.raf.seek(pos);
                                this.raf.readInt();
                                int len = this.raf.readInt();
                                if (len < 0) {
                                    throw new StreamCorruptedException("Invalid entry data length: " + len + " < 0");
                                }
                                if (len > 0x100000) {
                                    throw new StreamCorruptedException("Invalid entry data length: " + len + " > " + 0x100000);
                                }
                                length = 20 + len;
                            }
                            if (offset < page.endOffset) break;
                        }
                        p = p.next;
                    }
                }
                while (p != null) {
                    block20: {
                        if (p instanceof BlockPage) {
                            int len;
                            int type;
                            MediaEntry entry;
                            page = p;
                            do {
                                offset = length > 0 ? (offset += length) : page.startOffset;
                                if (offset >= page.endOffset) break block20;
                                long pos = page.pos + (long)offset + 12L;
                                this.raf.seek(pos);
                                type = this.raf.readInt();
                                len = this.raf.readInt();
                                if (len < 0) {
                                    throw new StreamCorruptedException("Invalid entry data length: " + len + " < 0");
                                }
                                if (len > 0x100000) {
                                    throw new StreamCorruptedException("Invalid entry data length: " + len + " > " + 0x100000);
                                }
                                length = 20 + len;
                            } while ((entry = this.readEntry(type, len)) == null);
                            s.page = page;
                            s.offset = offset;
                            s.length = length;
                            s.entry = entry;
                            return true;
                        }
                    }
                    p = p.next;
                    offset = 0;
                    length = 0;
                }
            }
        }
        s.page = null;
        s.offset = 0;
        s.length = 0;
        s.entry = null;
        return false;
    }

    private long allocate(int size) throws IOException {
        BlockPage page = null;
        int ofs = -1;
        Page p = this.lastPage;
        while (p != null) {
            if (p instanceof BlockPage) {
                BlockPage bp = (BlockPage)p;
                ofs = bp.endOffset;
                if (ofs + size <= bp.len) {
                    page = bp;
                    break;
                }
            }
            p = p.prev;
        }
        if (page == null) {
            int blockDataLen = 0x100000;
            if (size > blockDataLen) {
                blockDataLen = size;
            }
            page = this.createBlockPage(blockDataLen);
            ofs = page.endOffset;
        }
        ++page.count;
        page.endOffset = ofs + size;
        this.raf.seek(page.pos + 9L);
        this.raf.writeInt(page.count);
        this.raf.writeInt(page.startOffset);
        this.raf.writeInt(page.endOffset);
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("allocate: size=" + size + ", page=" + page + ", pos=" + (page.pos + (long)ofs));
        }
        return page.pos + (long)ofs;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    protected void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long check() throws IOException {
        long blockCount = 0L;
        LibraryFileV2 libraryFileV2 = this;
        synchronized (libraryFileV2) {
            CachedRandomAccessFile cachedRandomAccessFile = this.raf;
            synchronized (cachedRandomAccessFile) {
                blockCount = this.checkBlocks();
                this.checkIndex();
            }
        }
        return blockCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long checkBlocks() throws IOException {
        long totalBlocks = 0L;
        LibraryFileV2 libraryFileV2 = this;
        synchronized (libraryFileV2) {
            logger.info("Checking blocks: file=" + this.file);
            CachedRandomAccessFile cachedRandomAccessFile = this.raf;
            synchronized (cachedRandomAccessFile) {
                Page prev = null;
                Page p = this.firstPage;
                while (p != null) {
                    if (p.prev != prev) {
                        throw new StreamCorruptedException("Invalid previous page: " + p.prev + " != " + prev);
                    }
                    if (prev == null) {
                        if (p.pos != this.headerLength) {
                            throw new StreamCorruptedException("Invaid first page position: " + p.pos + " != " + this.headerLength);
                        }
                    } else {
                        long expectedPos = prev.pos + (long)prev.len;
                        if (p.pos != expectedPos) {
                            throw new StreamCorruptedException("Invaid page position: " + p.pos + " != " + expectedPos);
                        }
                    }
                    if (p.len < 9) {
                        throw new StreamCorruptedException("Invalid page length: " + p.len + " < " + 9);
                    }
                    if (p instanceof BlockPage) {
                        BlockPage bp = (BlockPage)p;
                        int endOffset = bp.endOffset;
                        int blockPageHeaderLen = 21;
                        if (endOffset < blockPageHeaderLen) {
                            throw new StreamCorruptedException("Invalid block page end offset: " + endOffset + " < " + blockPageHeaderLen);
                        }
                        if (endOffset > p.len) {
                            throw new StreamCorruptedException("Invalid block page end offset: " + endOffset + " > " + p.len + ", page=" + p);
                        }
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine("Checking page: " + p + ", count=" + bp.count);
                        }
                        int blockNum = 0;
                        int blockOfs = blockPageHeaderLen;
                        while (blockOfs < endOffset) {
                            String info;
                            this.raf.seek(p.pos + (long)blockOfs);
                            long nextSlotPos = this.raf.readLong();
                            int hashCode = this.raf.readInt();
                            int type = this.raf.readInt();
                            int dataLen = this.raf.readInt();
                            if (dataLen < 0) {
                                info = ", type=#" + type + ", dataLen=" + dataLen + ", page=" + p;
                                throw new StreamCorruptedException("Invalid block data length: " + dataLen + " < 0" + info);
                            }
                            if (dataLen > endOffset - blockOfs) {
                                info = ", type=#" + type + ", dataLen=" + dataLen + ", page=" + p;
                                throw new StreamCorruptedException("Invalid block data length: " + dataLen + " > " + (endOffset - blockOfs) + info);
                            }
                            if (dataLen > 0x100000) {
                                info = ", type=#" + type + ", dataLen=" + dataLen + ", page=" + p;
                                throw new StreamCorruptedException("Invalid block data length: " + dataLen + " > " + 0x100000 + info);
                            }
                            if (nextSlotPos < 17L && nextSlotPos != 0L) {
                                info = ", type=#" + type + ", dataLen=" + dataLen + ", page=" + p;
                                throw new StreamCorruptedException("Invalid next slot position: " + nextSlotPos + " < " + 17 + info);
                            }
                            if (nextSlotPos >= this.footerOffset) {
                                info = ", type=#" + type + ", dataLen=" + dataLen + ", page=" + p;
                                throw new StreamCorruptedException("Invalid next slot position: " + nextSlotPos + " >= " + this.footerOffset + info);
                            }
                            MutableMediaEntry entry = this.createEntry(type);
                            if (entry != null) {
                                entry.readEntry((DataInput)this.raf, this.context);
                                Resource resource = entry.getResource();
                                if (resource == null) {
                                    throw new StreamCorruptedException("Invalid entry resource: " + resource);
                                }
                                String path = resource.toString();
                                int hash = path.hashCode();
                                if (hashCode != hash) {
                                    throw new StreamCorruptedException("Invalid entry hash-code: " + hashCode + " != " + hash);
                                }
                            }
                            blockOfs += 20 + dataLen;
                            ++blockNum;
                        }
                        if (blockNum != bp.count) {
                            throw new StreamCorruptedException("Invalid number of blocks: " + blockNum + " != " + bp.count + ", page=" + bp);
                        }
                        totalBlocks += (long)blockNum;
                    }
                    prev = p;
                    p = p.next;
                }
                if (this.lastPage != prev) {
                    throw new StreamCorruptedException("Invaid last page: " + this.lastPage + " != " + prev);
                }
            }
        }
        logger.info("Number of blocks: " + totalBlocks);
        return totalBlocks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkIndex() throws IOException {
        LibraryFileV2 libraryFileV2 = this;
        synchronized (libraryFileV2) {
            logger.info("Checking index: file=" + this.file);
            CachedRandomAccessFile cachedRandomAccessFile = this.raf;
            synchronized (cachedRandomAccessFile) {
                IndexPage indexPage = null;
                Page p = this.firstPage;
                while (p != null) {
                    if (p instanceof IndexPage) {
                        indexPage = (IndexPage)p;
                    }
                    p = p.next;
                }
                if (indexPage == null) {
                    return;
                }
                logger.info("FIXME TODO check index: " + indexPage);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long compact() throws IOException {
        LibraryFileV2 libraryFileV2 = this;
        synchronized (libraryFileV2) {
            File f = this.file;
            if (f == null) {
                return 0L;
            }
            logger.info("Compacting media library file: " + f);
            CachedRandomAccessFile cachedRandomAccessFile = this.raf;
            synchronized (cachedRandomAccessFile) {
                this.flush();
                long oldFileSize = f.length();
                logger.info("Current media library file size: " + oldFileSize);
                boolean force = false;
                this.recover(force);
                long newFileSize = f.length();
                long deltaFileSize = newFileSize - oldFileSize;
                logger.info("Compacted media library file size: " + newFileSize + " (" + deltaFileSize + ")");
                return deltaFileSize;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recover(boolean force) throws IOException {
        LibraryFileV2 libraryFileV2 = this;
        synchronized (libraryFileV2) {
            File f = this.file;
            if (f == null) {
                return;
            }
            logger.info("Recovering media library file: " + f);
            CachedRandomAccessFile cachedRandomAccessFile = this.raf;
            synchronized (cachedRandomAccessFile) {
                logger.info("Reading old media entries...");
                LinkedList mediaEntryList = new LinkedList();
                try {
                    this.getAllMediaEntries(mediaEntryList);
                }
                catch (Throwable e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                    if (!force) {
                        throw new IOException("Failed to recover media entries: " + e);
                    }
                }
                finally {
                    int count = mediaEntryList.size();
                    logger.info("Number of recovered media entries: " + count);
                }
                this.raf.close();
                File backupFile = new File(this.file.getPath() + ".bkp");
                if (backupFile.exists() && backupFile.isFile()) {
                    logger.info("Deleting old library backup file: " + backupFile);
                    if (!backupFile.delete()) {
                        throw new IOException("Failed to delete old backup file: " + backupFile);
                    }
                }
                logger.info("Renaming old library file: " + this.file + " -> " + backupFile);
                if (!this.file.renameTo(backupFile)) {
                    throw new IOException("Failed to rename library backup file: " + this.file + " -> " + backupFile);
                }
                this.firstPage = null;
                this.lastPage = null;
                this.index = null;
                logger.info("Creating new library file: " + this.file);
                int cacheSize = 1024;
                this.raf = new CachedRandomAccessFile(this.file, "rw", cacheSize);
                boolean success = false;
                try {
                    this.open();
                    int count = mediaEntryList.size();
                    logger.info("Writing recovered media entries: " + count);
                    for (MediaEntry me : mediaEntryList) {
                        Resource res = me.getResource();
                        if (res == null) continue;
                        this.putMediaEntry(res, me);
                    }
                    this.flush();
                    success = true;
                    logger.info("Successfully recovered media library file: " + this.file);
                }
                finally {
                    if (!success) {
                        this.raf.close();
                    }
                }
                this.setDirty(false);
            }
        }
    }

    protected class Baos
    extends ByteArrayOutputStream {
        public Baos(int size) {
            super(size);
        }

        public int writeTo(RandomAccessFile raf) throws IOException {
            int num = this.count;
            raf.write(this.buf, 0, num);
            return num;
        }
    }

    protected class ScannerImpl
    implements LibraryScanner {
        protected BlockPage page;
        protected int offset = -1;
        protected int length = -1;
        protected MediaEntry entry;
        protected int origModCount;

        @Override
        public boolean next() throws IOException {
            return LibraryFileV2.this.scan(this);
        }

        @Override
        public MediaEntry getMediaEntry() throws IOException {
            if (this.offset < 0) {
                throw new NoSuchElementException();
            }
            return this.entry;
        }

        public BlockPage getPage() {
            if (this.offset < 0) {
                throw new NoSuchElementException();
            }
            return this.page;
        }

        public int getOffset() {
            if (this.offset < 0) {
                throw new NoSuchElementException();
            }
            return this.offset;
        }

        public int getLength() {
            if (this.offset < 0) {
                throw new NoSuchElementException();
            }
            return this.length;
        }
    }

    protected class HolePage
    extends Page {
        public HolePage(long pos, int len, int type) {
            super(pos, len, type);
        }
    }

    protected class BlockPage
    extends Page {
        protected int count;
        protected int startOffset;
        protected int endOffset;

        public BlockPage(long pos, int len, int type) {
            super(pos, len, type);
            this.count = 0;
        }
    }

    protected class IndexPage
    extends Page
    implements Index {
        protected final int tabLen;
        protected final int tabOfs;
        protected long count;

        public IndexPage(long pos, int len, int type, int tabLen) {
            super(pos, len, type);
            this.tabLen = tabLen;
            this.tabOfs = 17;
        }

        @Override
        public int slot(int hash) {
            return (hash & Integer.MAX_VALUE) % this.tabLen;
        }

        @Override
        public long read(int slot) throws IOException {
            long slotPos = this.pos + (long)this.tabOfs + (long)(slot * 8);
            LibraryFileV2.this.raf.seek(slotPos);
            return LibraryFileV2.this.raf.readLong();
        }

        @Override
        public void write(int slot, long newPos) throws IOException {
            long slotPos = this.pos + (long)this.tabOfs + (long)(slot * 8);
            LibraryFileV2.this.raf.seek(slotPos);
            LibraryFileV2.this.raf.writeLong(newPos);
        }
    }

    protected static interface Index {
        public int slot(int var1) throws IOException;

        public long read(int var1) throws IOException;

        public void write(int var1, long var2) throws IOException;
    }

    protected class Page {
        protected Page prev;
        protected Page next;
        protected long pos;
        protected int len;
        protected int type;
        protected boolean dirty;

        protected Page(long pos, int len, int type) {
            this.pos = pos;
            this.len = len;
            this.type = type;
        }

        public String toString() {
            return super.toString() + "[pos=" + this.pos + ", len=" + this.len + ", type=#" + this.type + "]";
        }
    }
}

