/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.library;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public class RandomAccessFileInputStream
extends InputStream {
    private File file;
    private RandomAccessFile raf;
    private long pos;
    private long mark;

    public RandomAccessFileInputStream(File file) throws IOException {
        this.file = file;
        this.raf = new RandomAccessFile(file, "r");
        this.pos = 0L;
        this.mark = -1L;
    }

    @Override
    public void close() throws IOException {
        this.raf.close();
    }

    @Override
    public int read() throws IOException {
        int v = this.raf.read();
        if (v >= 0) {
            ++this.pos;
        }
        return v;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int n = this.raf.read(b, off, len);
        if (n > 0) {
            this.pos += (long)n;
        }
        return n;
    }

    @Override
    public long skip(long n) throws IOException {
        return this.raf.skipBytes((int)Math.min(n, Integer.MAX_VALUE));
    }

    @Override
    public int available() throws IOException {
        long avail = this.raf.length() - this.pos;
        return (int)Math.min(avail, Integer.MAX_VALUE);
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.mark = this.pos;
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.mark < 0L) {
            throw new IOException("Resetting to invalid mark");
        }
        this.seek(this.mark);
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    public void seek(long p) throws IOException {
        this.raf.seek(p);
        this.pos = p;
    }

    public long getPosition() throws IOException {
        return this.pos;
    }

    public File getFile() {
        return this.file;
    }
}

