/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.library;

import com.spacekiller.util.media.SeekableModel;
import com.spacekiller.util.media.SeekableStream;
import com.spacekiller.util.media.library.SeekableFileInputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class SeekableFileInputModel
implements SeekableModel {
    private final File file;

    public SeekableFileInputModel(File file) {
        this.file = file;
    }

    public String toString() {
        return super.toString() + "[" + this.file + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SeekableFileInputStream createInputStream(long pos) throws IOException {
        if (pos < 0L) {
            throw new IOException("Invalid position: " + pos);
        }
        boolean done = false;
        RandomAccessFile raf = new RandomAccessFile(this.file, "r");
        try {
            SeekableFileInputStream fis = new SeekableFileInputStream(this, raf);
            fis.seek(pos);
            done = true;
            SeekableFileInputStream seekableFileInputStream = fis;
            return seekableFileInputStream;
        }
        finally {
            if (!done) {
                raf.close();
            }
        }
    }

    public SeekableStream createStream(long pos) throws IOException {
        return this.createInputStream(pos);
    }

    public void close() throws IOException {
    }
}

