/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.library;

import com.spacekiller.util.media.SeekableStream;
import com.spacekiller.util.media.library.SeekableFileInputModel;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public class SeekableFileInputStream
extends InputStream
implements SeekableStream {
    private final SeekableFileInputModel model;
    private final RandomAccessFile raf;
    private long mark;

    protected SeekableFileInputStream(SeekableFileInputModel model, RandomAccessFile raf) {
        this.model = model;
        this.raf = raf;
        this.mark = -1L;
    }

    public String toString() {
        return super.toString() + "[" + this.model + "]";
    }

    public SeekableFileInputModel getModel() {
        return this.model;
    }

    public InputStream getInputStream() {
        return this;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.raf.close();
    }

    @Override
    public int read() throws IOException {
        return this.raf.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.raf.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.raf.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        long done;
        int num;
        if (n < 1L) {
            return 0L;
        }
        for (done = 0L; done < n; done += (long)num) {
            num = (int)Math.min(n - done, Integer.MAX_VALUE);
            if ((num = this.raf.skipBytes(num)) < 0) break;
        }
        return done > 0L ? done : -1L;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized void mark(int readlimit) {
        try {
            this.mark = this.raf.getFilePointer();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.mark < 0L) {
            throw new IOException("Resetting to invalid mark");
        }
        this.seek(this.mark);
    }

    public long position() throws IOException {
        return this.raf.getFilePointer();
    }

    public void seek(long position) throws IOException {
        this.raf.seek(position);
    }
}

