/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.library;

import com.spacekiller.util.heap.Block;
import com.spacekiller.util.heap.Heap;
import com.spacekiller.util.media.SeekableModel;
import com.spacekiller.util.media.SeekableStream;
import com.spacekiller.util.media.library.SeekableInputEntry;
import com.spacekiller.util.media.library.SeekableInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class SeekableInputModel
implements SeekableModel {
    private final InputStream stream;
    private final Heap heap;
    private final int blockSize;
    private SeekableInputEntry first;
    private SeekableInputEntry last;
    private int streamCount;
    private boolean autoClose;

    public SeekableInputModel(InputStream stream, Heap heap, int blockSize, boolean autoClose) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException("stream=" + stream);
        }
        if (heap == null) {
            throw new IllegalArgumentException("heap=" + heap);
        }
        if (blockSize < 1) {
            throw new IllegalArgumentException("blockSize=" + blockSize);
        }
        this.stream = stream;
        this.heap = heap;
        this.blockSize = blockSize;
        this.autoClose = autoClose;
        this.load(0L);
    }

    protected SeekableInputEntry load(long ofs) throws IOException {
        int off;
        SeekableInputEntry entry;
        block11: {
            block12: {
                int num = this.blockSize;
                Block block = this.heap.allocate(num);
                entry = new SeekableInputEntry(block, ofs);
                if (this.last == null) {
                    this.first = entry;
                    this.last = entry;
                } else {
                    entry.prev = this.last;
                    this.last.next = entry;
                    this.last = entry;
                }
                off = 0;
                while (true) {
                    int n;
                    if ((n = block.write(off, this.stream, num)) > 0) {
                        off += n;
                        if (n < num) {
                            num -= n;
                            continue;
                        }
                        break block11;
                    }
                    if (n != 0) break block12;
                    n = block.write(off, this.stream, num);
                    if (n <= 0) break;
                    off += n;
                    if (n < num) {
                        num -= n;
                        continue;
                    }
                    break block11;
                    break;
                }
                if (off > 0) break block11;
            }
            entry.eof = true;
        }
        entry.len = off;
        entry.end = ofs + (long)off;
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws IOException {
        try {
            SeekableInputEntry en = this.first;
            if (en != null) {
                while (en != null) {
                    Block b = en.blk;
                    if (b != null) {
                        b.close();
                    }
                    en = en.next;
                }
                this.first = null;
                this.last = null;
            }
        }
        finally {
            this.stream.close();
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    public SeekableStream createStream(long pos) throws IOException {
        return this.createInputStream(pos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SeekableInputStream createInputStream(long pos) throws IOException {
        if (pos < 0L) {
            throw new IOException("Invalid position: " + pos);
        }
        SeekableInputEntry entry = this.seek(pos, this.first);
        if (entry == null) {
            throw new EOFException("Invalid position: " + pos);
        }
        int off = (int)(pos - entry.ofs);
        SeekableInputStream sis = new SeekableInputStream(this, entry, off);
        SeekableInputModel seekableInputModel = this;
        synchronized (seekableInputModel) {
            ++this.streamCount;
        }
        return sis;
    }

    protected synchronized void streamClosed(SeekableInputStream sis) throws IOException {
        if (this.streamCount > 1) {
            --this.streamCount;
            return;
        }
        if (this.streamCount == 1) {
            this.streamCount = 0;
            if (this.autoClose) {
                this.close();
            }
            return;
        }
        throw new IOException("Invalid number of streams: " + this.streamCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SeekableInputEntry next(SeekableInputEntry entry) throws IOException {
        SeekableInputEntry next = entry.next;
        if (next == null) {
            if (entry.eof) {
                return null;
            }
            SeekableInputModel seekableInputModel = this;
            synchronized (seekableInputModel) {
                next = entry.next;
                if (next == null) {
                    next = this.load(entry.end);
                }
            }
        }
        return next;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SeekableInputEntry seek(long pos, SeekableInputEntry entry) throws IOException {
        long rel = pos - entry.ofs;
        if (rel < 0L) {
            if (pos < (long)this.first.len) {
                return this.first;
            }
            entry = entry.prev;
            while (entry.ofs > pos) {
                entry = entry.prev;
            }
            return entry;
        }
        if (rel < (long)entry.len) {
            return entry;
        }
        entry = entry.next;
        while (entry != null) {
            if (pos < entry.end) {
                return entry;
            }
            entry = entry.next;
        }
        while (true) {
            SeekableInputModel seekableInputModel = this;
            synchronized (seekableInputModel) {
                entry = this.last;
                if (pos < entry.end) {
                    break;
                }
                if (entry.eof) {
                    if (pos == entry.end) {
                        return entry;
                    }
                    throw new EOFException("Invalid position: " + pos + " > " + entry.end);
                }
                entry = this.load(entry.end);
                if (pos < entry.end) {
                    return entry;
                }
            }
        }
        while (entry.ofs > pos) {
            entry = entry.prev;
        }
        return entry;
    }

    public String toString() {
        return super.toString() + "[" + this.getStreamInfo(this.stream) + "]";
    }

    private String getStreamInfo(Object is) {
        return String.valueOf(is);
    }
}

