/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.library;

import com.spacekiller.util.heap.Block;
import com.spacekiller.util.media.SeekableStream;
import com.spacekiller.util.media.library.SeekableInputEntry;
import com.spacekiller.util.media.library.SeekableInputModel;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class SeekableInputStream
extends InputStream
implements SeekableStream {
    private final SeekableInputModel model;
    private SeekableInputEntry entry;
    private Block blk;
    private int len;
    private int pos;
    private long mark;
    private final byte[] dat;

    protected SeekableInputStream(SeekableInputModel model, SeekableInputEntry entry, int off) throws IOException {
        this.model = model;
        this.dat = new byte[1];
        this.mark = -1L;
        this.entry = entry;
        this.blk = entry.blk;
        this.len = entry.len;
        this.pos = off;
    }

    public String toString() {
        return super.toString() + "[" + this.model + "]";
    }

    public SeekableInputModel getModel() {
        return this.model;
    }

    public InputStream getInputStream() {
        return this;
    }

    @Override
    public synchronized int read() throws IOException {
        if (this.read(this.dat, 0, 1) == 1) {
            return this.dat[0] & 0xFF;
        }
        return -1;
    }

    @Override
    public synchronized int read(byte[] b, int off, int num) throws IOException {
        int n = this.len - this.pos;
        if (n < 1) {
            return -1;
        }
        if (num < n) {
            if (num < 1) {
                return 0;
            }
            this.blk.read(this.pos, b, off, num);
            this.pos += num;
            return num;
        }
        this.blk.read(this.pos, b, off, n);
        SeekableInputEntry en = this.model.next(this.entry);
        if (en == null) {
            this.pos = this.len;
            return n;
        }
        this.entry = en;
        this.blk = en.blk;
        this.len = en.len;
        this.pos = 0;
        return n;
    }

    @Override
    public synchronized long skip(long num) throws IOException {
        int n = this.len - this.pos;
        if (n < 1) {
            return 0L;
        }
        if (num < (long)n) {
            if (num < 1L) {
                return 0L;
            }
            this.pos = (int)((long)this.pos + num);
            return num;
        }
        SeekableInputEntry en = this.model.next(this.entry);
        if (en == null) {
            this.pos = this.len;
            return n;
        }
        this.entry = en;
        this.blk = en.blk;
        this.len = en.len;
        this.pos = 0;
        return n;
    }

    @Override
    public synchronized int available() throws IOException {
        return this.len - this.pos;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.mark = this.entry.ofs + (long)this.pos;
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.mark < 0L) {
            throw new IOException("Resetting to invalid mark");
        }
        this.seek(this.mark);
    }

    public synchronized long position() {
        return this.entry.ofs + (long)this.pos;
    }

    public synchronized void seek(long position) throws IOException {
        if (position < 0L) {
            throw new IOException("Invalid position: " + position);
        }
        SeekableInputEntry en = this.model.seek(position, this.entry);
        if (en == null) {
            throw new EOFException("Invalid position: " + position);
        }
        this.entry = en;
        this.blk = en.blk;
        this.len = en.len;
        this.pos = (int)(position - en.ofs);
    }

    @Override
    public synchronized void close() throws IOException {
        super.close();
        if (this.entry != null) {
            this.entry = null;
            this.blk = null;
            this.len = -1;
            this.pos = -1;
            this.model.streamClosed(this);
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }
}

