/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.library.dir;

import com.spacekiller.util.FileResource;
import com.spacekiller.util.Resource;
import com.spacekiller.util.media.AbstractMediaCrate;
import com.spacekiller.util.media.DefaultMediaCrateEntry;
import com.spacekiller.util.media.DirectoryMediaCrate;
import com.spacekiller.util.media.DirectoryMediaIndex;
import com.spacekiller.util.media.MediaCrate;
import com.spacekiller.util.media.MediaCrateEntry;
import com.spacekiller.util.media.MediaEntry;
import com.spacekiller.util.media.library.DirectoryCacheEntry;
import com.spacekiller.util.media.library.LibraryFile;
import java.io.File;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CachedDirectoryMediaIndex
implements DirectoryMediaIndex {
    private static final Logger logger = Logger.getLogger(CachedDirectoryMediaIndex.class.getName());
    private final DirectoryMediaIndex index;
    private final LibraryFile cacheLibraryFile;
    private final SubCrates subCrates = new SubCrates();
    private final FileEntries fileEntries = new FileEntries();

    public CachedDirectoryMediaIndex(DirectoryMediaIndex index, LibraryFile cacheLibraryFile) {
        if (index == null) {
            throw new NullPointerException("index");
        }
        if (cacheLibraryFile == null) {
            throw new NullPointerException("cacheLibraryFile");
        }
        this.index = index;
        this.cacheLibraryFile = cacheLibraryFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enumerateDirectoryMediaCrates(File dir, DirectoryMediaCrate crate, Collection dstSubCrates) {
        FileResource resource = new FileResource(dir);
        DirectoryCacheEntry cache = this.getDirectoryCacheEntry(resource);
        if (cache != null) {
            if (this.isCacheValid(cache, dir)) {
                DirectoryCacheEntry directoryCacheEntry = cache;
                synchronized (directoryCacheEntry) {
                    List list = cache.getCrateNames();
                    if (list == null) {
                        return;
                    }
                    int num = list.size();
                    if (num < 1) {
                        return;
                    }
                    boolean recursive = crate.isRecursive();
                    String subIdPrefix = crate.getId() + "/";
                    String subPathPrefix = crate.getPath() + File.separator;
                    for (int i = 0; i < num; ++i) {
                        String name = (String)list.get(i);
                        String subId = subIdPrefix + name;
                        String subPath = subPathPrefix + name;
                        dstSubCrates.add(new DirectoryMediaCrate((AbstractMediaCrate)crate, subId, name, subPath, recursive));
                    }
                }
                return;
            }
        } else {
            cache = new DirectoryCacheEntry();
        }
        cache.setPath(dir.getPath());
        cache.setLastModified(dir.lastModified());
        this.updateDirectoryCacheEntry(cache, dir, resource, crate, dstSubCrates, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enumerateDirectoryMediaCrateEntries(File dir, DirectoryMediaCrate crate, Collection dstCrateEntries) {
        FileResource resource = new FileResource(dir);
        DirectoryCacheEntry cache = this.getDirectoryCacheEntry(resource);
        if (cache != null) {
            if (this.isCacheValid(cache, dir)) {
                DirectoryCacheEntry directoryCacheEntry = cache;
                synchronized (directoryCacheEntry) {
                    List list = cache.getEntryNames();
                    if (list == null) {
                        return;
                    }
                    int num = list.size();
                    if (num < 1) {
                        return;
                    }
                    for (int i = 0; i < num; ++i) {
                        String name = (String)list.get(i);
                        File file = new File(dir, name);
                        dstCrateEntries.add(new DefaultMediaCrateEntry((MediaCrate)crate, (Resource)new FileResource(file)));
                    }
                }
                return;
            }
        } else {
            cache = new DirectoryCacheEntry();
        }
        cache.setPath(dir.getPath());
        cache.setLastModified(dir.lastModified());
        this.updateDirectoryCacheEntry(cache, dir, resource, crate, null, dstCrateEntries);
    }

    protected DirectoryCacheEntry getDirectoryCacheEntry(FileResource dir) {
        try {
            MediaEntry me = this.cacheLibraryFile.getMediaEntry((Resource)dir);
            if (me != null && me instanceof DirectoryCacheEntry) {
                return (DirectoryCacheEntry)me;
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        return null;
    }

    protected boolean isCacheValid(DirectoryCacheEntry cache, File dir) {
        return cache.getLastModified() == dir.lastModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateDirectoryCacheEntry(DirectoryCacheEntry cache, File dir, FileResource res, DirectoryMediaCrate crate, Collection dstSubCrates, Collection dstCrateEntries) {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("updateDirectoryCacheEntry: " + dir);
        }
        List crateNames = cache.getCrateNames();
        SubCrates subCrates = this.subCrates;
        synchronized (subCrates) {
            try {
                this.subCrates.setup(dstSubCrates);
                this.index.enumerateDirectoryMediaCrates(dir, crate, (Collection)this.subCrates);
            }
            finally {
                crateNames = this.subCrates.getNames(crateNames);
                this.subCrates.reset();
            }
        }
        List entryNames = cache.getEntryNames();
        FileEntries fileEntries = this.fileEntries;
        synchronized (fileEntries) {
            try {
                this.fileEntries.setup(dstCrateEntries);
                this.index.enumerateDirectoryMediaCrateEntries(dir, crate, (Collection)this.fileEntries);
            }
            finally {
                entryNames = this.fileEntries.getNames(entryNames);
                this.fileEntries.reset();
            }
        }
        try {
            cache.setCrateNames(crateNames);
            cache.setEntryNames(entryNames);
            this.cacheLibraryFile.putMediaEntry((Resource)res, (MediaEntry)cache);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public void clearCache() throws IOException {
        this.cacheLibraryFile.removeAllMediaEntries();
    }

    protected static class FileEntries
    extends AbstractCollection {
        protected final List names = new LinkedList();
        protected Collection dst;

        protected void setup(Collection dst) {
            this.dst = dst;
            this.names.clear();
        }

        protected List getNames(List list) {
            if (list == null) {
                list = new ArrayList(this.names.size());
            } else {
                list.clear();
            }
            list.addAll(this.names);
            return list;
        }

        protected void reset() {
            this.dst = null;
            this.names.clear();
        }

        @Override
        public boolean add(Object e) {
            Resource res;
            MediaCrateEntry entry = (MediaCrateEntry)e;
            if (this.dst != null) {
                this.dst.add(entry);
            }
            if ((res = entry.getResource()) != null && res instanceof FileResource) {
                File file = ((FileResource)res).getFile();
                this.names.add(file.getName());
            }
            return true;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public Iterator iterator() {
            throw new UnsupportedOperationException();
        }
    }

    protected static class SubCrates
    extends AbstractCollection {
        protected final List names = new LinkedList();
        protected Collection dst;

        protected void setup(Collection dst) {
            this.dst = dst;
            this.names.clear();
        }

        protected List getNames(List list) {
            if (list == null) {
                list = new ArrayList(this.names.size());
            } else {
                list.clear();
            }
            list.addAll(this.names);
            return list;
        }

        protected void reset() {
            this.dst = null;
            this.names.clear();
        }

        @Override
        public boolean add(Object e) {
            DirectoryMediaCrate crate = (DirectoryMediaCrate)e;
            if (this.dst != null) {
                this.dst.add(crate);
            }
            this.names.add(crate.getName());
            return true;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public Iterator iterator() {
            throw new UnsupportedOperationException();
        }
    }
}

