/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.library.dir;

import com.spacekiller.util.FileResource;
import com.spacekiller.util.Resource;
import com.spacekiller.util.media.AbstractMediaCrate;
import com.spacekiller.util.media.DefaultMediaCrateEntry;
import com.spacekiller.util.media.DirectoryMediaCrate;
import com.spacekiller.util.media.DirectoryMediaIndex;
import com.spacekiller.util.media.MediaCrate;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;

public class DefaultDirectoryMediaIndex
implements DirectoryMediaIndex {
    protected static final DefaultSubDirFilter DEFAULT_SUBDIR_FILTER = new DefaultSubDirFilter();
    protected static final DefaultFilenameFilter DEFAULT_FILENAME_FILTER = new DefaultFilenameFilter();
    protected static final DefaultFileComparator DEFAULT_FILE_COMPARATOR = new DefaultFileComparator();
    protected final FilenameFilter subDirFilter;
    protected final FilenameFilter filenameFilter;
    protected final Comparator fileComparator;

    public DefaultDirectoryMediaIndex() {
        this.subDirFilter = DEFAULT_SUBDIR_FILTER;
        this.filenameFilter = DEFAULT_FILENAME_FILTER;
        this.fileComparator = DEFAULT_FILE_COMPARATOR;
    }

    public DefaultDirectoryMediaIndex(FilenameFilter subDirFilter, FilenameFilter filenameFilter, Comparator fileComparator) {
        this.subDirFilter = subDirFilter;
        this.filenameFilter = filenameFilter;
        this.fileComparator = fileComparator;
    }

    protected final FilenameFilter getSubDirFilter() {
        return this.subDirFilter;
    }

    protected final FilenameFilter getFilenameFilter() {
        return this.filenameFilter;
    }

    protected final Comparator getFileComparator() {
        return this.fileComparator;
    }

    public void enumerateDirectoryMediaCrates(File dir, DirectoryMediaCrate crate, Collection dstSubCrates) {
        File[] subDirs = dir.listFiles(this.subDirFilter);
        if (subDirs == null) {
            return;
        }
        int num = subDirs.length;
        if (num < 1) {
            return;
        }
        Arrays.sort(subDirs, 0, num, this.fileComparator);
        boolean recursive = crate.isRecursive();
        String subIdPrefix = crate.getId() + "/";
        for (int i = 0; i < num; ++i) {
            File sub = subDirs[i];
            if (sub == null) continue;
            String name = sub.getName();
            String subId = subIdPrefix + name;
            dstSubCrates.add(new DirectoryMediaCrate((AbstractMediaCrate)crate, subId, name, sub.getPath(), recursive));
        }
    }

    public void enumerateDirectoryMediaCrateEntries(File dir, DirectoryMediaCrate crate, Collection dstCrateEntries) {
        File[] files = dir.listFiles(this.filenameFilter);
        if (files == null) {
            return;
        }
        int num = files.length;
        if (num < 1) {
            return;
        }
        Arrays.sort(files, 0, num, this.fileComparator);
        for (int i = 0; i < num; ++i) {
            File file = files[i];
            if (file == null) continue;
            dstCrateEntries.add(new DefaultMediaCrateEntry((MediaCrate)crate, (Resource)new FileResource(file)));
        }
    }

    public void clearCache() throws IOException {
    }

    protected static class DefaultFileComparator
    implements Comparator {
        protected DefaultFileComparator() {
        }

        public int compare(Object o1, Object o2) {
            return ((File)o1).getPath().compareToIgnoreCase(((File)o2).getPath());
        }
    }

    protected static class DefaultFilenameFilter
    implements FilenameFilter {
        protected DefaultFilenameFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            File file = new File(dir, name);
            if (!file.exists()) {
                return false;
            }
            return file.isFile();
        }
    }

    protected static class DefaultSubDirFilter
    implements FilenameFilter {
        protected DefaultSubDirFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            File subDir = new File(dir, name);
            if (!subDir.exists()) {
                return false;
            }
            return subDir.isDirectory();
        }
    }
}

