/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.library.m3u;

import com.spacekiller.util.media.library.m3u.M3uCrateFileTrack;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;

public class M3uCrateFile {
    public static final String M3U_FILE_EXTENSION = ".m3u";
    public static final String HEADER_EXTM3U = "#EXTM3U";
    private String charsetName = "UTF-8";
    private List tracks = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isM3uCrateFile(File inFile) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(inFile));
        try {
            String s = reader.readLine();
            if (s != null && s.toUpperCase().startsWith(HEADER_EXTM3U)) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readFrom(File inFile) throws IOException {
        FileInputStream in = new FileInputStream(inFile);
        try {
            this.readFrom(in);
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readFrom(InputStream in) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(in, this.charsetName));
        try {
            String s;
            String comment = null;
            while ((s = reader.readLine()) != null) {
                if (s.startsWith("#")) {
                    if (s.trim().toUpperCase().equals(HEADER_EXTM3U)) continue;
                    comment = s;
                    continue;
                }
                if ((s = s.trim()).length() < 1) continue;
                this.tracks.add(new M3uCrateFileTrack(s, comment));
                comment = null;
            }
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(File outFile) throws IOException {
        FileOutputStream out = new FileOutputStream(outFile);
        try {
            this.writeTo(out);
        }
        finally {
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream out) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, this.charsetName));
        try {
            writer.write(HEADER_EXTM3U);
            writer.newLine();
            for (M3uCrateFileTrack track : this.tracks) {
                String path;
                if (track == null || (path = track.getPath()) == null || path.length() < 1) continue;
                String comment = track.getComment();
                if (comment != null) {
                    if (!comment.startsWith("#")) {
                        comment = "#" + comment;
                    }
                    writer.write(comment);
                    writer.newLine();
                }
                writer.write(path);
                writer.newLine();
            }
        }
        finally {
            writer.flush();
        }
    }

    public void addTrack(M3uCrateFileTrack track) {
        if (track != null) {
            this.tracks.add(track);
        }
    }

    public int getTrackCount() {
        return this.tracks.size();
    }

    public M3uCrateFileTrack getTrackAt(int index) {
        return (M3uCrateFileTrack)this.tracks.get(index);
    }

    public String getCharsetName() {
        return this.charsetName;
    }

    public void setCharsetName(String charsetName) {
        this.charsetName = charsetName;
    }
}

