/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.library.m3u;

import com.spacekiller.util.Resource;
import com.spacekiller.util.media.MediaEntry;
import java.util.StringTokenizer;

public class M3uCrateFileTrack {
    public static final String PREFIX_EXTINF = "#EXTINF:";
    private String path;
    private String comment;

    public M3uCrateFileTrack(String path, String comment) {
        this.path = path;
        this.comment = comment;
    }

    public M3uCrateFileTrack(MediaEntry entry) {
        this(M3uCrateFileTrack.getMediaEntryPath(entry), M3uCrateFileTrack.getMediaEntryComment(entry));
    }

    public static String getMediaEntryPath(MediaEntry entry) {
        if (entry == null) {
            return null;
        }
        Resource res = entry.getResource();
        if (res == null) {
            return null;
        }
        return res.toString();
    }

    public static String getMediaEntryComment(MediaEntry entry) {
        double duration;
        long seconds;
        if (entry == null) {
            return null;
        }
        String title = entry.getTitle();
        String artist = entry.getArtist();
        if (artist == null) {
            artist = entry.getAlbumArtist();
        }
        if ((seconds = (long)Math.ceil(duration = entry.getDuration())) < 0L) {
            seconds = -1L;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(PREFIX_EXTINF);
        sb.append(Long.toString(seconds));
        sb.append(",");
        sb.append(M3uCrateFileTrack.commentString(artist));
        sb.append(" - ");
        sb.append(M3uCrateFileTrack.commentString(title));
        return sb.toString();
    }

    protected static String commentString(String s) {
        if (s == null || s.length() < 1) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        StringTokenizer tok = new StringTokenizer(s, "\r\n\t", false);
        while (tok.hasMoreTokens()) {
            sb.append(tok.nextToken());
        }
        return sb.toString();
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }
}

