/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.library.m3u;

import com.spacekiller.util.Resource;
import com.spacekiller.util.media.MediaCrate;
import com.spacekiller.util.media.MediaCrateEntry;
import com.spacekiller.util.media.library.m3u.M3uCrateFile;
import com.spacekiller.util.media.library.m3u.M3uCrateFileTrack;
import java.io.File;
import java.io.IOException;

public class M3uExport {
    private File targetM3uFile;

    public M3uExport(File targetM3uFile) {
        this.targetM3uFile = targetM3uFile;
    }

    public void exportCratesToM3uFile(MediaCrate[] crates) throws IOException {
        M3uCrateFile m3uCrateFile = new M3uCrateFile();
        for (MediaCrate crate : crates) {
            this.enumerateM3uTracksRecursive(crate, m3uCrateFile);
        }
        m3uCrateFile.writeTo(this.targetM3uFile);
    }

    protected void enumerateM3uTracksRecursive(MediaCrate crate, M3uCrateFile m3uCrateFile) {
        if (crate == null) {
            return;
        }
        int num = crate.getEntryCount();
        for (int i = 0; i < num; ++i) {
            Resource res;
            MediaCrateEntry mce = crate.getEntryAt(i);
            if (mce == null || (res = mce.getResource()) == null) continue;
            String comment = null;
            m3uCrateFile.addTrack(new M3uCrateFileTrack(res.toString(), comment));
        }
        num = crate.getCrateCount();
        for (int i = 0; i < num; ++i) {
            MediaCrate mc = crate.getCrateAt(i);
            if (mc == null) continue;
            this.enumerateM3uTracksRecursive(mc, m3uCrateFile);
        }
    }
}

