/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.library.m3u;

import com.spacekiller.util.FileResource;
import com.spacekiller.util.Resource;
import com.spacekiller.util.URLResource;
import com.spacekiller.util.media.DefaultMediaCrate;
import com.spacekiller.util.media.DefaultMediaCrateEntry;
import com.spacekiller.util.media.MediaCrate;
import com.spacekiller.util.media.MediaCrateEntry;
import com.spacekiller.util.media.library.m3u.M3uCrateFile;
import com.spacekiller.util.media.library.m3u.M3uCrateFileTrack;
import java.io.File;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class M3uMediaCrate
extends DefaultMediaCrate {
    private static final Logger logger = Logger.getLogger(M3uMediaCrate.class.getName());
    private String path;
    private transient boolean corrupted;
    private transient Thread entryInitThread;

    public M3uMediaCrate(String id, File crateFile) {
        this(id, M3uMediaCrate.parseCrateNamePrefix(crateFile), crateFile.getPath());
    }

    public M3uMediaCrate(String id, String name, String crateFilePath) {
        super(id, name);
        this.path = crateFilePath;
        this.crates = null;
        this.entries = null;
    }

    protected void setId(String id) {
        super.setId(id);
    }

    public String getPath() {
        return this.path;
    }

    protected void setPath(String path) {
        this.path = path;
    }

    public String toString() {
        return String.valueOf(this.path);
    }

    public static String parseCrateNamePrefix(File crateFile) {
        String name = crateFile.getName();
        int x = name.lastIndexOf(46);
        if (x >= 0) {
            name = name.substring(0, x);
        }
        return name;
    }

    public void getEntries(Collection dst) {
        this.lazyInitEntries(dst);
    }

    public int getEntryCount() {
        this.lazyInitEntries(null);
        return super.getEntryCount();
    }

    public MediaCrateEntry getEntryAt(int index) {
        this.lazyInitEntries(null);
        return super.getEntryAt(index);
    }

    public int getEntryIndex(MediaCrateEntry entry) {
        this.lazyInitEntries(null);
        return super.getEntryIndex(entry);
    }

    public void addEntry(MediaCrateEntry entry) {
        this.lazyInitEntries(null);
        super.addEntry(entry);
    }

    public void insertEntryAt(MediaCrateEntry entry, int index) {
        this.lazyInitEntries(null);
        super.insertEntryAt(entry, index);
    }

    public MediaCrateEntry removeEntryAt(int index) {
        this.lazyInitEntries(null);
        return super.removeEntryAt(index);
    }

    public int removeEntry(MediaCrateEntry entry) {
        this.lazyInitEntries(null);
        return super.removeEntry(entry);
    }

    public int getCrateCount() {
        return 0;
    }

    public void addCrate(MediaCrate crate) {
        throw new UnsupportedOperationException("Sub crates not supported for M3U playlists");
    }

    public void insertCrateAt(MediaCrate crate, int index) {
        throw new UnsupportedOperationException("Sub crates not supported for M3U playlists");
    }

    public MediaCrate newCrate(String id, String name) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void lazyInitEntries(Collection dst) {
        if (this.entries != null) {
            if (dst != null) {
                List list = this.entries;
                synchronized (list) {
                    dst.addAll(this.entries);
                }
            }
            return;
        }
        Thread thread = Thread.currentThread();
        M3uMediaCrate m3uMediaCrate = this;
        synchronized (m3uMediaCrate) {
            if (this.entries != null) {
                if (dst != null) {
                    List list = this.entries;
                    synchronized (list) {
                        dst.addAll(this.entries);
                    }
                }
                return;
            }
            if (thread == this.entryInitThread) {
                throw new IllegalStateException("Recursive invocation !");
            }
            while (this.entryInitThread != null) {
                try {
                    ((Object)((Object)this)).wait();
                }
                catch (InterruptedException e) {}
            }
            if (this.entries != null) {
                if (dst != null) {
                    List e = this.entries;
                    synchronized (e) {
                        dst.addAll(this.entries);
                    }
                }
                return;
            }
            this.entryInitThread = thread;
        }
        ArrayList<DefaultMediaCrateEntry> listEntries = null;
        try {
            listEntries = new ArrayList<DefaultMediaCrateEntry>();
            File crateFile = new File(this.path);
            if (crateFile.exists() && crateFile.isFile()) {
                this.corrupted = true;
                try {
                    M3uCrateFile m3uCrateFile = new M3uCrateFile();
                    m3uCrateFile.readFrom(crateFile);
                    int num = m3uCrateFile.getTrackCount();
                    for (int i = 0; i < num; ++i) {
                        M3uCrateFileTrack track = m3uCrateFile.getTrackAt(i);
                        String path = track.getPath();
                        Resource resource = this.getResource(path);
                        if (resource == null) continue;
                        DefaultMediaCrateEntry me = new DefaultMediaCrateEntry((MediaCrate)this, resource);
                        listEntries.add(me);
                        if (dst == null) continue;
                        dst.add(me);
                    }
                    this.corrupted = false;
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
        finally {
            M3uMediaCrate m3uMediaCrate2 = this;
            synchronized (m3uMediaCrate2) {
                this.entries = listEntries;
                this.entryInitThread = null;
                ((Object)((Object)this)).notifyAll();
            }
        }
    }

    protected Resource getResource(String path) {
        if (path == null) {
            return null;
        }
        if ((path = path.trim()).length() < 1) {
            return null;
        }
        if (path.startsWith("http:") || path.startsWith("https:")) {
            try {
                return new URLResource(new URL(path));
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return new FileResource(new File(path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveCrate() throws IOException {
        if (!this.isDirty()) {
            return;
        }
        File file = new File(this.path);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Saving M3U crate file: " + this.path);
        }
        M3uMediaCrate m3uMediaCrate = this;
        synchronized (m3uMediaCrate) {
            if (this.corrupted) {
                throw new StreamCorruptedException("Existing crate file seems to be corrupted: " + this.path);
            }
        }
        if (this.entries != null || !file.exists()) {
            if (file.exists() && file.isFile()) {
                File backupFile = new File(this.path + ".bak");
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Backup M3U crate file: " + file + " -> " + backupFile);
                }
                if (backupFile.exists() && !backupFile.delete()) {
                    throw new IOException("Failed to delete old crate backup file: " + backupFile);
                }
                if (!file.renameTo(backupFile)) {
                    throw new IOException("Failed to rename old crate file: " + file + " -> " + backupFile);
                }
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Writing M3U crate file: " + file);
            }
            M3uCrateFile crateFile = new M3uCrateFile();
            if (this.entries != null) {
                List list = this.entries;
                synchronized (list) {
                    int num = this.entries.size();
                    for (int i = 0; i < num; ++i) {
                        Resource resource;
                        MediaCrateEntry entry = (MediaCrateEntry)this.entries.get(i);
                        if (entry == null || (resource = entry.getResource()) == null) continue;
                        String comment = null;
                        crateFile.addTrack(new M3uCrateFileTrack(resource.toString(), comment));
                    }
                }
            }
            crateFile.writeTo(file);
        }
        this.setDirty(false);
    }
}

