/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.library.remote;

import com.spacekiller.util.LoginManager;
import com.spacekiller.util.Platform;
import com.spacekiller.util.media.MediaContext;
import com.spacekiller.util.media.MediaEntry;
import com.spacekiller.util.media.MediaResource;
import com.spacekiller.util.media.SeekableStream;
import com.spacekiller.util.media.library.remote.MediaConnection;
import com.spacekiller.util.media.library.remote.ProtocolConst;
import com.spacekiller.util.media.library.remote.RemoteInputStream;
import com.spacekiller.util.media.library.remote.RemoteMediaCrate;
import com.spacekiller.util.media.library.remote.RemoteMediaCrateInfo;
import com.spacekiller.util.media.library.remote.RemoteMediaLibrary;
import java.awt.Component;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextOutputCallback;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.UnsupportedAudioFileException;

public class MediaClient
implements ProtocolConst {
    private static final Logger logger = Logger.getLogger(MediaClient.class.getName());
    public static final int DEFAULT_MAX_CONNECTIONS = 8;
    public static final int DEFAULT_CONNECT_RETRIES = 3;
    public static final int DEFAULT_CONNECT_TIMEOUT = 30000;
    public static final int DEFAULT_LOGIN_TIMEOUT = 120000;
    public static final int DEFAULT_POOL_TIMEOUT = 30000;
    public static final int DEFAULT_INPUT_BUFFER_SIZE = 262144;
    public static final int DEFAULT_OUTPUT_BUFFER_SIZE = 32768;
    private String name;
    private MediaContext context;
    private Component parentComponent;
    private SocketAddress endpoint;
    private String libraryName;
    private String defaultUserName;
    private String userName = null;
    private byte[] userPass = null;
    private boolean remoteDecoding;
    private List connections;
    private PoolEntry pool;
    private boolean shareStreamConnection;
    private int connectionPoolTimeout = 30000;
    private int maxConnections = 8;
    private int connectionRetries = 3;
    private int connectTimeout = 30000;
    private int loginTimeout = 120000;
    private int socketTimeout = 0;
    private boolean keepAlive = true;
    private boolean tcpNoDelay = true;
    private int inputBufferSize = 262144;
    private int outputBufferSize = 32768;

    public MediaClient(String name, MediaContext context, Component parentComponent) {
        this.name = name;
        this.context = context;
        this.parentComponent = parentComponent;
        this.connections = new ArrayList();
    }

    public String getName() {
        return this.name;
    }

    protected void setName(String name) {
        this.name = name;
    }

    public MediaContext getContext() {
        return this.context;
    }

    protected void setContext(MediaContext context) {
        this.context = context;
    }

    public String toString() {
        return super.toString() + "[name=" + this.name + ", endpoint=" + this.endpoint + ", library=" + this.libraryName + ", context=" + this.context + "]";
    }

    public SocketAddress getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(SocketAddress endpoint) {
        this.endpoint = endpoint;
    }

    public String getLibraryName() {
        return this.libraryName;
    }

    public void setLibraryName(String libraryName) {
        this.libraryName = libraryName;
    }

    public String getDefaultUserName() {
        return this.defaultUserName;
    }

    public void setDefaultUserName(String defaultUserName) {
        this.defaultUserName = defaultUserName;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getLoginTimeout() {
        return this.loginTimeout;
    }

    public void setLoginTimeout(int loginTimeout) {
        this.loginTimeout = loginTimeout;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    public boolean isShareStreamConnection() {
        return this.shareStreamConnection;
    }

    public void setShareStreamConnection(boolean shareStreamConnection) {
        this.shareStreamConnection = shareStreamConnection;
    }

    public int getConnectionPoolTimeout() {
        return this.connectionPoolTimeout;
    }

    public void setConnectionPoolTimeout(int connectionPoolTimeout) {
        this.connectionPoolTimeout = connectionPoolTimeout;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public synchronized int getConnectionCount() {
        return this.connections.size();
    }

    public boolean containsMediaEntry(MediaResource resource) throws IOException {
        int i = 0;
        while (true) {
            block8: {
                PoolEntry c = this.getConnection();
                try {
                    boolean bl = c.connection.containsMediaEntry(resource);
                    return bl;
                }
                catch (SocketException e) {
                    if (i < this.connectionRetries) {
                        this.disposeConnection(c, e);
                        break block8;
                    }
                    throw e;
                }
                finally {
                    this.releaseConnection(c);
                }
            }
            ++i;
        }
    }

    public MediaEntry getMediaEntry(MediaResource resource, int flags) throws IOException {
        int i = 0;
        while (true) {
            block8: {
                PoolEntry c = this.getConnection();
                try {
                    MediaEntry mediaEntry = c.connection.getMediaEntry(resource, flags);
                    return mediaEntry;
                }
                catch (SocketException e) {
                    if (i < this.connectionRetries) {
                        this.disposeConnection(c, e);
                        break block8;
                    }
                    throw e;
                }
                finally {
                    this.releaseConnection(c);
                }
            }
            ++i;
        }
    }

    public void getMediaEntries(List crateEntryList, int off, int len, int flags, Collection dstMediaEntries) throws IOException {
        int i = 0;
        while (true) {
            block8: {
                PoolEntry c = this.getConnection();
                try {
                    c.connection.getMediaEntries(crateEntryList, off, len, flags, dstMediaEntries);
                    return;
                }
                catch (SocketException e) {
                    if (i < this.connectionRetries) {
                        this.disposeConnection(c, e);
                        break block8;
                    }
                    throw e;
                }
                finally {
                    this.releaseConnection(c);
                }
            }
            ++i;
        }
    }

    public void putMediaEntry(MediaResource resource, MediaEntry entry) throws IOException {
        int i = 0;
        while (true) {
            block8: {
                PoolEntry c = this.getConnection();
                try {
                    c.connection.putMediaEntry(resource, entry);
                    return;
                }
                catch (SocketException e) {
                    if (i < this.connectionRetries) {
                        this.disposeConnection(c, e);
                        break block8;
                    }
                    throw e;
                }
                finally {
                    this.releaseConnection(c);
                }
            }
            ++i;
        }
    }

    public void setUserRating(MediaResource resource, double rating) throws IOException {
        int i = 0;
        while (true) {
            block8: {
                PoolEntry c = this.getConnection();
                try {
                    c.connection.setUserRating(resource, rating);
                    return;
                }
                catch (SocketException e) {
                    if (i < this.connectionRetries) {
                        this.disposeConnection(c, e);
                        break block8;
                    }
                    throw e;
                }
                finally {
                    this.releaseConnection(c);
                }
            }
            ++i;
        }
    }

    public void setUserComment(MediaResource resource, String comment) throws IOException {
        int i = 0;
        while (true) {
            block8: {
                PoolEntry c = this.getConnection();
                try {
                    c.connection.setUserComment(resource, comment);
                    return;
                }
                catch (SocketException e) {
                    if (i < this.connectionRetries) {
                        this.disposeConnection(c, e);
                        break block8;
                    }
                    throw e;
                }
                finally {
                    this.releaseConnection(c);
                }
            }
            ++i;
        }
    }

    public InputStream createInputStream(MediaResource resource, boolean seekable) throws IOException {
        int i = 0;
        while (true) {
            block11: {
                PoolEntry c = this.getConnection();
                boolean release = true;
                PostReleaseConnection postCloseAction = null;
                boolean share = this.shareStreamConnection;
                if (!share) {
                    postCloseAction = new PostReleaseConnection(c);
                }
                try {
                    InputStream stream = c.connection.createInputStream(resource, seekable, postCloseAction);
                    if (stream != null) {
                        release = share;
                    }
                    InputStream inputStream = stream;
                    return inputStream;
                }
                catch (SocketException e) {
                    if (i < this.connectionRetries) {
                        this.disposeConnection(c, e);
                        break block11;
                    }
                    throw e;
                }
                finally {
                    if (release) {
                        this.releaseConnection(c);
                    }
                }
            }
            ++i;
        }
    }

    public AudioInputStream createAudioInputStream(MediaResource resource, boolean seekable) throws IOException, UnsupportedAudioFileException {
        int i = 0;
        while (true) {
            block11: {
                PoolEntry c = this.getConnection();
                boolean release = true;
                PostReleaseConnection postCloseAction = null;
                boolean share = this.shareStreamConnection;
                if (!share) {
                    postCloseAction = new PostReleaseConnection(c);
                }
                try {
                    AudioInputStream stream = c.connection.createAudioInputStream(resource, seekable, postCloseAction);
                    if (stream != null) {
                        release = share;
                    }
                    AudioInputStream audioInputStream = stream;
                    return audioInputStream;
                }
                catch (SocketException e) {
                    if (i < this.connectionRetries) {
                        this.disposeConnection(c, e);
                        break block11;
                    }
                    throw e;
                }
                finally {
                    if (release) {
                        this.releaseConnection(c);
                    }
                }
            }
            ++i;
        }
    }

    public AudioInputStream createAudioInputStream(MediaResource resource, AudioFormat targetFormat, boolean seekable) throws IOException, UnsupportedAudioFileException {
        int i = 0;
        while (true) {
            block11: {
                PoolEntry c = this.getConnection();
                boolean release = true;
                PostReleaseConnection postCloseAction = null;
                boolean share = this.shareStreamConnection;
                if (!share) {
                    postCloseAction = new PostReleaseConnection(c);
                }
                try {
                    AudioInputStream stream = c.connection.createAudioInputStream(resource, targetFormat, seekable, postCloseAction);
                    if (stream != null) {
                        release = share;
                    }
                    AudioInputStream audioInputStream = stream;
                    return audioInputStream;
                }
                catch (SocketException e) {
                    if (i < this.connectionRetries) {
                        this.disposeConnection(c, e);
                        break block11;
                    }
                    throw e;
                }
                finally {
                    if (release) {
                        this.releaseConnection(c);
                    }
                }
            }
            ++i;
        }
    }

    public SeekableStream createSeekableInputStream(RemoteInputStream is, long pos) throws IOException {
        int i = 0;
        while (true) {
            block11: {
                PoolEntry c = this.getConnection();
                boolean release = true;
                PostReleaseConnection postCloseAction = null;
                boolean share = this.shareStreamConnection;
                if (!share) {
                    postCloseAction = new PostReleaseConnection(c);
                }
                try {
                    SeekableStream stream = c.connection.createSeekableInputStream(is, pos, postCloseAction);
                    if (stream != null) {
                        release = share;
                    }
                    SeekableStream seekableStream = stream;
                    return seekableStream;
                }
                catch (SocketException e) {
                    if (i < this.connectionRetries) {
                        this.disposeConnection(c, e);
                        break block11;
                    }
                    throw e;
                }
                finally {
                    if (release) {
                        this.releaseConnection(c);
                    }
                }
            }
            ++i;
        }
    }

    public RemoteMediaCrateInfo getCrateInfo(String crateId) throws IOException {
        int i = 0;
        while (true) {
            block8: {
                PoolEntry c = this.getConnection();
                try {
                    RemoteMediaCrateInfo remoteMediaCrateInfo = c.connection.getCrateInfo(crateId);
                    return remoteMediaCrateInfo;
                }
                catch (SocketException e) {
                    if (i < this.connectionRetries) {
                        this.disposeConnection(c, e);
                        break block8;
                    }
                    throw e;
                }
                finally {
                    this.releaseConnection(c);
                }
            }
            ++i;
        }
    }

    protected void getSubCratesRecursive(RemoteMediaCrate crate, RemoteMediaLibrary library) throws IOException {
        int i = 0;
        while (true) {
            block8: {
                PoolEntry c = this.getConnection();
                try {
                    c.connection.getSubCratesRecursive(crate, library);
                    return;
                }
                catch (SocketException e) {
                    if (i < this.connectionRetries) {
                        this.disposeConnection(c, e);
                        break block8;
                    }
                    throw e;
                }
                finally {
                    this.releaseConnection(c);
                }
            }
            ++i;
        }
    }

    protected void getSubCrates(String crateId, RemoteMediaLibrary library, Collection dstCrates) throws IOException {
        int i = 0;
        while (true) {
            block8: {
                PoolEntry c = this.getConnection();
                try {
                    c.connection.getSubCrates(crateId, library, dstCrates);
                    return;
                }
                catch (SocketException e) {
                    if (i < this.connectionRetries) {
                        this.disposeConnection(c, e);
                        break block8;
                    }
                    throw e;
                }
                finally {
                    this.releaseConnection(c);
                }
            }
            ++i;
        }
    }

    protected void getCrateEntries(String crateId, RemoteMediaCrate crate, RemoteMediaLibrary library, Collection dstEntries) throws IOException {
        int i = 0;
        while (true) {
            block8: {
                PoolEntry c = this.getConnection();
                try {
                    c.connection.getCrateEntries(crateId, crate, library, dstEntries);
                    return;
                }
                catch (SocketException e) {
                    if (i < this.connectionRetries) {
                        this.disposeConnection(c, e);
                        break block8;
                    }
                    throw e;
                }
                finally {
                    this.releaseConnection(c);
                }
            }
            ++i;
        }
    }

    public int getConnectionRetries() {
        return this.connectionRetries;
    }

    public void setConnectionRetries(int connectionRetries) {
        this.connectionRetries = connectionRetries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected PoolEntry getConnection() throws IOException {
        while (true) {
            MediaClient mediaClient = this;
            synchronized (mediaClient) {
                PoolEntry ce = this.pool;
                if (ce != null) {
                    this.pool = ce.next;
                    return ce;
                }
                if (this.connections.size() < this.maxConnections) {
                    // MONITOREXIT @DISABLED, blocks:[3, 6, 9] lbl10 : MonitorExitStatement: MONITOREXIT : var1_1
                    MediaConnection conn = this.createMediaConnection();
                    ce = new PoolEntry();
                    ce.connection = conn;
                    MediaClient mediaClient2 = this;
                    synchronized (mediaClient2) {
                        this.connections.add(ce);
                        return ce;
                    }
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Waiting for available media connection: " + this);
                }
                try {
                    this.wait(this.connectionPoolTimeout);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Retry after waiting for available media connection: " + this);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseConnection(PoolEntry ce) {
        if (ce.connection == null) {
            return;
        }
        MediaClient mediaClient = this;
        synchronized (mediaClient) {
            ce.next = this.pool;
            this.pool = ce;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disposeConnection(PoolEntry ce, Throwable err) {
        MediaConnection conn;
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Dispose connection due to error: " + err, err);
        }
        if ((conn = ce.connection) == null) {
            return;
        }
        MediaClient mediaClient = this;
        synchronized (mediaClient) {
            ce.next = null;
            ce.connection = null;
            MediaClient mediaClient2 = this;
            synchronized (mediaClient2) {
                if (this.connections.remove(ce)) {
                    this.notifyAll();
                }
            }
        }
        if (conn != null) {
            try {
                conn.close();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    protected CallbackHandler createCallbackHandler(SocketAddress addr, String libName) {
        LoginManager loginManager = Platform.getInstance().getLoginManager();
        String realm = "" + addr + "/" + libName;
        String dialogTitle = "Media Library Login";
        return loginManager.createCallbackHandler(realm, this.parentComponent, dialogTitle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected MediaConnection createMediaConnection() throws IOException {
        SocketAddress addr = this.getEndpoint();
        String libName = this.getLibraryName();
        String userName = this.userName;
        if (userName == null) {
            userName = this.getDefaultUserName();
        }
        byte[] userPass = this.userPass;
        IOException lastError = null;
        while (true) {
            int outBufSize;
            boolean authenticated;
            PasswordCallback passwordCallback;
            DataOutputStream dataOut;
            DataInputStream dataIn;
            Socket socket = null;
            boolean success = false;
            try {
                socket = new Socket();
                socket.setSoTimeout(this.connectTimeout);
                socket.setKeepAlive(this.keepAlive);
                socket.setTcpNoDelay(this.tcpNoDelay);
                socket.connect(addr, this.connectTimeout);
                InputStream in = socket.getInputStream();
                dataIn = new DataInputStream(in);
                OutputStream out = socket.getOutputStream();
                dataOut = new DataOutputStream(out);
                dataOut.writeByte(100);
                dataOut.writeInt(0);
                dataOut.writeUTF(libName);
                dataOut.flush();
                socket.setSoTimeout(this.loginTimeout);
                if (userName == null || userPass == null) {
                    String message;
                    int messageType;
                    if (userPass != null) {
                        Arrays.fill(userPass, (byte)0);
                        userPass = null;
                    }
                    LinkedList<Callback> callbackList = new LinkedList<Callback>();
                    TextOutputCallback errorOutputCallback = null;
                    if (lastError != null) {
                        messageType = 2;
                        message = String.valueOf(lastError);
                        errorOutputCallback = new TextOutputCallback(messageType, message);
                    }
                    messageType = 0;
                    message = "Login to Media Library: " + addr + "/" + libName;
                    TextOutputCallback infoOutputCallback = new TextOutputCallback(messageType, message);
                    String userNamePrompt = "User Name";
                    String defUserName = this.getDefaultUserName();
                    NameCallback userNameCallback = defUserName != null && defUserName.length() > 0 ? new NameCallback(userNamePrompt, defUserName) : new NameCallback(userNamePrompt);
                    String passwordPrompt = "Password";
                    boolean passwordEcho = false;
                    passwordCallback = new PasswordCallback(passwordPrompt, passwordEcho);
                    callbackList.add(infoOutputCallback);
                    callbackList.add(userNameCallback);
                    callbackList.add(passwordCallback);
                    if (errorOutputCallback != null) {
                        callbackList.add(errorOutputCallback);
                    }
                    Callback[] callbacks = callbackList.toArray(new Callback[callbackList.size()]);
                    try {
                        CallbackHandler handler = this.createCallbackHandler(addr, libName);
                        handler.handle(callbacks);
                        userName = userNameCallback.getName();
                        char[] pass = passwordCallback.getPassword();
                        try {
                            int passLen = pass == null ? 0 : pass.length;
                            userPass = new byte[passLen * 2];
                            if (passLen > 0) {
                                int ofs = 0;
                                for (int i = 0; i < passLen; ++i) {
                                    char c = pass[i];
                                    userPass[ofs++] = (byte)((c & 0xFF00) >> 4);
                                    userPass[ofs++] = (byte)(c & 0xFF);
                                }
                            }
                        }
                        finally {
                            if (pass != null) {
                                Arrays.fill(pass, '\u0000');
                            }
                        }
                        this.setDefaultUserName(userName);
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, e.getMessage(), e);
                        if (success) throw new IOException("Connection cancelled on user request");
                        if (socket == null) throw new IOException("Connection cancelled on user request");
                        socket.close();
                        throw new IOException("Connection cancelled on user request");
                    }
                }
                authenticated = false;
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
                boolean retry = socket != null && socket.isConnected();
                if (!retry) throw new IOException("Failed to connect to media library " + addr + "/" + libName + ": " + e.getMessage());
                lastError = e;
                continue;
            }
            try {
                dataOut.writeUTF(userName);
                int userPassLen = userPass == null ? 0 : userPass.length;
                dataOut.writeInt(userPassLen);
                if (userPassLen > 0) {
                    dataOut.write(userPass, 0, userPassLen);
                }
                dataOut.flush();
                byte rc = dataIn.readByte();
                if (rc != 0) {
                    throw new IOException("Handshake failed with return code: " + rc);
                }
                this.userName = userName;
                this.userPass = userPass;
                authenticated = true;
            }
            finally {
                if (!authenticated && userPass != null) {
                    Arrays.fill(userPass, (byte)0);
                    userPass = null;
                }
            }
            socket.setSoTimeout(this.socketTimeout);
            int inBufSize = this.getInputBufferSize();
            if (inBufSize < 262144) {
                inBufSize = 262144;
            }
            if ((outBufSize = this.getOutputBufferSize()) < 32768) {
                outBufSize = 32768;
            }
            Logger connLogger = Logger.getLogger(MediaConnection.class.getName() + "-" + this.name);
            MediaConnection conn = new MediaConnection(this.context, connLogger, socket, dataIn, inBufSize, dataOut, outBufSize);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("MediaClient connected: " + conn);
            }
            success = true;
            return conn;
            finally {
                passwordCallback.clearPassword();
            }
            finally {
                if (success || socket == null) continue;
                socket.close();
                continue;
            }
            break;
        }
    }

    public boolean isRemoteDecoding() {
        return this.remoteDecoding;
    }

    public void setRemoteDecoding(boolean remoteDecoding) {
        this.remoteDecoding = remoteDecoding;
    }

    public int getInputBufferSize() {
        return this.inputBufferSize;
    }

    public void setInputBufferSize(int inputBufferSize) {
        this.inputBufferSize = inputBufferSize;
    }

    public int getOutputBufferSize() {
        return this.outputBufferSize;
    }

    public void setOutputBufferSize(int outputBufferSize) {
        this.outputBufferSize = outputBufferSize;
    }

    protected class PostReleaseConnection
    implements Runnable {
        private PoolEntry poolEntry;

        public PostReleaseConnection(PoolEntry poolEntry) {
            this.poolEntry = poolEntry;
        }

        @Override
        public void run() {
            PoolEntry entry = this.poolEntry;
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("PostReleaseConnection: " + entry);
            }
            if (entry != null) {
                this.poolEntry = null;
                MediaClient.this.releaseConnection(entry);
            }
        }
    }

    protected class PoolEntry {
        protected PoolEntry next;
        protected MediaConnection connection;

        protected PoolEntry() {
        }
    }
}

