/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.library.remote;

import com.spacekiller.util.Resource;
import com.spacekiller.util.buffer.ByteArrayOutputBuffer;
import com.spacekiller.util.media.DefaultMediaCrateEntry;
import com.spacekiller.util.media.DefaultMediaEntry;
import com.spacekiller.util.media.MediaContext;
import com.spacekiller.util.media.MediaCrate;
import com.spacekiller.util.media.MediaCrateEntry;
import com.spacekiller.util.media.MediaEntry;
import com.spacekiller.util.media.MediaLibrary;
import com.spacekiller.util.media.MediaResource;
import com.spacekiller.util.media.MediaUtil;
import com.spacekiller.util.media.SeekableStream;
import com.spacekiller.util.media.library.SeekableAudioInputStream;
import com.spacekiller.util.media.library.remote.ProtocolConst;
import com.spacekiller.util.media.library.remote.RemoteInputStream;
import com.spacekiller.util.media.library.remote.RemoteMediaCrate;
import com.spacekiller.util.media.library.remote.RemoteMediaCrateInfo;
import com.spacekiller.util.media.library.remote.RemoteMediaLibrary;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.lang.ref.SoftReference;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.UnsupportedAudioFileException;

public class MediaConnection
implements ProtocolConst {
    public static final int DEFAULT_STREAM_BUFFER_SIZE = 65536;
    public static final int DEFAULT_BUFFER_POOL_CAPACITY = 16;
    private final MediaContext context;
    private final Logger logger;
    private final Socket socket;
    private final DataInputStream in;
    private final DataOutputStream out;
    private byte[] buf;
    private ByteArrayInputStream bais;
    private DataInputStream bdis;
    private ByteArrayOutputBuffer baos;
    private DataOutputStream bdos;
    private int streamBufferSize = 65536;
    private int bufferPoolCapacity = 16;
    private LinkedList bufferPool;

    public MediaConnection(MediaContext context, Logger logger, Socket socket, DataInputStream in, int inBufSize, DataOutputStream out, int outBufSize) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (logger == null) {
            throw new NullPointerException("logger");
        }
        if (socket == null) {
            throw new NullPointerException("socket");
        }
        this.context = context;
        this.logger = logger;
        this.socket = socket;
        this.in = in;
        this.out = out;
        this.bufferPool = new LinkedList();
        this.buf = new byte[inBufSize];
        this.bais = new ByteArrayInputStream(this.buf);
        this.bdis = new DataInputStream(this.bais);
        this.baos = new ByteArrayOutputBuffer(outBufSize);
        this.bdos = new DataOutputStream((OutputStream)this.baos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws IOException {
        if (this.socket.isClosed()) {
            return;
        }
        try {
            this.out.writeByte(99);
            this.out.flush();
        }
        finally {
            this.socket.close();
        }
    }

    public boolean isConnected() {
        Socket s = this.socket;
        return s == null ? false : s.isConnected();
    }

    public synchronized boolean containsMediaEntry(MediaResource resource) throws IOException {
        String remotePath = resource.getPath();
        this.baos.reset();
        this.bdos.writeUTF(remotePath);
        this.bdos.flush();
        int len = this.baos.getCount();
        byte[] data = this.baos.getBuffer();
        this.out.writeByte(-96);
        this.out.writeInt(len);
        this.out.write(data, 0, len);
        this.out.flush();
        byte rc = this.in.readByte();
        return rc == 0;
    }

    public synchronized MediaEntry getMediaEntry(MediaResource resource, int flags) throws IOException {
        String remotePath = resource.getPath();
        this.baos.reset();
        this.bdos.write(flags);
        this.bdos.writeUTF(remotePath);
        this.bdos.flush();
        int len = this.baos.getCount();
        byte[] data = this.baos.getBuffer();
        this.out.writeByte(-95);
        this.out.writeInt(len);
        this.out.write(data, 0, len);
        this.out.flush();
        byte rc = this.in.readByte();
        if (rc == 2) {
            return null;
        }
        if (rc != 0) {
            throw new IOException("getMediaEntry failed with return code: " + rc);
        }
        len = this.in.readInt();
        this.in.readFully(this.buf, 0, len);
        this.bais.reset();
        DefaultMediaEntry entry = new DefaultMediaEntry();
        entry.readEntry((DataInput)this.bdis, this.context);
        entry.setResource((Resource)resource);
        return entry;
    }

    public synchronized void getMediaEntries(List crateEntryList, int off, int num, int flags, Collection dstMediaEntries) throws IOException {
        MediaCrateEntry mce;
        this.baos.reset();
        this.bdos.write(flags);
        this.bdos.writeInt(num);
        for (int i = 0; i < num; ++i) {
            mce = (MediaCrateEntry)crateEntryList.get(off + i);
            MediaResource res = (MediaResource)mce.getResource();
            this.bdos.writeUTF(res.getPath());
        }
        this.bdos.flush();
        int len = this.baos.getCount();
        byte[] data = this.baos.getBuffer();
        this.out.writeByte(-94);
        this.out.writeInt(len);
        this.out.write(data, 0, len);
        this.out.flush();
        byte rc = this.in.readByte();
        if (rc != 0) {
            throw new IOException("getMediaEntries failed with return code: " + rc);
        }
        len = this.in.readInt();
        this.in.readFully(this.buf, 0, len);
        this.bais.reset();
        int num2 = this.bdis.readInt();
        if (num2 != num) {
            throw new IOException("getMediaEntries failed with invalid number of results: " + num2 + " != " + num);
        }
        for (int i = 0; i < num; ++i) {
            DefaultMediaEntry me;
            rc = this.bdis.readByte();
            if (rc == 0) {
                me = new DefaultMediaEntry();
                me.readEntry((DataInput)this.bdis, this.context);
                mce = (MediaCrateEntry)crateEntryList.get(off + i);
                me.setResource((Resource)((MediaResource)mce.getResource()));
            } else {
                me = null;
            }
            dstMediaEntries.add(me);
        }
    }

    public synchronized void putMediaEntry(MediaResource resource, MediaEntry entry) throws IOException {
        if (resource == null || entry == null) {
            throw new NullPointerException();
        }
        String remotePath = resource.getPath();
        this.baos.reset();
        this.bdos.writeUTF(remotePath);
        entry.writeEntry((DataOutput)this.bdos, (Resource)null);
        this.bdos.flush();
        int len = this.baos.getCount();
        byte[] data = this.baos.getBuffer();
        this.out.writeByte(-86);
        this.out.writeInt(len);
        this.out.write(data, 0, len);
        this.out.flush();
        byte rc = this.in.readByte();
        if (rc != 0) {
            throw new IOException("putMediaEntry failed with return code: " + rc);
        }
    }

    public synchronized void setUserRating(MediaResource resource, double rating) throws IOException {
        this.baos.reset();
        this.bdos.writeUTF(resource.getPath());
        this.bdos.writeDouble(rating);
        this.bdos.flush();
        int len = this.baos.getCount();
        byte[] data = this.baos.getBuffer();
        this.out.writeByte(-84);
        this.out.writeInt(len);
        this.out.write(data, 0, len);
        this.out.flush();
        byte rc = this.in.readByte();
        if (rc != 0) {
            throw new IOException("setUserRating failed with return code: " + rc);
        }
    }

    public synchronized void setUserComment(MediaResource resource, String comment) throws IOException {
        this.baos.reset();
        this.bdos.writeUTF(resource.getPath());
        MediaUtil.writeString((String)comment, (DataOutput)this.bdos);
        this.bdos.flush();
        int len = this.baos.getCount();
        byte[] data = this.baos.getBuffer();
        this.out.writeByte(-83);
        this.out.writeInt(len);
        this.out.write(data, 0, len);
        this.out.flush();
        byte rc = this.in.readByte();
        if (rc != 0) {
            throw new IOException("setUserRating failed with return code: " + rc);
        }
    }

    public synchronized RemoteMediaCrateInfo getCrateInfo(String crateId) throws IOException {
        this.out.writeByte(-75);
        this.out.writeUTF(crateId);
        this.out.flush();
        byte rc = this.in.readByte();
        if (rc != 0) {
            if (rc == 2) {
                throw new IOException("Remote crate not found: id=" + crateId);
            }
            throw new IOException("getCrateInfo failed with return code: " + rc);
        }
        String remoteCrateId = this.in.readUTF();
        String remoteCrateName = this.in.readUTF();
        String remoteCrateDescr = this.in.readUTF();
        boolean remoteCrateReadOnly = this.in.readBoolean();
        RemoteMediaCrateInfo info = new RemoteMediaCrateInfo();
        info.setRemoteCrateId(remoteCrateId);
        info.setRemoteCrateName(remoteCrateName);
        info.setRemoteCrateDescr(remoteCrateDescr);
        info.setRemoteCrateReadOnly(remoteCrateReadOnly);
        return info;
    }

    public synchronized void getSubCratesRecursive(RemoteMediaCrate crate, RemoteMediaLibrary library) throws IOException {
        String crateId = crate.getCrateId();
        this.out.writeByte(-73);
        this.out.writeUTF(crateId);
        this.out.flush();
        byte rc = this.in.readByte();
        if (rc != 0) {
            if (rc == 2) {
                throw new IOException("Remote crate not found: id=" + crateId);
            }
            throw new IOException("getSubCratesRecursive failed with return code: " + rc);
        }
        this.readSubCratesRecursive(crate, library);
    }

    protected void readSubCratesRecursive(RemoteMediaCrate crate, RemoteMediaLibrary library) throws IOException {
        int num = this.in.readInt();
        if (num < 0) {
            throw new StreamCorruptedException("Invalid number of entries: " + num);
        }
        ArrayList<DefaultMediaCrateEntry> listEntries = new ArrayList<DefaultMediaCrateEntry>(num);
        if (num > 0) {
            for (int i = 0; i < num; ++i) {
                String remotePath = this.in.readUTF();
                MediaResource mediaResource = new MediaResource((MediaLibrary)library, remotePath);
                listEntries.add(new DefaultMediaCrateEntry((MediaCrate)crate, (Resource)mediaResource));
            }
        }
        if ((num = this.in.readInt()) < 0) {
            throw new StreamCorruptedException("Invalid number of sub-crates: " + num);
        }
        ArrayList<RemoteMediaCrate> listCrates = new ArrayList<RemoteMediaCrate>(num);
        if (num > 0) {
            RemoteMediaCrate subCrate;
            int i;
            String localId = null;
            for (i = 0; i < num; ++i) {
                String subId = this.in.readUTF();
                String subName = this.in.readUTF();
                String subDescr = this.in.readUTF();
                boolean subReadOnly = this.in.readBoolean();
                subCrate = new RemoteMediaCrate(localId, subName, library, subId, subReadOnly);
                subCrate.setDescription(subDescr);
                subCrate.setDirty(false);
                listCrates.add(subCrate);
            }
            for (i = 0; i < num; ++i) {
                subCrate = (RemoteMediaCrate)((Object)listCrates.get(i));
                this.readSubCratesRecursive(subCrate, library);
            }
        }
        crate.load(listCrates, listEntries);
    }

    public synchronized void getSubCrates(String crateId, RemoteMediaLibrary library, Collection dstCrates) throws IOException {
        this.out.writeByte(-74);
        this.out.writeUTF(crateId);
        this.out.flush();
        byte rc = this.in.readByte();
        if (rc != 0) {
            if (rc == 2) {
                throw new IOException("Remote crate not found: id=" + crateId);
            }
            throw new IOException("getSubCrates failed with return code: " + rc);
        }
        int num = this.in.readInt();
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.finer("getSubCrates: crateId=" + crateId + ", count=" + num);
        }
        if (num < 0) {
            throw new IOException("Invalid number of sub-crates: " + num);
        }
        if (num > 0) {
            String localId = null;
            for (int i = 0; i < num; ++i) {
                String subId = this.in.readUTF();
                String subName = this.in.readUTF();
                String subDescr = this.in.readUTF();
                boolean subReadOnly = this.in.readBoolean();
                RemoteMediaCrate subCrate = new RemoteMediaCrate(localId, subName, library, subId, subReadOnly);
                subCrate.setDescription(subDescr);
                subCrate.setDirty(false);
                dstCrates.add(subCrate);
            }
        }
    }

    public synchronized void getCrateEntries(String crateId, RemoteMediaCrate crate, RemoteMediaLibrary library, Collection dstEntries) throws IOException {
        this.out.writeByte(-64);
        this.out.writeUTF(crateId);
        this.out.flush();
        byte rc = this.in.readByte();
        if (rc != 0) {
            if (rc == 2) {
                throw new IOException("Remote crate not found: id=" + crateId);
            }
            throw new IOException("getCrateEntries failed with return code: " + rc);
        }
        int num = this.in.readInt();
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.finer("getCrateEntries: crateId=" + crateId + ", count=" + num);
        }
        if (num < 0) {
            throw new IOException("Invalid number of crate-entries: " + num);
        }
        if (num > 0) {
            for (int i = 0; i < num; ++i) {
                String remotePath = this.in.readUTF();
                MediaResource mediaResource = new MediaResource((MediaLibrary)library, remotePath);
                dstEntries.add(new DefaultMediaCrateEntry((MediaCrate)crate, (Resource)mediaResource));
            }
        }
    }

    public synchronized InputStream createInputStream(MediaResource resource, boolean seekable, Runnable postCloseAction) throws IOException {
        if (resource == null) {
            throw new NullPointerException();
        }
        this.baos.reset();
        this.bdos.writeByte(1);
        this.bdos.writeBoolean(seekable);
        this.bdos.writeUTF(resource.getPath());
        this.bdos.flush();
        int len = this.baos.getCount();
        byte[] data = this.baos.getBuffer();
        this.out.writeByte(-56);
        this.out.writeInt(len);
        this.out.write(data, 0, len);
        this.out.flush();
        byte rc = this.in.readByte();
        if (rc != 0) {
            throw new IOException("createInputStream failed with return code " + rc + ": resource=" + resource);
        }
        len = this.in.readInt();
        this.in.readFully(this.buf, 0, len);
        this.bais.reset();
        int stream = this.bdis.readInt();
        long byteLength = this.bdis.readLong();
        long offset = 0L;
        return this.createRemoteInputStream(stream, offset, byteLength, postCloseAction);
    }

    public synchronized AudioInputStream createAudioInputStream(MediaResource resource, boolean seekable, Runnable postCloseAction) throws IOException, UnsupportedAudioFileException {
        if (resource == null) {
            throw new NullPointerException();
        }
        this.baos.reset();
        this.bdos.writeByte(2);
        this.bdos.writeByte(1);
        this.bdos.writeBoolean(seekable);
        this.bdos.writeUTF(resource.getPath());
        this.bdos.flush();
        int len = this.baos.getCount();
        byte[] data = this.baos.getBuffer();
        this.out.writeByte(-56);
        this.out.writeInt(len);
        this.out.write(data, 0, len);
        this.out.flush();
        byte rc = this.in.readByte();
        if (rc != 0) {
            throw new IOException("createAudioInputStream failed with return code " + rc + ": resource=" + resource);
        }
        len = this.in.readInt();
        this.in.readFully(this.buf, 0, len);
        this.bais.reset();
        int stream = this.bdis.readInt();
        long byteLength = this.bdis.readLong();
        AudioFormat audioFormat = MediaUtil.readAudioFormat((DataInput)this.bdis);
        int frameSize = audioFormat.getFrameSize();
        long frameLength = -1L;
        if (byteLength > 0L && frameSize > 0) {
            frameLength = byteLength / (long)frameSize;
        }
        long offset = 0L;
        RemoteInputStream ris = this.createRemoteInputStream(stream, offset, byteLength, postCloseAction);
        AudioInputStream ais = seekable ? new SeekableAudioInputStream(ris, ris, audioFormat, frameLength) : new AudioInputStream(ris, audioFormat, frameLength);
        return ais;
    }

    public synchronized AudioInputStream createAudioInputStream(MediaResource resource, AudioFormat targetFormat, boolean seekable, Runnable postCloseAction) throws IOException, UnsupportedAudioFileException {
        if (resource == null || targetFormat == null) {
            throw new NullPointerException();
        }
        this.baos.reset();
        this.bdos.writeByte(2);
        this.bdos.writeByte(2);
        this.bdos.writeBoolean(seekable);
        MediaUtil.writeAudioFormat((AudioFormat)targetFormat, (DataOutput)this.bdos);
        this.bdos.writeUTF(resource.getPath());
        this.bdos.flush();
        int len = this.baos.getCount();
        byte[] data = this.baos.getBuffer();
        this.out.writeByte(-56);
        this.out.writeInt(len);
        this.out.write(data, 0, len);
        this.out.flush();
        byte rc = this.in.readByte();
        if (rc != 0) {
            throw new IOException("createAudioInputStream failed with return code " + rc + ": resource=" + resource + ", targetFormat=" + targetFormat);
        }
        len = this.in.readInt();
        this.in.readFully(this.buf, 0, len);
        this.bais.reset();
        int stream = this.bdis.readInt();
        long byteLength = this.bdis.readLong();
        AudioFormat audioFormat = MediaUtil.readAudioFormat((DataInput)this.bdis);
        int frameSize = audioFormat.getFrameSize();
        long frameLength = -1L;
        if (byteLength > 0L && frameSize > 0) {
            frameLength = byteLength / (long)frameSize;
        }
        long offset = 0L;
        RemoteInputStream ris = this.createRemoteInputStream(stream, offset, byteLength, postCloseAction);
        AudioInputStream ais = seekable ? new SeekableAudioInputStream(ris, ris, audioFormat, frameLength) : new AudioInputStream(ris, audioFormat, frameLength);
        return ais;
    }

    public synchronized SeekableStream createSeekableInputStream(RemoteInputStream is, long pos, Runnable postCloseAction) throws IOException {
        int origStreamId = is.getStreamId();
        this.baos.reset();
        this.bdos.writeByte(3);
        this.bdos.writeInt(origStreamId);
        this.bdos.writeLong(pos);
        this.bdos.flush();
        int len = this.baos.getCount();
        byte[] data = this.baos.getBuffer();
        this.out.writeByte(-56);
        this.out.writeInt(len);
        this.out.write(data, 0, len);
        this.out.flush();
        byte rc = this.in.readByte();
        if (rc != 0) {
            throw new IOException("createSeekableInputStream failed with return code " + rc);
        }
        len = this.in.readInt();
        this.in.readFully(this.buf, 0, len);
        this.bais.reset();
        int stream = this.bdis.readInt();
        long byteLength = this.bdis.readLong();
        return this.createRemoteInputStream(stream, pos, byteLength, postCloseAction);
    }

    protected synchronized RemoteInputStream createRemoteInputStream(int stream, long offset, long length, Runnable postCloseAction) throws IOException {
        SoftReference ref;
        byte[] buffer = null;
        while (!(this.bufferPool.isEmpty() || (ref = (SoftReference)this.bufferPool.removeFirst()) != null && (buffer = (byte[])ref.get()) != null)) {
        }
        if (buffer == null) {
            int num = this.streamBufferSize;
            if (length > 0L && length < (long)num) {
                num = (int)length;
            }
            buffer = new byte[num];
        }
        return new RemoteInputStream(this, stream, offset, buffer, postCloseAction);
    }

    protected synchronized int read(int stream, byte[] b, int off, int len) throws IOException {
        if (off < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (off + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        this.out.writeByte(-55);
        this.out.writeInt(stream);
        this.out.writeInt(len);
        this.out.flush();
        byte rc = this.in.readByte();
        if (rc != 0) {
            throw new IOException("read failed with return code: " + rc);
        }
        int num = this.in.readInt();
        if (num > 0) {
            this.in.readFully(b, off, num);
        }
        return num;
    }

    protected synchronized void seek(int stream, long pos) throws IOException {
        if (pos < 0L) {
            throw new IOException("Invalid seek position: " + pos);
        }
        this.out.writeByte(-54);
        this.out.writeInt(stream);
        this.out.writeLong(pos);
        this.out.flush();
        byte rc = this.in.readByte();
        if (rc != 0) {
            throw new IOException("seek failed with return code: " + rc);
        }
    }

    protected synchronized void close(int stream, byte[] buffer) throws IOException {
        this.out.writeByte(-53);
        this.out.writeInt(stream);
        this.out.flush();
        byte rc = this.in.readByte();
        if (rc != 0) {
            throw new IOException("close failed with return code: " + rc);
        }
        if (buffer != null && buffer.length == this.streamBufferSize && this.bufferPool.size() < this.bufferPoolCapacity) {
            this.bufferPool.add(new SoftReference<byte[]>(buffer));
        }
    }

    public int getStreamBufferSize() {
        return this.streamBufferSize;
    }

    public void setStreamBufferSize(int streamBufferSize) {
        if (streamBufferSize < 1) {
            throw new IllegalArgumentException("Invalid stream buffer size: " + streamBufferSize);
        }
        this.streamBufferSize = streamBufferSize;
    }

    public int getBufferPoolCapacity() {
        return this.bufferPoolCapacity;
    }

    public void setBufferPoolCapacity(int bufferPoolCapacity) {
        this.bufferPoolCapacity = bufferPoolCapacity;
    }
}

