/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.library.remote;

import com.spacekiller.util.media.MediaContext;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class RemoteEndpointPanel
extends JPanel {
    private static final long serialVersionUID = -8876409253777812229L;
    private MediaContext mediaContext;
    private String hostName;
    private int port;
    private String libraryName;
    private boolean remoteDecoding;
    private boolean refreshing;
    private JTextField textFieldHost;
    private JTextField textFieldPort;
    private JTextField textFieldLibraryName;
    private JCheckBox chckbxRemoteDecoding;

    public RemoteEndpointPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        JPanel panelEndpoint = new JPanel();
        GridBagConstraints gbc_panelEndpoint = new GridBagConstraints();
        gbc_panelEndpoint.insets = new Insets(0, 0, 5, 0);
        gbc_panelEndpoint.weightx = 1.0;
        gbc_panelEndpoint.fill = 1;
        gbc_panelEndpoint.gridx = 0;
        gbc_panelEndpoint.gridy = 0;
        this.add((Component)panelEndpoint, gbc_panelEndpoint);
        GridBagLayout gbl_panelEndpoint = new GridBagLayout();
        gbl_panelEndpoint.columnWidths = new int[]{0, 0, 0, 0, 0};
        gbl_panelEndpoint.rowHeights = new int[]{0, 0, 0, 0};
        gbl_panelEndpoint.columnWeights = new double[]{0.0, 1.0, 0.0, 0.0, Double.MIN_VALUE};
        gbl_panelEndpoint.rowWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};
        panelEndpoint.setLayout(gbl_panelEndpoint);
        JLabel lblHost = new JLabel("Host Name:");
        GridBagConstraints gbc_lblHost = new GridBagConstraints();
        gbc_lblHost.insets = new Insets(4, 4, 5, 5);
        gbc_lblHost.anchor = 17;
        gbc_lblHost.gridx = 0;
        gbc_lblHost.gridy = 0;
        panelEndpoint.add((Component)lblHost, gbc_lblHost);
        this.textFieldHost = new JTextField();
        GridBagConstraints gbc_textFieldHost = new GridBagConstraints();
        gbc_textFieldHost.weightx = 1.0;
        gbc_textFieldHost.insets = new Insets(4, 4, 5, 5);
        gbc_textFieldHost.fill = 2;
        gbc_textFieldHost.gridx = 1;
        gbc_textFieldHost.gridy = 0;
        panelEndpoint.add((Component)this.textFieldHost, gbc_textFieldHost);
        this.textFieldHost.setColumns(10);
        JLabel lblPort = new JLabel("Port:");
        GridBagConstraints gbc_lblPort = new GridBagConstraints();
        gbc_lblPort.insets = new Insets(0, 0, 5, 5);
        gbc_lblPort.gridx = 2;
        gbc_lblPort.gridy = 0;
        panelEndpoint.add((Component)lblPort, gbc_lblPort);
        this.textFieldPort = new JTextField();
        GridBagConstraints gbc_textFieldPort = new GridBagConstraints();
        gbc_textFieldPort.insets = new Insets(4, 4, 5, 0);
        gbc_textFieldPort.fill = 2;
        gbc_textFieldPort.gridx = 3;
        gbc_textFieldPort.gridy = 0;
        panelEndpoint.add((Component)this.textFieldPort, gbc_textFieldPort);
        this.textFieldPort.setColumns(6);
        JLabel lblLibraryName = new JLabel("Library Name:");
        GridBagConstraints gbc_lblLibraryName = new GridBagConstraints();
        gbc_lblLibraryName.anchor = 17;
        gbc_lblLibraryName.insets = new Insets(4, 4, 5, 5);
        gbc_lblLibraryName.gridx = 0;
        gbc_lblLibraryName.gridy = 1;
        panelEndpoint.add((Component)lblLibraryName, gbc_lblLibraryName);
        this.textFieldLibraryName = new JTextField();
        GridBagConstraints gbc_textFieldLibraryName = new GridBagConstraints();
        gbc_textFieldLibraryName.gridwidth = 3;
        gbc_textFieldLibraryName.insets = new Insets(4, 4, 5, 0);
        gbc_textFieldLibraryName.fill = 2;
        gbc_textFieldLibraryName.gridx = 1;
        gbc_textFieldLibraryName.gridy = 1;
        panelEndpoint.add((Component)this.textFieldLibraryName, gbc_textFieldLibraryName);
        this.textFieldLibraryName.setColumns(10);
        this.chckbxRemoteDecoding = new JCheckBox("Remote Decoding");
        this.chckbxRemoteDecoding.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!RemoteEndpointPanel.this.refreshing) {
                    RemoteEndpointPanel.this.apply();
                }
            }
        });
        GridBagConstraints gbc_chckbxRemoteDecoding = new GridBagConstraints();
        gbc_chckbxRemoteDecoding.gridwidth = 2;
        gbc_chckbxRemoteDecoding.anchor = 17;
        gbc_chckbxRemoteDecoding.insets = new Insets(0, 0, 0, 5);
        gbc_chckbxRemoteDecoding.gridx = 0;
        gbc_chckbxRemoteDecoding.gridy = 2;
        panelEndpoint.add((Component)this.chckbxRemoteDecoding, gbc_chckbxRemoteDecoding);
        this.initRemoteEndpointPanel();
    }

    protected void initRemoteEndpointPanel() {
        DocumentListener docHandler = new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                if (!RemoteEndpointPanel.this.refreshing) {
                    RemoteEndpointPanel.this.apply();
                }
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                if (!RemoteEndpointPanel.this.refreshing) {
                    RemoteEndpointPanel.this.apply();
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                if (!RemoteEndpointPanel.this.refreshing) {
                    RemoteEndpointPanel.this.apply();
                }
            }
        };
        this.textFieldHost.getDocument().addDocumentListener(docHandler);
        this.textFieldPort.getDocument().addDocumentListener(docHandler);
        this.textFieldLibraryName.getDocument().addDocumentListener(docHandler);
    }

    public MediaContext getMediaContext() {
        return this.mediaContext;
    }

    public void setMediaContext(MediaContext mediaContext) {
        this.mediaContext = mediaContext;
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void refresh() {
        try {
            this.refreshing = true;
            String libName = this.getLibraryName();
            String host = this.getHostName();
            int port = this.getPort();
            boolean remoteDec = this.isRemoteDecoding();
            if (host == null) {
                host = "";
            }
            this.textFieldHost.setText(host);
            if (port < 1) {
                port = 8748;
            }
            this.textFieldPort.setText(String.valueOf(port));
            if (libName == null) {
                libName = "";
            }
            this.textFieldLibraryName.setText(libName);
            this.chckbxRemoteDecoding.setSelected(remoteDec);
        }
        finally {
            this.refreshing = false;
        }
    }

    public boolean showRemoteEndpointDialog(Component parentComponent, String title) {
        RemoteEndpointPanel message = this;
        int optionType = 2;
        int messageType = -1;
        int rc = JOptionPane.showConfirmDialog(parentComponent, message, title, optionType, messageType);
        return rc == 0;
    }

    protected JTextField getTextFieldHost() {
        return this.textFieldHost;
    }

    protected JTextField getTextFieldPort() {
        return this.textFieldPort;
    }

    public String getLibraryName() {
        return this.libraryName;
    }

    public void setLibraryName(String libraryName) {
        this.libraryName = libraryName;
        this.refresh();
    }

    public boolean isRemoteDecoding() {
        return this.remoteDecoding;
    }

    public void setRemoteDecoding(boolean remoteDecoding) {
        this.remoteDecoding = remoteDecoding;
        this.refresh();
    }

    protected JTextField getTextFieldLibraryName() {
        return this.textFieldLibraryName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
        this.refresh();
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
        this.refresh();
    }

    protected void apply() {
        this.hostName = this.textFieldHost.getText();
        this.libraryName = this.textFieldLibraryName.getText();
        this.remoteDecoding = this.chckbxRemoteDecoding.isSelected();
        int port = -1;
        try {
            port = Integer.parseInt(this.textFieldPort.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (port < 1) {
            port = 8748;
        }
        this.port = port;
    }

    protected JCheckBox getChckbxRemoteDecoding() {
        return this.chckbxRemoteDecoding;
    }
}

