/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.library.remote;

import com.spacekiller.util.media.SeekableStream;
import com.spacekiller.util.media.library.remote.MediaConnection;
import java.io.IOException;
import java.io.InputStream;

public class RemoteInputStream
extends InputStream
implements SeekableStream {
    private final MediaConnection conn;
    private final int stream;
    private final Runnable postCloseAction;
    private volatile byte[] buf;
    private int pos;
    private int count;
    private long ofs;
    private long mark;

    public RemoteInputStream(MediaConnection conn, int stream, long ofs, byte[] buffer, Runnable postCloseAction) {
        this.conn = conn;
        this.stream = stream;
        this.ofs = ofs;
        this.buf = buffer;
        this.postCloseAction = postCloseAction;
    }

    protected final int getStreamId() {
        return this.stream;
    }

    public InputStream getInputStream() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        byte[] buffer = this.buf;
        if (buffer == null) {
            return;
        }
        this.buf = null;
        try {
            this.conn.close(this.stream, buffer);
        }
        finally {
            Runnable action = this.postCloseAction;
            if (action != null) {
                action.run();
            }
        }
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        if (len < 1) {
            return 0;
        }
        byte[] buffer = this.buf;
        if (buffer == null) {
            throw new IOException("Stream closed: #" + this.stream);
        }
        int avail = this.count - this.pos;
        if (avail < 1) {
            this.load(buffer);
            avail = this.count - this.pos;
            if (avail < 1) {
                return -1;
            }
        }
        int n = Math.min(len, avail);
        System.arraycopy(buffer, this.pos, b, off, n);
        this.pos += n;
        return n;
    }

    @Override
    public synchronized int read() throws IOException {
        byte[] buffer = this.buf;
        if (buffer == null) {
            throw new IOException("Stream closed: #" + this.stream);
        }
        if (this.pos >= this.count) {
            this.load(buffer);
            if (this.pos >= this.count) {
                return -1;
            }
        }
        return buffer[this.pos++] & 0xFF;
    }

    @Override
    public synchronized long skip(long n) throws IOException {
        if (n < 1L) {
            return 0L;
        }
        this.seek(this.ofs + (long)this.pos + n);
        return n;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.mark = this.ofs + (long)this.pos;
    }

    @Override
    public synchronized void reset() throws IOException {
        this.seek(this.mark);
    }

    public long position() {
        return this.ofs + (long)this.pos;
    }

    public synchronized void seek(long p) throws IOException {
        byte[] buffer = this.buf;
        if (buffer == null) {
            throw new IOException("Stream closed: #" + this.stream);
        }
        if (p >= this.ofs && p < this.ofs + (long)this.count) {
            this.pos = (int)(p - this.ofs);
        } else {
            this.conn.seek(this.stream, p);
            this.pos = 0;
            this.count = 0;
            this.ofs = p;
        }
    }

    protected void load(byte[] buffer) throws IOException {
        int n;
        if (this.pos >= buffer.length) {
            this.ofs += (long)this.pos;
            this.pos = 0;
            this.count = 0;
        }
        if ((n = this.conn.read(this.stream, buffer, this.pos, buffer.length - this.pos)) > 0) {
            this.count = this.pos + n;
        }
    }
}

