/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.library.remote;

import com.spacekiller.util.media.DefaultMediaCrate;
import com.spacekiller.util.media.MediaCrate;
import com.spacekiller.util.media.MediaCrateEntry;
import com.spacekiller.util.media.MediaLibrary;
import com.spacekiller.util.media.library.remote.MediaClient;
import com.spacekiller.util.media.library.remote.RemoteMediaLibrary;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RemoteMediaCrate
extends DefaultMediaCrate {
    private static final Logger logger = Logger.getLogger(RemoteMediaCrate.class.getName());
    private final RemoteMediaLibrary library;
    private final String crateId;
    private final boolean readOnly;

    public RemoteMediaCrate(String id, String name, RemoteMediaLibrary library, String crateId, boolean readOnly) {
        super(id, name);
        if (library == null) {
            throw new NullPointerException("library");
        }
        this.library = library;
        this.crateId = crateId;
        this.readOnly = readOnly;
    }

    protected void init() {
        this.entries = null;
        this.crates = null;
    }

    public String getCrateId() {
        return this.crateId;
    }

    public String toString() {
        return String.valueOf(this.library) + "#" + this.crateId;
    }

    public MediaLibrary getLibrary() {
        RemoteMediaLibrary lib = this.library;
        if (lib != null) {
            return lib;
        }
        return super.getLibrary();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void getEntries(Collection dst) {
        this.lazyInitEntries(dst);
    }

    public int getEntryCount() {
        this.lazyInitEntries(null);
        return super.getEntryCount();
    }

    public MediaCrateEntry getEntryAt(int index) {
        this.lazyInitEntries(null);
        return super.getEntryAt(index);
    }

    public int getEntryIndex(MediaCrateEntry entry) {
        this.lazyInitEntries(null);
        return super.getEntryIndex(entry);
    }

    public void addEntry(MediaCrateEntry entry) {
        this.lazyInitEntries(null);
        super.addEntry(entry);
    }

    public void insertEntryAt(MediaCrateEntry entry, int index) {
        this.lazyInitEntries(null);
        super.insertEntryAt(entry, index);
    }

    public MediaCrateEntry removeEntryAt(int index) {
        this.lazyInitEntries(null);
        return super.removeEntryAt(index);
    }

    public int removeEntry(MediaCrateEntry entry) {
        this.lazyInitEntries(null);
        return super.removeEntry(entry);
    }

    public void getCrates(Collection dst) {
        this.lazyInitCrates(dst);
    }

    public int getCrateCount() {
        this.lazyInitCrates(null);
        return super.getCrateCount();
    }

    public MediaCrate getCrateAt(int index) {
        this.lazyInitCrates(null);
        return super.getCrateAt(index);
    }

    public int getCrateIndex(MediaCrate crate) {
        this.lazyInitCrates(null);
        return super.getCrateIndex(crate);
    }

    public void addCrate(MediaCrate crate) {
        this.lazyInitCrates(null);
        super.addCrate(crate);
    }

    public void insertCrateAt(MediaCrate crate, int index) {
        this.lazyInitCrates(null);
        super.insertCrateAt(crate, index);
    }

    public MediaCrate cloneMediaCrate() throws CloneNotSupportedException {
        RemoteMediaCrate clone = (RemoteMediaCrate)super.cloneMediaCrate();
        return clone;
    }

    public void refresh() {
        super.refresh();
        this.crates = null;
        this.entries = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadAll() {
        if (this.crates == null && this.entries == null) {
            RemoteMediaCrate remoteMediaCrate = this;
            synchronized (remoteMediaCrate) {
                if (this.crates == null && this.entries == null) {
                    RemoteMediaLibrary lib = this.library;
                    if (lib == null) {
                        return;
                    }
                    MediaClient client = lib.getClient();
                    if (client == null) {
                        return;
                    }
                    try {
                        client.getSubCratesRecursive(this, lib);
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, e.getMessage(), e);
                    }
                    return;
                }
            }
        }
        super.loadAll();
    }

    protected synchronized void load(ArrayList listCrates, ArrayList listEntries) {
        this.crates = listCrates;
        this.entries = listEntries;
        ((Object)((Object)this)).notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void lazyInitCrates(Collection dst) {
        if (this.crates != null) {
            if (dst != null) {
                List list = this.crates;
                synchronized (list) {
                    dst.addAll(this.crates);
                }
            }
            return;
        }
        RemoteMediaCrate remoteMediaCrate = this;
        synchronized (remoteMediaCrate) {
            if (this.crates != null) {
                if (dst != null) {
                    List list = this.crates;
                    synchronized (list) {
                        dst.addAll(this.crates);
                    }
                }
                return;
            }
        }
        ArrayList listCrates = null;
        try {
            listCrates = new ArrayList();
            RemoteMediaLibrary lib = this.library;
            if (lib == null) {
                return;
            }
            MediaClient client = lib.getClient();
            if (client == null) {
                return;
            }
            try {
                client.getSubCrates(this.crateId, this.library, listCrates);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
            if (dst != null) {
                dst.addAll(listCrates);
            }
        }
        finally {
            RemoteMediaCrate remoteMediaCrate2 = this;
            synchronized (remoteMediaCrate2) {
                this.crates = listCrates;
                ((Object)((Object)this)).notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void lazyInitEntries(Collection dst) {
        if (this.entries != null) {
            if (dst != null) {
                List list = this.entries;
                synchronized (list) {
                    dst.addAll(this.entries);
                }
            }
            return;
        }
        RemoteMediaCrate remoteMediaCrate = this;
        synchronized (remoteMediaCrate) {
            if (this.entries != null) {
                if (dst != null) {
                    List list = this.entries;
                    synchronized (list) {
                        dst.addAll(this.entries);
                    }
                }
                return;
            }
        }
        ArrayList listEntries = null;
        try {
            listEntries = new ArrayList();
            RemoteMediaLibrary lib = this.library;
            if (lib == null) {
                return;
            }
            MediaClient client = lib.getClient();
            if (client == null) {
                return;
            }
            try {
                client.getCrateEntries(this.crateId, this, this.library, listEntries);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
            if (dst != null) {
                dst.addAll(listEntries);
            }
        }
        finally {
            RemoteMediaCrate remoteMediaCrate2 = this;
            synchronized (remoteMediaCrate2) {
                this.entries = listEntries;
                ((Object)((Object)this)).notifyAll();
            }
        }
    }

    public void saveCrateRecursive() throws IOException {
        if (!this.isDirty()) {
            return;
        }
        logger.warning("TODO saveCrateRecursive: save remote crate changes: " + (Object)((Object)this) + " => " + this.library);
    }
}

