/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.library.remote;

import com.spacekiller.util.media.library.BaseMediaContext;
import com.spacekiller.util.media.library.remote.MediaClient;
import com.spacekiller.util.media.library.remote.RemoteMediaCrate;
import com.spacekiller.util.media.library.remote.RemoteMediaCrateInfo;
import com.spacekiller.util.media.library.remote.RemoteMediaLibrary;
import com.spacekiller.util.media.library.remote.RemoteMediaLibraryPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.net.SocketAddress;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class RemoteMediaCratePanel
extends JPanel {
    private static final long serialVersionUID = 5838665391673762970L;
    private static final Logger logger = Logger.getLogger(RemoteMediaCratePanel.class.getName());
    private BaseMediaContext mediaContext;
    private JTextField textFieldRemoteCrateId;
    private RemoteMediaLibraryPanel remoteMediaLibraryPanel;
    private JCheckBox chckbxReadonly;

    public RemoteMediaCratePanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        this.remoteMediaLibraryPanel = new RemoteMediaLibraryPanel();
        this.remoteMediaLibraryPanel.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "Remote Library", 4, 2, null, null));
        GridBagConstraints gbc_remoteMediaLibraryPanel = new GridBagConstraints();
        gbc_remoteMediaLibraryPanel.weighty = 1.0;
        gbc_remoteMediaLibraryPanel.weightx = 1.0;
        gbc_remoteMediaLibraryPanel.insets = new Insets(4, 4, 4, 4);
        gbc_remoteMediaLibraryPanel.fill = 1;
        gbc_remoteMediaLibraryPanel.gridx = 0;
        gbc_remoteMediaLibraryPanel.gridy = 0;
        this.add((Component)this.remoteMediaLibraryPanel, gbc_remoteMediaLibraryPanel);
        JPanel panelRemoteCrate = new JPanel();
        panelRemoteCrate.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "Remote Crate", 4, 2, null, null));
        GridBagConstraints gbc_panelRemoteCrate = new GridBagConstraints();
        gbc_panelRemoteCrate.insets = new Insets(4, 4, 4, 4);
        gbc_panelRemoteCrate.weightx = 1.0;
        gbc_panelRemoteCrate.fill = 1;
        gbc_panelRemoteCrate.gridx = 0;
        gbc_panelRemoteCrate.gridy = 1;
        this.add((Component)panelRemoteCrate, gbc_panelRemoteCrate);
        GridBagLayout gbl_panelRemoteCrate = new GridBagLayout();
        gbl_panelRemoteCrate.columnWidths = new int[]{0, 0, 0};
        gbl_panelRemoteCrate.rowHeights = new int[]{0, 0, 0};
        gbl_panelRemoteCrate.columnWeights = new double[]{0.0, 1.0, Double.MIN_VALUE};
        gbl_panelRemoteCrate.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        panelRemoteCrate.setLayout(gbl_panelRemoteCrate);
        JLabel lblRemoteCrateId = new JLabel("Crate ID:");
        GridBagConstraints gbc_lblRemoteCrateId = new GridBagConstraints();
        gbc_lblRemoteCrateId.anchor = 17;
        gbc_lblRemoteCrateId.insets = new Insets(4, 4, 5, 5);
        gbc_lblRemoteCrateId.gridx = 0;
        gbc_lblRemoteCrateId.gridy = 0;
        panelRemoteCrate.add((Component)lblRemoteCrateId, gbc_lblRemoteCrateId);
        this.textFieldRemoteCrateId = new JTextField();
        GridBagConstraints gbc_textFieldRemoteCrateId = new GridBagConstraints();
        gbc_textFieldRemoteCrateId.insets = new Insets(4, 4, 5, 5);
        gbc_textFieldRemoteCrateId.fill = 2;
        gbc_textFieldRemoteCrateId.gridx = 1;
        gbc_textFieldRemoteCrateId.gridy = 0;
        panelRemoteCrate.add((Component)this.textFieldRemoteCrateId, gbc_textFieldRemoteCrateId);
        this.textFieldRemoteCrateId.setColumns(10);
        this.chckbxReadonly = new JCheckBox("Read-Only");
        this.chckbxReadonly.setToolTipText("Read-only mode ?");
        GridBagConstraints gbc_chckbxReadonly = new GridBagConstraints();
        gbc_chckbxReadonly.gridwidth = 2;
        gbc_chckbxReadonly.anchor = 17;
        gbc_chckbxReadonly.insets = new Insets(0, 0, 0, 5);
        gbc_chckbxReadonly.gridx = 0;
        gbc_chckbxReadonly.gridy = 1;
        panelRemoteCrate.add((Component)this.chckbxReadonly, gbc_chckbxReadonly);
    }

    protected JTextField getTextFieldRemoteCrateId() {
        return this.textFieldRemoteCrateId;
    }

    protected RemoteMediaLibraryPanel getRemoteMediaLibraryPanel() {
        return this.remoteMediaLibraryPanel;
    }

    protected JCheckBox getChckbxReadonly() {
        return this.chckbxReadonly;
    }

    public BaseMediaContext getMediaContext() {
        return this.mediaContext;
    }

    public void setMediaContext(BaseMediaContext mediaContext) {
        this.mediaContext = mediaContext;
        this.remoteMediaLibraryPanel.setMediaContext(mediaContext);
        this.refresh();
    }

    public synchronized void refresh() {
    }

    public RemoteMediaCrate showRemoteMediaCrateDialog(Component parent) throws Exception {
        RemoteMediaCratePanel message = this;
        String title = "Open Remote Crate";
        int optionType = 2;
        int messageType = -1;
        int rc = JOptionPane.showConfirmDialog(parent, message, title, optionType, messageType);
        if (rc != 0) {
            return null;
        }
        RemoteMediaLibrary remoteLibrary = this.remoteMediaLibraryPanel.getRemoteMediaLibrary();
        if (remoteLibrary == null) {
            return null;
        }
        String remoteCrateId = this.textFieldRemoteCrateId.getText().trim();
        String crateName = null;
        String crateDescr = null;
        boolean crateReadOnly = false;
        String clientInfo = null;
        MediaClient client = remoteLibrary.getClient();
        if (client != null) {
            try {
                RemoteMediaCrateInfo info = client.getCrateInfo(remoteCrateId);
                if (info != null) {
                    crateName = info.getRemoteCrateName();
                    crateDescr = info.getRemoteCrateDescr();
                    crateReadOnly = info.isRemoteCrateReadOnly();
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
            SocketAddress addr = client.getEndpoint();
            if (addr != null) {
                clientInfo = addr.toString();
            }
        }
        if (crateName == null || crateName.length() < 1) {
            crateName = remoteCrateId;
        }
        if (clientInfo != null) {
            crateName = crateName + "@" + clientInfo;
        }
        if (this.chckbxReadonly.isSelected()) {
            crateReadOnly = true;
        }
        String crateId = null;
        RemoteMediaCrate remoteCrate = new RemoteMediaCrate(crateId, crateName, remoteLibrary, remoteCrateId, crateReadOnly);
        remoteCrate.setDescription(crateDescr);
        return remoteCrate;
    }
}

