/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.library.remote;

import com.spacekiller.util.Resource;
import com.spacekiller.util.media.MediaEntry;
import com.spacekiller.util.media.MediaResource;
import com.spacekiller.util.media.MutableMediaEntry;
import com.spacekiller.util.media.SeekableStream;
import com.spacekiller.util.media.library.BaseMediaContext;
import com.spacekiller.util.media.library.BaseMediaLibrary;
import com.spacekiller.util.media.library.SeekableAudioInputStream;
import com.spacekiller.util.media.library.remote.MediaClient;
import com.spacekiller.util.media.library.remote.RemoteInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.UnsupportedAudioFileException;

public class RemoteMediaLibrary
extends BaseMediaLibrary {
    private static final Logger logger = Logger.getLogger(RemoteMediaLibrary.class.getName());
    private MediaClient client;

    public RemoteMediaLibrary(String id, BaseMediaContext context, MediaClient client) {
        super(id, context);
        this.setClient(client);
    }

    public MediaClient getClient() {
        return this.client;
    }

    protected void setClient(MediaClient client) {
        if (client == null) {
            throw new NullPointerException("client");
        }
        this.client = client;
    }

    @Override
    public String toString() {
        return this.client.getEndpoint() + "/" + this.client.getLibraryName() + "[" + this.getId() + "]";
    }

    public void flush() throws IOException {
    }

    public boolean containsMediaEntry(Resource resource) throws IOException {
        if (resource != null && resource instanceof MediaResource) {
            return this.client.containsMediaEntry((MediaResource)resource);
        }
        return false;
    }

    public MediaEntry getMediaEntry(Resource resource) throws IOException {
        if (resource != null && resource instanceof MediaResource) {
            int flags = 0;
            return this.client.getMediaEntry((MediaResource)resource, flags);
        }
        return null;
    }

    public MediaEntry getMediaEntry(Resource resource, int flags) throws IOException {
        if (resource != null && resource instanceof MediaResource) {
            return this.client.getMediaEntry((MediaResource)resource, flags);
        }
        return null;
    }

    public void getMediaEntries(List crateEntryList, int off, int len, int flags, Collection dstMediaEntries) throws IOException {
        this.client.getMediaEntries(crateEntryList, off, len, flags, dstMediaEntries);
    }

    public void putMediaEntry(Resource resource, MediaEntry entry) throws IOException {
        this.client.putMediaEntry(this.getMediaResource(resource), entry);
    }

    public void setUserRating(MutableMediaEntry entry, double rating) throws IOException {
        entry.setUserRating(rating);
        MediaResource mediaResource = this.getMediaResource(entry.getResource());
        if (mediaResource != null) {
            this.client.setUserRating(mediaResource, rating);
        }
    }

    public void setUserComment(MutableMediaEntry entry, String comment) throws IOException {
        entry.setUserComment(comment);
        MediaResource mediaResource = this.getMediaResource(entry.getResource());
        if (mediaResource != null) {
            this.client.setUserComment(mediaResource, comment);
        }
    }

    @Override
    public InputStream createInputStream(Resource resource) throws IOException {
        return this.createInputStream(resource, false);
    }

    @Override
    public InputStream createInputStream(Resource resource, boolean seekable) throws IOException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("createInputStream: resource=" + resource + ", seekable=" + seekable);
        }
        MediaResource res = this.getMediaResource(resource);
        return this.client.createInputStream(res, seekable);
    }

    @Override
    public AudioInputStream createAudioInputStream(Resource resource) throws IOException, UnsupportedAudioFileException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("createAudioInputStream: resource=" + resource);
        }
        if (!this.client.isRemoteDecoding()) {
            return super.createAudioInputStream(resource);
        }
        MediaResource res = this.getMediaResource(resource);
        return this.client.createAudioInputStream(res, false);
    }

    @Override
    public AudioInputStream createAudioInputStream(Resource resource, boolean seekable) throws IOException, UnsupportedAudioFileException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("createAudioInputStream: seekable=" + seekable + ", resource=" + resource);
        }
        if (!this.client.isRemoteDecoding()) {
            return super.createAudioInputStream(resource, seekable);
        }
        MediaResource res = this.getMediaResource(resource);
        return this.client.createAudioInputStream(res, seekable);
    }

    @Override
    public AudioInputStream createAudioInputStream(Resource resource, AudioFormat targetFormat) throws IOException, UnsupportedAudioFileException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("createAudioInputStream: targetFormat=" + targetFormat + ", resource=" + resource);
        }
        if (!this.client.isRemoteDecoding()) {
            return super.createAudioInputStream(resource, targetFormat);
        }
        MediaResource res = this.getMediaResource(resource);
        return this.client.createAudioInputStream(res, targetFormat, false);
    }

    @Override
    public AudioInputStream createAudioInputStream(Resource resource, AudioFormat targetFormat, boolean seekable) throws IOException, UnsupportedAudioFileException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("createAudioInputStream: seekable=" + seekable + ", targetFormat=" + targetFormat + ", resource=" + resource);
        }
        if (!this.client.isRemoteDecoding()) {
            return super.createAudioInputStream(resource, targetFormat, seekable);
        }
        MediaResource res = this.getMediaResource(resource);
        return this.client.createAudioInputStream(res, targetFormat, seekable);
    }

    @Override
    public InputStream createSeekableInputStream(InputStream stream, long pos) throws IOException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("createSeekableInputStream: stream=" + stream + ", pos=" + pos);
        }
        if (!this.client.isRemoteDecoding()) {
            return super.createSeekableInputStream(stream, pos);
        }
        RemoteInputStream remote = this.getRemoteInputStream(stream);
        if (remote == null) {
            throw new IllegalArgumentException("Stream is not seekable: " + stream);
        }
        SeekableStream ss = this.client.createSeekableInputStream(remote, pos);
        return ss.getInputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AudioInputStream createSeekableAudioInputStream(AudioInputStream stream, long pos) throws IOException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("createSeekableAudioInputStream: stream=" + stream + ", pos=" + pos);
        }
        if (!this.client.isRemoteDecoding()) {
            return super.createSeekableAudioInputStream(stream, pos);
        }
        RemoteInputStream remote = this.getRemoteInputStream(stream);
        if (remote == null) {
            throw new IllegalArgumentException("Stream is not seekable: " + stream);
        }
        SeekableStream ss = this.client.createSeekableInputStream(remote, pos);
        InputStream is = ss.getInputStream();
        long frameLength = stream.getFrameLength();
        AudioFormat format = stream.getFormat();
        boolean done = false;
        try {
            SeekableAudioInputStream sais = new SeekableAudioInputStream(ss, is, format, frameLength);
            done = true;
            SeekableAudioInputStream seekableAudioInputStream = sais;
            return seekableAudioInputStream;
        }
        finally {
            if (!done && is != null) {
                is.close();
            }
        }
    }

    protected MediaResource getMediaResource(Resource resource) throws IOException {
        if (resource != null && resource instanceof MediaResource) {
            return (MediaResource)resource;
        }
        throw new IOException("Invalid remote media resource: " + resource);
    }

    protected RemoteInputStream getRemoteInputStream(InputStream stream) {
        if (stream != null) {
            SeekableAudioInputStream sais;
            SeekableStream ss;
            if (stream instanceof RemoteInputStream) {
                return (RemoteInputStream)stream;
            }
            if (stream instanceof SeekableAudioInputStream && (ss = (sais = (SeekableAudioInputStream)stream).getSeekableStream()) != null && ss instanceof RemoteInputStream) {
                return (RemoteInputStream)ss;
            }
        }
        return null;
    }
}

