/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.library.remote;

import com.spacekiller.util.media.MediaContext;
import com.spacekiller.util.media.MediaLibrary;
import com.spacekiller.util.media.library.BaseMediaContext;
import com.spacekiller.util.media.library.remote.MediaClient;
import com.spacekiller.util.media.library.remote.RemoteEndpointPanel;
import com.spacekiller.util.media.library.remote.RemoteMediaLibrary;
import com.spacekiller.util.media.library.remote.RemoteMediaResourcePanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class RemoteMediaLibraryPanel
extends JPanel {
    private static final long serialVersionUID = -351520838343029730L;
    private static final Logger logger = Logger.getLogger(RemoteMediaResourcePanel.class.getName());
    private BaseMediaContext mediaContext;
    private RemoteMediaLibrary remoteMediaLibrary;
    private DefaultListModel libraryListModel;
    private boolean refreshing;
    private JList listLibrary;
    private JButton btnAdd;
    private JButton btnRemove;
    private JButton btnEdit;

    public RemoteMediaLibraryPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        JScrollPane scrollPane = new JScrollPane();
        GridBagConstraints gbc_scrollPane = new GridBagConstraints();
        gbc_scrollPane.insets = new Insets(4, 4, 4, 4);
        gbc_scrollPane.weighty = 1.0;
        gbc_scrollPane.weightx = 1.0;
        gbc_scrollPane.fill = 1;
        gbc_scrollPane.gridx = 0;
        gbc_scrollPane.gridy = 0;
        this.add((Component)scrollPane, gbc_scrollPane);
        this.listLibrary = new JList();
        this.listLibrary.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!RemoteMediaLibraryPanel.this.refreshing) {
                    RemoteMediaLibraryPanel.this.handleLibrarySelected();
                }
                RemoteMediaLibraryPanel.this.checkEnable();
            }
        });
        this.listLibrary.setSelectionMode(0);
        this.listLibrary.setOpaque(false);
        scrollPane.setViewportView(this.listLibrary);
        JPanel panelActions = new JPanel();
        GridBagConstraints gbc_panelActions = new GridBagConstraints();
        gbc_panelActions.insets = new Insets(0, 4, 4, 4);
        gbc_panelActions.anchor = 13;
        gbc_panelActions.gridx = 0;
        gbc_panelActions.gridy = 1;
        this.add((Component)panelActions, gbc_panelActions);
        GridBagLayout gbl_panelActions = new GridBagLayout();
        gbl_panelActions.columnWidths = new int[]{0, 0, 0, 0};
        gbl_panelActions.rowHeights = new int[]{0, 0};
        gbl_panelActions.columnWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};
        gbl_panelActions.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panelActions.setLayout(gbl_panelActions);
        this.btnAdd = new JButton("Add");
        this.btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RemoteMediaLibraryPanel.this.actionAddRemoteLibrary();
            }
        });
        GridBagConstraints gbc_btnAdd = new GridBagConstraints();
        gbc_btnAdd.insets = new Insets(0, 0, 0, 5);
        gbc_btnAdd.gridx = 0;
        gbc_btnAdd.gridy = 0;
        panelActions.add((Component)this.btnAdd, gbc_btnAdd);
        this.btnRemove = new JButton("Remove");
        this.btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RemoteMediaLibraryPanel.this.actionRemoveRemoteLibrary();
            }
        });
        this.btnEdit = new JButton("Edit");
        this.btnEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RemoteMediaLibraryPanel.this.actionEditRemoteLibrary();
            }
        });
        GridBagConstraints gbc_btnEdit = new GridBagConstraints();
        gbc_btnEdit.insets = new Insets(0, 0, 0, 5);
        gbc_btnEdit.gridx = 1;
        gbc_btnEdit.gridy = 0;
        panelActions.add((Component)this.btnEdit, gbc_btnEdit);
        GridBagConstraints gbc_btnRemove = new GridBagConstraints();
        gbc_btnRemove.gridx = 2;
        gbc_btnRemove.gridy = 0;
        panelActions.add((Component)this.btnRemove, gbc_btnRemove);
        this.initRemoteMediaLibraryPanel();
    }

    protected void initRemoteMediaLibraryPanel() {
        this.libraryListModel = new DefaultListModel();
        this.listLibrary.setModel(this.libraryListModel);
        this.refresh();
    }

    protected JList getListLibrary() {
        return this.listLibrary;
    }

    public BaseMediaContext getMediaContext() {
        return this.mediaContext;
    }

    public synchronized void setMediaContext(BaseMediaContext mediaContext) {
        this.mediaContext = mediaContext;
        this.refresh();
    }

    public RemoteMediaLibrary getRemoteMediaLibrary() {
        return this.remoteMediaLibrary;
    }

    public synchronized void setRemoteMediaLibrary(RemoteMediaLibrary remoteMediaLibrary) {
        this.remoteMediaLibrary = remoteMediaLibrary;
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void refresh() {
        try {
            this.refreshing = true;
            RemoteMediaLibrary selLibrary = this.getRemoteMediaLibrary();
            MediaLibrary[] libs = null;
            BaseMediaContext ctx = this.getMediaContext();
            if (ctx != null) {
                try {
                    libs = ctx.getMediaLibraryArray();
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
            this.libraryListModel.clear();
            int selIndex = -1;
            int libCount = libs == null ? 0 : libs.length;
            for (int i = 0; i < libCount; ++i) {
                MediaLibrary lib = libs[i];
                if (lib == null || !(lib instanceof RemoteMediaLibrary)) continue;
                if (lib == selLibrary) {
                    selIndex = this.libraryListModel.size();
                }
                this.libraryListModel.addElement((RemoteMediaLibrary)lib);
            }
            if (selIndex < 0 && selLibrary != null) {
                selIndex = this.libraryListModel.size();
                this.libraryListModel.addElement(selLibrary);
            }
            if (selIndex >= 0) {
                this.listLibrary.setSelectedIndex(selIndex);
            }
            this.checkEnable();
        }
        finally {
            this.refreshing = false;
        }
    }

    protected JButton getBtnAdd() {
        return this.btnAdd;
    }

    protected JButton getBtnRemove() {
        return this.btnRemove;
    }

    protected void actionAddRemoteLibrary() {
        try {
            BaseMediaContext ctx = this.getMediaContext();
            if (ctx == null) {
                return;
            }
            RemoteEndpointPanel panel = new RemoteEndpointPanel();
            panel.setMediaContext((MediaContext)ctx);
            String title = "Add Remote Library";
            boolean confirm = panel.showRemoteEndpointDialog(this, title);
            if (!confirm) {
                return;
            }
            MediaClient client = this.createMediaClient(panel);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Created media client: " + client);
            }
            String libraryId = ctx.generateUniqueLibraryId();
            RemoteMediaLibrary remoteLibrary = new RemoteMediaLibrary(libraryId, this.mediaContext, client);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Created remote library proxy: " + remoteLibrary);
            }
            ctx.registerMediaLibrary(remoteLibrary);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Registered remote library proxy: " + remoteLibrary + " => " + (Object)((Object)ctx));
            }
            this.setRemoteMediaLibrary(remoteLibrary);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected MediaClient createMediaClient(RemoteEndpointPanel panel) {
        String hostName = panel.getHostName();
        if (hostName == null) {
            return null;
        }
        if ((hostName = hostName.trim()).length() < 1) {
            return null;
        }
        int port = panel.getPort();
        if (port < 1) {
            port = 8748;
        }
        InetSocketAddress socketAddress = new InetSocketAddress(hostName, port);
        String libraryName = panel.getLibraryName();
        if (libraryName == null) {
            return null;
        }
        boolean remoteDec = panel.isRemoteDecoding();
        MediaClient client = new MediaClient("MediaClient-" + libraryName, (MediaContext)this.mediaContext, this);
        client.setEndpoint(socketAddress);
        client.setLibraryName(libraryName);
        client.setRemoteDecoding(remoteDec);
        return client;
    }

    protected void actionEditRemoteLibrary() {
        try {
            BaseMediaContext ctx = this.getMediaContext();
            if (ctx == null) {
                return;
            }
            int index = this.listLibrary.getSelectedIndex();
            if (index < 0) {
                return;
            }
            RemoteMediaLibrary remoteLibrary = null;
            MediaLibrary lib = (MediaLibrary)this.libraryListModel.getElementAt(index);
            if (lib != null && lib instanceof RemoteMediaLibrary) {
                remoteLibrary = (RemoteMediaLibrary)lib;
            }
            if (remoteLibrary == null) {
                return;
            }
            MediaClient client = remoteLibrary.getClient();
            if (client == null) {
                return;
            }
            String hostName = null;
            int port = 0;
            SocketAddress endpoint = client.getEndpoint();
            if (endpoint != null && endpoint instanceof InetSocketAddress) {
                InetSocketAddress isa = (InetSocketAddress)endpoint;
                hostName = isa.getHostName();
                port = isa.getPort();
            }
            String libraryName = client.getLibraryName();
            boolean remoteDecoding = client.isRemoteDecoding();
            RemoteEndpointPanel panel = new RemoteEndpointPanel();
            panel.setMediaContext((MediaContext)ctx);
            panel.setHostName(hostName);
            panel.setPort(port);
            panel.setLibraryName(libraryName);
            panel.setRemoteDecoding(remoteDecoding);
            String title = "Edit Remote Library";
            boolean confirm = panel.showRemoteEndpointDialog(this, title);
            if (!confirm) {
                return;
            }
            client = this.createMediaClient(panel);
            if (client == null) {
                return;
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Created media client: " + client);
            }
            remoteLibrary.setClient(client);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Updated remote library proxy: " + remoteLibrary);
            }
            this.refresh();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected void actionRemoveRemoteLibrary() {
        try {
            BaseMediaContext ctx = this.getMediaContext();
            if (ctx == null) {
                return;
            }
            int index = this.listLibrary.getSelectedIndex();
            if (index < 0) {
                return;
            }
            MediaLibrary lib = (MediaLibrary)this.libraryListModel.getElementAt(index);
            if (lib == null) {
                return;
            }
            ctx.unregisterMediaLibrary(lib);
            if (this.remoteMediaLibrary == lib) {
                this.remoteMediaLibrary = null;
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Removed remote library proxy: " + lib);
            }
            this.refresh();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected void handleLibrarySelected() {
        MediaLibrary lib;
        RemoteMediaLibrary selLib = null;
        int index = this.listLibrary.getSelectedIndex();
        if (index >= 0 && (lib = (MediaLibrary)this.libraryListModel.getElementAt(index)) != null && lib instanceof RemoteMediaLibrary) {
            selLib = (RemoteMediaLibrary)lib;
        }
        this.remoteMediaLibrary = selLib;
    }

    protected void checkEnable() {
        boolean sel = this.listLibrary.getSelectedIndex() >= 0;
        this.btnEdit.setEnabled(sel);
        this.btnRemove.setEnabled(sel);
    }

    protected JButton getBtnEdit() {
        return this.btnEdit;
    }
}

