/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.library.remote;

import com.spacekiller.util.media.MediaLibrary;
import com.spacekiller.util.media.MediaResource;
import com.spacekiller.util.media.library.BaseMediaContext;
import com.spacekiller.util.media.library.remote.RemoteMediaLibrary;
import com.spacekiller.util.media.library.remote.RemoteMediaLibraryPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class RemoteMediaResourcePanel
extends JPanel {
    private static final long serialVersionUID = -1703714866759556661L;
    private BaseMediaContext mediaContext;
    private MediaResource mediaResource;
    private JTextField textFieldRemotePath;
    private RemoteMediaLibraryPanel remoteMediaLibraryPanel;

    public RemoteMediaResourcePanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        this.remoteMediaLibraryPanel = new RemoteMediaLibraryPanel();
        GridBagLayout gbl_remoteMediaLibraryPanel = (GridBagLayout)this.remoteMediaLibraryPanel.getLayout();
        gbl_remoteMediaLibraryPanel.rowWeights = new double[]{0.0};
        gbl_remoteMediaLibraryPanel.rowHeights = new int[]{0};
        gbl_remoteMediaLibraryPanel.columnWeights = new double[]{0.0};
        gbl_remoteMediaLibraryPanel.columnWidths = new int[]{0};
        this.remoteMediaLibraryPanel.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "Remote Library", 4, 2, null, null));
        GridBagConstraints gbc_remoteMediaLibraryPanel = new GridBagConstraints();
        gbc_remoteMediaLibraryPanel.weighty = 1.0;
        gbc_remoteMediaLibraryPanel.weightx = 1.0;
        gbc_remoteMediaLibraryPanel.insets = new Insets(4, 4, 4, 4);
        gbc_remoteMediaLibraryPanel.fill = 1;
        gbc_remoteMediaLibraryPanel.gridx = 0;
        gbc_remoteMediaLibraryPanel.gridy = 0;
        this.add((Component)this.remoteMediaLibraryPanel, gbc_remoteMediaLibraryPanel);
        JPanel panel = new JPanel();
        panel.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "Remote Resource", 4, 2, null, null));
        GridBagConstraints gbc_panel = new GridBagConstraints();
        gbc_panel.weightx = 1.0;
        gbc_panel.insets = new Insets(4, 4, 4, 4);
        gbc_panel.fill = 1;
        gbc_panel.gridx = 0;
        gbc_panel.gridy = 1;
        this.add((Component)panel, gbc_panel);
        GridBagLayout gbl_panel = new GridBagLayout();
        gbl_panel.columnWidths = new int[]{0, 0, 0};
        gbl_panel.rowHeights = new int[]{0, 0};
        gbl_panel.columnWeights = new double[]{0.0, 1.0, Double.MIN_VALUE};
        gbl_panel.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panel.setLayout(gbl_panel);
        JLabel lblPath = new JLabel("Resource ID:");
        lblPath.setToolTipText("Remote resource identifier");
        GridBagConstraints gbc_lblPath = new GridBagConstraints();
        gbc_lblPath.insets = new Insets(4, 4, 4, 4);
        gbc_lblPath.anchor = 13;
        gbc_lblPath.gridx = 0;
        gbc_lblPath.gridy = 0;
        panel.add((Component)lblPath, gbc_lblPath);
        this.textFieldRemotePath = new JTextField();
        this.textFieldRemotePath.setToolTipText("Remote resource identifier");
        GridBagConstraints gbc_textFieldRemotePath = new GridBagConstraints();
        gbc_textFieldRemotePath.insets = new Insets(4, 4, 4, 4);
        gbc_textFieldRemotePath.fill = 2;
        gbc_textFieldRemotePath.gridx = 1;
        gbc_textFieldRemotePath.gridy = 0;
        panel.add((Component)this.textFieldRemotePath, gbc_textFieldRemotePath);
        this.textFieldRemotePath.setColumns(10);
    }

    protected JTextField getTextFieldRemotePath() {
        return this.textFieldRemotePath;
    }

    protected RemoteMediaLibraryPanel getRemoteMediaLibraryPanel() {
        return this.remoteMediaLibraryPanel;
    }

    public BaseMediaContext getMediaContext() {
        return this.mediaContext;
    }

    public synchronized void setMediaContext(BaseMediaContext mediaContext) {
        this.mediaContext = mediaContext;
        this.remoteMediaLibraryPanel.setMediaContext(mediaContext);
        this.refresh();
    }

    public MediaResource getMediaResource() {
        return this.mediaResource;
    }

    public synchronized void setMediaResource(MediaResource mediaResource) {
        this.mediaResource = mediaResource;
        this.refresh();
    }

    public synchronized void refresh() {
        MediaLibrary lib = null;
        String resourceId = null;
        MediaResource res = this.getMediaResource();
        if (res != null) {
            lib = res.getLibrary();
            resourceId = res.getPath();
        }
        RemoteMediaLibrary remoteMediaLibrary = null;
        if (lib != null && lib instanceof RemoteMediaLibrary) {
            remoteMediaLibrary = (RemoteMediaLibrary)lib;
        }
        this.remoteMediaLibraryPanel.setRemoteMediaLibrary(remoteMediaLibrary);
        if (resourceId == null) {
            resourceId = "";
        }
        this.textFieldRemotePath.setText(resourceId);
    }

    public boolean showRemoteMediaResourceDialog(Component parent) throws Exception {
        RemoteMediaResourcePanel message = this;
        String title = "Remote Media Resource";
        int optionType = 2;
        int messageType = -1;
        int rc = JOptionPane.showConfirmDialog(parent, message, title, optionType, messageType);
        if (rc != 0) {
            return false;
        }
        RemoteMediaLibrary remoteLibrary = this.remoteMediaLibraryPanel.getRemoteMediaLibrary();
        if (remoteLibrary == null) {
            return false;
        }
        String resourceId = this.textFieldRemotePath.getText().trim();
        if (resourceId.length() < 1) {
            return false;
        }
        MediaResource remoteResource = new MediaResource((MediaLibrary)remoteLibrary, resourceId);
        this.setMediaResource(remoteResource);
        return true;
    }
}

