/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.library.serato;

import java.io.IOException;

public class SeratoAutotags {
    public static final String SERATO_AUTOTAGS = "Serato Autotags";

    public static void main(String[] args) {
        double testBPM = 133.77;
        String autoTagsTest = "\u0000\u0001\u0001" + testBPM + '\u0000' + "XYZ" + '\u0000' + "ABC";
        try {
            double bpm = SeratoAutotags.parseSeratoBPM(autoTagsTest.getBytes());
            System.out.println("Parsed BPM: " + bpm);
            if (bpm != testBPM) {
                throw new RuntimeException("Invalid bpm: " + bpm + " != " + testBPM);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static double parseSeratoBPM(byte[] autoTagsData) throws IOException {
        int endIndex;
        int len = autoTagsData.length;
        if (len > 3 && autoTagsData[0] == 0 && autoTagsData[1] == 1 && autoTagsData[2] == 1 && (endIndex = SeratoAutotags.indexOf(autoTagsData, 3, (byte)0)) > 3) {
            String bpmString = new String(autoTagsData, 3, endIndex - 3).trim();
            try {
                double bpm = Double.parseDouble(bpmString);
                if (bpm > 10.0) {
                    return bpm;
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return Double.NaN;
    }

    private static int indexOf(byte[] data, int from, byte search) {
        int len = data.length - from;
        for (int i = 0; i < len; ++i) {
            if (data[from] == search) {
                return from;
            }
            ++from;
        }
        return -1;
    }
}

