/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.library.serato;

import com.spacekiller.util.media.library.serato.SeratoCrateInputStream;
import com.spacekiller.util.media.library.serato.SeratoCrateOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SeratoCrateFile {
    private static final Logger logger = Logger.getLogger(SeratoCrateFile.class.getName());
    private static final String DEFAULT_VERSION = "81.0";
    private static final String DEFAULT_SORTING = "song";
    private static final long DEFAULT_SORTING_REV = 256L;
    private String version;
    private String sorting;
    private long sortingRev = Integer.MIN_VALUE;
    private List columns = new ArrayList();
    private List tracks = new ArrayList();

    public void addTrack(String nameAsString) {
        this.tracks.add(nameAsString);
    }

    public void addTracks(Collection names) {
        this.tracks.addAll(names);
    }

    public void setVersion(String version) {
        if (version.length() != 4) {
            throw new IllegalStateException("Version should be 4 characters long. E.g. default version is '81.0'");
        }
        this.version = version;
    }

    public String getVersion() {
        return this.version != null ? this.version : DEFAULT_VERSION;
    }

    public String getSorting() {
        return this.sorting != null ? this.sorting : DEFAULT_SORTING;
    }

    public void setSorting(String sorting) {
        this.sorting = sorting;
    }

    public long getSortingRev() {
        return this.sortingRev != Integer.MIN_VALUE ? this.sortingRev : 256L;
    }

    public void setSortingRev(long sortingRev) {
        this.sortingRev = sortingRev;
    }

    public void addColumn(String nameAsString) {
        this.columns.add(nameAsString);
    }

    public String[] getColumns() {
        return this.columns.toArray(new String[this.columns.size()]);
    }

    public String[] getTracks() {
        return this.tracks.toArray(new String[this.tracks.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isSeratoCrateFile(File inFile) throws IOException {
        SeratoCrateInputStream in = new SeratoCrateInputStream(new FileInputStream(inFile));
        try {
            in.skipExactString("vrsn");
            in.skipExactByte((byte)0);
            in.skipExactByte((byte)0);
            in.readStringUTF16(8);
            in.skipExactStringUTF16("/Serato ScratchLive Crate");
            boolean bl = true;
            return bl;
        }
        catch (StreamCorruptedException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SeratoCrateFile readFrom(File inFile) throws IOException {
        SeratoCrateFile result = new SeratoCrateFile();
        byte[] buf = new byte[32768];
        SeratoCrateInputStream in = new SeratoCrateInputStream(new FileInputStream(inFile));
        try {
            in.skipExactString("vrsn");
            in.skipExactByte((byte)0);
            in.skipExactByte((byte)0);
            result.setVersion(in.readStringUTF16(8));
            in.skipExactStringUTF16("/Serato ScratchLive Crate");
            while (in.available() >= 4) {
                String type = in.readString(4);
                int blockLen = in.readIntegerValue();
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("Block: type=" + type + ", len=" + blockLen);
                }
                if (blockLen < 0 || blockLen > buf.length) {
                    throw new StreamCorruptedException("Invalid block length: " + blockLen);
                }
                in.readFully(buf, 0, blockLen);
                if ("otrk".equals(type)) {
                    result.readTrack(buf, 0, blockLen, result);
                    continue;
                }
                if ("ovct".equals(type)) {
                    result.readColumn(buf, 0, blockLen, result);
                    continue;
                }
                if ("osrt".equals(type)) {
                    result.readSorting(buf, 0, blockLen, result);
                    continue;
                }
                if (!logger.isLoggable(Level.INFO)) continue;
                logger.info("Ignoring unsupported block type: " + type + " (" + blockLen + " bytes)");
            }
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {}
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readTrack(byte[] buf, int off, int len, SeratoCrateFile result) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(buf, off, len);
        SeratoCrateInputStream scis = new SeratoCrateInputStream(bais);
        try {
            scis.skipExactString("ptrk");
            int nameLength = scis.readIntegerValue();
            if (len - nameLength != 8) {
                throw new StreamCorruptedException("Expected (otrk - ptrk) == 8, but found " + (len - nameLength) + " (blockLen = " + len + ", ptrk = " + nameLength + ")");
            }
            String nameAsString = scis.readStringUTF16(nameLength);
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Track: " + nameAsString);
            }
            result.addTrack(nameAsString);
        }
        finally {
            scis.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readColumn(byte[] buf, int off, int len, SeratoCrateFile result) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(buf, off, len);
        SeratoCrateInputStream scis = new SeratoCrateInputStream(bais);
        try {
            scis.skipExactString("tvcn");
            int tvcnValue = scis.readIntegerValue();
            String column = scis.readStringUTF16(tvcnValue);
            result.addColumn(column);
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Column: " + column);
            }
            scis.skipExactString("tvcw");
            int tvcwValue = scis.readIntegerValue();
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("tvcwValue: " + tvcwValue);
            }
            scis.skipExactByte((byte)0);
        }
        finally {
            scis.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readSorting(byte[] buf, int off, int len, SeratoCrateFile result) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(buf, off, len);
        SeratoCrateInputStream scis = new SeratoCrateInputStream(bais);
        try {
            scis.skipExactString("tvcn");
            int tvcnValue = scis.readIntegerValue();
            String sorting = scis.readStringUTF16(tvcnValue);
            result.setSorting(sorting);
            scis.skipExactString("brev");
            long sortingRev = scis.readLongValue(5);
            result.setSortingRev(sortingRev);
            if (len - tvcnValue != 17) {
                throw new StreamCorruptedException("Expected (osrt - tvcn) == 17, but found " + (len - tvcnValue) + " (blockLen = " + len + ", tvcn = " + tvcnValue + ")");
            }
        }
        finally {
            scis.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream outStream) throws IOException {
        SeratoCrateOutputStream out = new SeratoCrateOutputStream(outStream);
        try {
            out.writeBytes("vrsn");
            out.write(0);
            out.write(0);
            out.writeUTF16(this.getVersion());
            out.writeUTF16("/Serato ScratchLive Crate");
            out.writeBytes("osrt");
            out.writeInt(this.getSorting().length() * 2 + 17);
            out.writeBytes("tvcn");
            out.writeInt(this.getSorting().length() * 2);
            out.writeUTF16(this.getSorting());
            out.writeBytes("brev");
            out.writeLong(this.getSortingRev(), 5);
            for (String column : this.columns) {
                out.writeBytes("ovct");
                out.writeInt(column.length() * 2 + 18);
                out.writeBytes("tvcn");
                out.writeInt(column.length() * 2);
                out.writeUTF16(column);
                out.writeBytes("tvcw");
                out.writeInt(2);
                out.write(0);
                out.write(48);
            }
            for (String trackRaw : this.tracks) {
                String track = this.getUniformTrackName(trackRaw);
                out.writeBytes("otrk");
                out.writeInt(track.length() * 2 + 8);
                out.writeBytes("ptrk");
                out.writeInt(track.length() * 2);
                out.writeUTF16(track);
            }
        }
        finally {
            out.close();
        }
    }

    private String getUniformTrackName(String name) {
        name = name.replaceAll("\\\\", "/");
        name = name.replaceAll("^[a-zA-Z]\\:\\/", "");
        name = name.replaceAll("^/Volumes/[^/]+/", "");
        return name;
    }

    public void writeTo(File outFile) throws IOException {
        this.writeTo(new FileOutputStream(outFile));
    }
}

