/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.library.serato;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamCorruptedException;

public class SeratoCrateInputStream
extends DataInputStream {
    public SeratoCrateInputStream(InputStream in) {
        super(in);
    }

    public long readLongValue(int bytes) throws IOException {
        long nameLength = 0L;
        for (int i = 0; i < bytes; ++i) {
            nameLength <<= 8;
            nameLength += (long)this.readUnsignedByte();
        }
        return nameLength;
    }

    public int readIntegerValue() throws IOException {
        int nameLength = 0;
        for (int i = 0; i < 4; ++i) {
            nameLength <<= 8;
            nameLength += this.readUnsignedByte();
        }
        return nameLength;
    }

    public boolean skipExactString(String expected) throws IOException {
        byte[] data = new byte[expected.length()];
        int read = this.read(data);
        if (read < 0) {
            return true;
        }
        if (read != data.length) {
            throw new StreamCorruptedException("Expected '" + expected + "', but read only " + read + " bytes");
        }
        String dataAsString = new String(data);
        if (!expected.equals(dataAsString)) {
            throw new StreamCorruptedException("Expected '" + expected + "' but found '" + dataAsString + "'");
        }
        return false;
    }

    public boolean skipExactStringUTF16(String expected) throws IOException {
        byte[] data = new byte[expected.length() << 1];
        int read = this.read(data);
        if (read < 0) {
            return true;
        }
        if (read != data.length) {
            throw new StreamCorruptedException("Expected '" + expected + "', but read only " + read + " bytes");
        }
        String dataAsString = new String(data, "UTF-16");
        if (!expected.equals(dataAsString)) {
            throw new StreamCorruptedException("Expected '" + expected + "' but found '" + dataAsString + "'");
        }
        return false;
    }

    public boolean skipExactByte(byte expected) throws IOException {
        byte[] data = new byte[1];
        int read = this.read(data);
        if (read < 0) {
            return true;
        }
        if (read != data.length) {
            throw new StreamCorruptedException("Expected a single byte '" + expected + "', but was unable to read anything");
        }
        if (data[0] != expected) {
            throw new StreamCorruptedException("Expected a single byte " + expected + " but found '" + data[0] + "'");
        }
        return false;
    }

    public String readStringUTF16(int length) throws IOException {
        byte[] data = new byte[length];
        int read = this.read(data);
        if (read != length) {
            throw new StreamCorruptedException("Expected to read " + length + " bytes, but read only " + read);
        }
        return new String(data, "UTF-16");
    }

    public String readString(int length) throws IOException {
        byte[] data = new byte[length];
        int read = this.read(data);
        if (read != length) {
            throw new StreamCorruptedException("Expected to read " + length + " bytes, but read only " + read);
        }
        return new String(data);
    }
}

