/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.library.serato;

import com.spacekiller.util.Resource;
import com.spacekiller.util.media.DefaultMediaCrateEntry;
import com.spacekiller.util.media.MediaCrate;
import com.spacekiller.util.media.MediaCrateEntry;
import com.spacekiller.util.media.library.serato.SeratoMediaCrate;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SeratoExport {
    private static final Logger logger = Logger.getLogger(SeratoExport.class.getName());
    private File targetSeratoFolder;

    public SeratoExport(File targetSeratoFolder) {
        this.targetSeratoFolder = targetSeratoFolder;
    }

    public void exportCratesToSerato(MediaCrate[] crates) throws IOException {
        for (MediaCrate crate : crates) {
            String crateFilePathPrefix;
            String crateName = this.convertCrateName(crate.getName());
            String crateId = crateFilePathPrefix = new File(this.targetSeratoFolder, crateName).getPath();
            SeratoMediaCrate seratoCrate = this.createSeratoMediaCrate(crateId, crate, crateFilePathPrefix);
            if (logger.isLoggable(Level.INFO)) {
                logger.info("Exporting serato crate: " + seratoCrate.getPath());
            }
            seratoCrate.saveCrateRecursive();
        }
    }

    protected SeratoMediaCrate createSeratoMediaCrate(String id, MediaCrate crate, String crateFilePathPrefix) throws IOException {
        File crateFile;
        String name = crate.getName();
        String crateFilePath = crateFilePathPrefix + ".crate";
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Generating serato crate: " + crateFilePath);
        }
        if ((crateFile = new File(crateFilePath)).exists() && crateFile.isFile()) {
            File backupFile = new File(crateFilePath + ".bak");
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Backup serato crate file: " + crateFile + " -> " + backupFile);
            }
            if (backupFile.exists() && !backupFile.delete()) {
                throw new IOException("Failed to delete old crate backup file: " + backupFile);
            }
            if (!crateFile.renameTo(backupFile)) {
                throw new IOException("Failed to rename old crate file: " + crateFile + " -> " + backupFile);
            }
        }
        SeratoMediaCrate newCrate = new SeratoMediaCrate(id, name, crateFilePath);
        newCrate.setDirty(true);
        LinkedList list = new LinkedList();
        crate.getEntries(list);
        if (!list.isEmpty()) {
            for (MediaCrateEntry mce : list) {
                Resource resource;
                if (mce == null || (resource = mce.getResource()) == null) continue;
                newCrate.addEntry((MediaCrateEntry)new DefaultMediaCrateEntry((MediaCrate)newCrate, resource));
            }
        }
        list.clear();
        crate.getCrates(list);
        if (!list.isEmpty()) {
            for (MediaCrate sub : list) {
                String subCratePathPrefix;
                if (sub == null) continue;
                String subName = this.convertCrateName(sub.getName());
                String subId = id + "%%" + subName;
                SeratoMediaCrate newSubCrate = this.createSeratoMediaCrate(subId, sub, subCratePathPrefix = crateFilePathPrefix + "%%" + subName);
                if (newSubCrate == null) continue;
                newCrate.addCrate((MediaCrate)newSubCrate);
            }
        }
        return newCrate;
    }

    protected String convertCrateName(String crateName) {
        int x;
        String seratoName = crateName;
        if (seratoName == null) {
            seratoName = "";
        }
        seratoName = seratoName.replace('%', '_');
        seratoName = seratoName.replace(':', '_');
        seratoName = seratoName.replace(';', '_');
        seratoName = seratoName.replace('/', '_');
        seratoName = seratoName.replace('\\', '_');
        seratoName = seratoName.replace('|', '_');
        seratoName = seratoName.replace('+', '_');
        seratoName = seratoName.replace('*', '_');
        seratoName = seratoName.replace('?', '_');
        seratoName = seratoName.replace('<', '_');
        seratoName = seratoName.replace('>', '_');
        while ((x = seratoName.indexOf("__")) >= 0) {
            seratoName = seratoName.substring(0, x) + seratoName.substring(x + 1);
        }
        if (crateName.length() < 1) {
            throw new IllegalArgumentException("Invalid crate name: " + crateName + " -> " + seratoName);
        }
        return seratoName;
    }
}

