/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.library.serato;

import com.spacekiller.util.heap.Heap;
import com.spacekiller.util.media.MediaContext;
import com.spacekiller.util.media.MediaCrate;
import com.spacekiller.util.media.library.CrateFile;
import com.spacekiller.util.media.library.CrateFileMediaCrate;
import com.spacekiller.util.media.library.DefaultMediaContext;
import com.spacekiller.util.media.library.dir.DefaultDirectoryMediaIndex;
import com.spacekiller.util.media.library.serato.SeratoExport;
import com.spacekiller.util.media.library.serato.SeratoExportMediaLibrary;
import com.spacekiller.util.media.library.serato.SeratoUtil;
import com.spacekiller.util.sound.SoundSystem;
import java.awt.Component;
import java.io.File;
import java.io.PrintStream;
import java.util.LinkedList;

public class SeratoExportMain {
    public static void main(String[] args) {
        new SeratoExportMain().mainImpl(args);
    }

    public void mainImpl(String[] args) {
        try {
            String targetSeratoFolderName;
            File targetSeratoFolder;
            if (args.length != 2) {
                System.out.println("ERROR: Invalid arguments: " + args.length + " != 2");
                this.help(System.out);
                this.info("FAILED: Please try again using valid parameters !");
                System.exit(1);
                return;
            }
            String sourceCratesFilePath = args[0];
            String targetSeratoFolderPath = args[1];
            this.info("Source crates file: " + sourceCratesFilePath);
            this.info("Target serato folder: " + targetSeratoFolderPath);
            File sourceCratesFile = new File(sourceCratesFilePath);
            if (!sourceCratesFile.exists() || !sourceCratesFile.isFile()) {
                this.info("ERROR: Source crates file not found: " + sourceCratesFile);
                System.exit(3);
            }
            if (!CrateFile.isMediaCrateFile(sourceCratesFile)) {
                this.info("ERROR: Invalid source crates file: " + sourceCratesFile);
                this.info("INFO: The source file must be a valid media crates file: e.g. media.crates");
                System.exit(4);
            }
            if (!(targetSeratoFolder = new File(targetSeratoFolderPath)).exists() || !targetSeratoFolder.isDirectory()) {
                this.info("ERROR: Target serato folder not found: " + targetSeratoFolder);
                System.exit(5);
            }
            if (!(targetSeratoFolderName = targetSeratoFolder.getName()).equalsIgnoreCase("Subcrates")) {
                this.info("WARNING: Unexpected target folder name: " + targetSeratoFolderName);
                this.info("INFO: Usual serato folder name: _Serato_/Subcrates");
            }
            MediaContext parentContext = null;
            DefaultDirectoryMediaIndex directoryMediaIndex = new DefaultDirectoryMediaIndex();
            SoundSystem soundSystem = null;
            Heap mediaHeap = null;
            int blockSize = -1;
            DefaultMediaContext dummyContext = new DefaultMediaContext(parentContext, directoryMediaIndex, soundSystem, mediaHeap, blockSize);
            String dummyId = "";
            SeratoExportMediaLibrary dummyLibrary = new SeratoExportMediaLibrary(dummyId, dummyContext);
            Component dummyParent = null;
            this.info("Reading crates from file: " + sourceCratesFile);
            LinkedList listMainCrates = new LinkedList();
            CrateFileMediaCrate rootCrate = new CrateFileMediaCrate(dummyId, dummyParent, dummyLibrary, sourceCratesFile);
            rootCrate.getCrates(listMainCrates);
            MediaCrate[] crates = listMainCrates.toArray(new MediaCrate[listMainCrates.size()]);
            this.info("Number of main crates: " + crates.length);
            this.info("Exporting crates to directory: " + targetSeratoFolder);
            SeratoExport seratoExport = new SeratoExport(targetSeratoFolder);
            seratoExport.exportCratesToSerato(crates);
            this.info("SUCCESS: Crates exported successfully.");
            System.exit(0);
        }
        catch (Throwable e) {
            this.info("ERROR: An unexpected error occured:");
            this.error(e);
            System.exit(2);
        }
    }

    protected void info(String s) {
        System.out.println(s);
    }

    protected void error(Throwable e) {
        e.printStackTrace(System.out);
    }

    public void help(PrintStream out) {
        String sampleSourcePath = ".../waxmonster/instance/config/media.crates";
        String sampleTargetFolder = ".../_Serato_/Subcrates";
        out.println("Syntax: java " + this.getClass().getName() + " [source-crates-file] [serato-subcrates-folder]");
        out.println("Sample: java " + this.getClass().getName() + " \"" + sampleSourcePath + "\" \"" + sampleTargetFolder + "\"");
        try {
            out.println("Enumerating serato folders...");
            File[] seratoFolders = SeratoUtil.enumerateSeratoFolders();
            int num = seratoFolders.length;
            out.println("Found " + num + " serato folders:");
            out.println("-----------------------------");
            if (num > 0) {
                File seratoFolder;
                int i;
                for (i = 0; i < num; ++i) {
                    seratoFolder = seratoFolders[i];
                    out.println("Serato folder: " + seratoFolder);
                }
                out.println("-----------------------------");
                for (i = 0; i < num; ++i) {
                    seratoFolder = seratoFolders[i];
                    File subCratesFolder = new File(seratoFolder, "Subcrates");
                    if (!subCratesFolder.exists() || !subCratesFolder.isDirectory()) continue;
                    out.println("Subcrates folder: " + subCratesFolder);
                }
            } else {
                out.println("No serato folders found!");
            }
            out.println("-----------------------------");
        }
        catch (Throwable e) {
            this.error(e);
        }
    }
}

