/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.library.serato;

import com.spacekiller.util.media.DefaultMediaMarker;
import com.spacekiller.util.media.MediaMarker;
import com.spacekiller.util.media.MutableMediaEntry;
import com.spacekiller.util.media.library.serato.Base64Decoder;
import java.io.IOException;
import java.util.LinkedList;

public class SeratoMarkers2 {
    public static final String SERATO_MARKERS_2 = "Serato Markers2";

    public static void main(String[] args) {
        try {
            String testString = "AQFDT0xPUgAAAAAEAP///0NVRQAAAAANAAAAAAAAAMwAAAAAAENVRQAAAAANAAEAAAFKAMyIAAAAAENVRQAAAAANAAIAACcjAAAAzAAAAENVRQAAAAANAAMAAE5IAMzMAAAAAENVRQAAAAANAAQABJPuAADMAAAAAENVRQAAAAARAAUAAAFKAMwAzAAAVGVzdABCUE1MT0NLAAAAAAEAA";
            byte[] base64Input = testString.getBytes();
            MediaMarker[] markers = SeratoMarkers2.parseSeratoMarkers(base64Input);
            int num = markers == null ? 0 : markers.length;
            System.out.println("Number of markers: " + num);
            for (int i = 0; i < num; ++i) {
                MediaMarker marker = markers[i];
                System.out.println("Marker: index=" + marker.getIndex() + ", position=" + marker.getPosition() + ", name=" + marker.getName());
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    public static MediaMarker[] parseSeratoMarkers(byte[] base64Input) throws IOException {
        byte[] data = Base64Decoder.decodeBase64(base64Input, 0, base64Input.length);
        LinkedList<MediaMarker> markers = null;
        int len = data.length;
        int max = len - 3;
        for (int i = 0; i < max; ++i) {
            MediaMarker marker;
            if (data[i] != 67 || data[i + 1] != 85 || data[i + 2] != 69 || (marker = SeratoMarkers2.parseSeratoMarker(data, i, len - i)) == null) continue;
            if (markers == null) {
                markers = new LinkedList<MediaMarker>();
            }
            markers.add(marker);
        }
        if (markers == null) {
            return null;
        }
        return markers.toArray(new MediaMarker[markers.size()]);
    }

    public static MediaMarker parseSeratoMarker(byte[] arr, int off, int len) {
        int markerLen;
        int markerEnd;
        int end = off + len;
        off += 3;
        if ((off += 4) >= end) {
            return null;
        }
        if ((markerEnd = off + (markerLen = arr[off++] & 0xFF)) > end) {
            return null;
        }
        if (markerLen < 13) {
            return null;
        }
        int n = ++off;
        int markerIndex = arr[n] & 0xFF;
        int n2 = ++off;
        long markerMillis = (arr[n2] & 0xFF) << 24;
        int n3 = ++off;
        markerMillis += (long)((arr[n3] & 0xFF) << 16);
        int n4 = ++off;
        markerMillis += (long)((arr[n4] & 0xFF) << 8);
        int n5 = ++off;
        ++off;
        double markerPosition = markerMillis += (long)(arr[n5] & 0xFF);
        ++off;
        off += 3;
        String markerName = null;
        if (arr[markerEnd - 1] == 0 && markerEnd > (off += 2) + 1) {
            markerName = new String(arr, off, markerEnd - off - 1);
        }
        int markerType = 9;
        return new DefaultMediaMarker(markerType, markerIndex, markerPosition, markerName);
    }

    public static void updateMediaEntrySeratoMarkers(MutableMediaEntry targetEntry, MediaMarker[] seratoMarkers) {
        if (targetEntry == null) {
            return;
        }
        MediaMarker[] oldMarkers = targetEntry.getMarkers();
        LinkedList<MediaMarker> newMarkers = new LinkedList<MediaMarker>();
        if (oldMarkers != null) {
            for (MediaMarker marker : oldMarkers) {
                if (marker == null || marker.getType() == 9) continue;
                newMarkers.add(marker);
            }
        }
        if (seratoMarkers != null) {
            for (MediaMarker marker : seratoMarkers) {
                if (marker == null) continue;
                newMarkers.add(marker);
            }
        }
        targetEntry.setMarkers(newMarkers.toArray(new MediaMarker[newMarkers.size()]));
    }
}

