/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.library.serato;

import com.spacekiller.util.FileResource;
import com.spacekiller.util.Resource;
import com.spacekiller.util.media.AbstractMediaCrate;
import com.spacekiller.util.media.DefaultMediaCrate;
import com.spacekiller.util.media.DefaultMediaCrateEntry;
import com.spacekiller.util.media.MediaCrate;
import com.spacekiller.util.media.MediaCrateEntry;
import com.spacekiller.util.media.library.serato.SeratoCrateConst;
import com.spacekiller.util.media.library.serato.SeratoCrateFile;
import java.io.File;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SeratoMediaCrate
extends DefaultMediaCrate
implements SeratoCrateConst {
    private static final Logger logger = Logger.getLogger(SeratoMediaCrate.class.getName());
    private String path;
    private transient boolean corrupted;
    private transient Thread crateInitThread;
    private transient Thread entryInitThread;

    public SeratoMediaCrate(String id, File crateFile) {
        this(id, SeratoMediaCrate.parseCrateNamePrefix(crateFile), crateFile.getPath());
    }

    public SeratoMediaCrate(String id, String name, String crateFilePath) {
        super(id, name);
        this.path = crateFilePath;
        this.crates = null;
        this.entries = null;
    }

    protected void setId(String id) {
        super.setId(id);
    }

    public String getPath() {
        return this.path;
    }

    protected void setPath(String path) {
        this.path = path;
    }

    public void getEntries(Collection dst) {
        this.lazyInitEntries(dst);
    }

    public int getEntryCount() {
        this.lazyInitEntries(null);
        return super.getEntryCount();
    }

    public MediaCrateEntry getEntryAt(int index) {
        this.lazyInitEntries(null);
        return super.getEntryAt(index);
    }

    public int getEntryIndex(MediaCrateEntry entry) {
        this.lazyInitEntries(null);
        return super.getEntryIndex(entry);
    }

    public void addEntry(MediaCrateEntry entry) {
        this.lazyInitEntries(null);
        super.addEntry(entry);
    }

    public void insertEntryAt(MediaCrateEntry entry, int index) {
        this.lazyInitEntries(null);
        super.insertEntryAt(entry, index);
    }

    public MediaCrateEntry removeEntryAt(int index) {
        this.lazyInitEntries(null);
        return super.removeEntryAt(index);
    }

    public int removeEntry(MediaCrateEntry entry) {
        this.lazyInitEntries(null);
        return super.removeEntry(entry);
    }

    public void getCrates(Collection dst) {
        this.lazyInitCrates(dst);
    }

    public int getCrateCount() {
        this.lazyInitCrates(null);
        return super.getCrateCount();
    }

    public MediaCrate getCrateAt(int index) {
        this.lazyInitCrates(null);
        return super.getCrateAt(index);
    }

    public int getCrateIndex(MediaCrate crate) {
        this.lazyInitCrates(null);
        return super.getCrateIndex(crate);
    }

    public void addCrate(MediaCrate crate) {
        this.checkSeratoSubCrate(crate);
        this.lazyInitCrates(null);
        super.addCrate(crate);
    }

    public void insertCrateAt(MediaCrate crate, int index) {
        this.checkSeratoSubCrate(crate);
        this.lazyInitCrates(null);
        super.insertCrateAt(crate, index);
    }

    protected void checkSeratoSubCrate(MediaCrate crate) {
        if (crate != null && crate instanceof SeratoMediaCrate) {
            return;
        }
        throw new IllegalArgumentException("Invalid serato sub crate: " + crate);
    }

    public int removeCrate(MediaCrate crate) {
        this.lazyInitCrates(null);
        return super.removeCrate(crate);
    }

    public MediaCrate removeCrateAt(int index) {
        this.lazyInitCrates(null);
        return super.removeCrateAt(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void lazyInitCrates(Collection dst) {
        if (this.crates != null) {
            if (dst != null) {
                List list = this.crates;
                synchronized (list) {
                    dst.addAll(this.crates);
                }
            }
            return;
        }
        Thread thread = Thread.currentThread();
        SeratoMediaCrate seratoMediaCrate = this;
        synchronized (seratoMediaCrate) {
            if (this.crates != null) {
                if (dst != null) {
                    List list = this.crates;
                    synchronized (list) {
                        dst.addAll(this.crates);
                    }
                }
                return;
            }
            if (thread == this.crateInitThread) {
                throw new IllegalStateException("Recursive invocation !");
            }
            while (this.crateInitThread != null) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {}
            }
            if (this.crates != null) {
                if (dst != null) {
                    List e = this.crates;
                    synchronized (e) {
                        dst.addAll(this.crates);
                    }
                }
                return;
            }
            this.crateInitThread = thread;
        }
        ArrayList<SeratoMediaCrate> listCrates = null;
        try {
            File[] files;
            listCrates = new ArrayList<SeratoMediaCrate>();
            File crateFile = new File(this.path);
            File dir = crateFile.getParentFile();
            if (dir != null && (files = dir.listFiles()) != null) {
                int num = files.length;
                String namePrefix = SeratoMediaCrate.parseCrateNamePrefix(crateFile) + "%%";
                for (int i = 0; i < num; ++i) {
                    String subCrateName;
                    String name;
                    File f = files[i];
                    if (f == null || !f.isFile() || !(name = f.getName()).startsWith(namePrefix) || !name.toLowerCase().endsWith(".crate") || (subCrateName = name.substring(namePrefix.length(), name.length() - ".crate".length())).indexOf("%%") >= 0) continue;
                    String subCrateId = this.getId() + "%%" + subCrateName;
                    listCrates.add(new SeratoMediaCrate(subCrateId, subCrateName, f.getPath()));
                }
            }
        }
        finally {
            SeratoMediaCrate seratoMediaCrate2 = this;
            synchronized (seratoMediaCrate2) {
                this.crates = listCrates;
                this.crateInitThread = null;
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void lazyInitEntries(Collection dst) {
        if (this.entries != null) {
            if (dst != null) {
                List list = this.entries;
                synchronized (list) {
                    dst.addAll(this.entries);
                }
            }
            return;
        }
        Thread thread = Thread.currentThread();
        SeratoMediaCrate seratoMediaCrate = this;
        synchronized (seratoMediaCrate) {
            if (this.entries != null) {
                if (dst != null) {
                    List list = this.entries;
                    synchronized (list) {
                        dst.addAll(this.entries);
                    }
                }
                return;
            }
            if (thread == this.entryInitThread) {
                throw new IllegalStateException("Recursive invocation !");
            }
            while (this.entryInitThread != null) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {}
            }
            if (this.entries != null) {
                if (dst != null) {
                    List e = this.entries;
                    synchronized (e) {
                        dst.addAll(this.entries);
                    }
                }
                return;
            }
            this.entryInitThread = thread;
        }
        ArrayList<DefaultMediaCrateEntry> listEntries = null;
        try {
            listEntries = new ArrayList<DefaultMediaCrateEntry>();
            File crateFile = new File(this.path);
            if (crateFile.exists() && crateFile.isFile()) {
                this.corrupted = true;
                try {
                    SeratoCrateFile seratoCrateFile = SeratoCrateFile.readFrom(crateFile);
                    String[] tracks = seratoCrateFile.getTracks();
                    int num = tracks.length;
                    File rootDir = this.getDriveRootDirectory(crateFile.getParentFile());
                    for (int i = 0; i < num; ++i) {
                        FileResource resource = new FileResource(new File(rootDir, tracks[i]));
                        DefaultMediaCrateEntry me = new DefaultMediaCrateEntry((MediaCrate)this, (Resource)resource);
                        listEntries.add(me);
                        if (dst == null) continue;
                        dst.add(me);
                    }
                    this.corrupted = false;
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
        finally {
            SeratoMediaCrate seratoMediaCrate2 = this;
            synchronized (seratoMediaCrate2) {
                this.entries = listEntries;
                this.entryInitThread = null;
                this.notifyAll();
            }
        }
    }

    public String toString() {
        return String.valueOf(this.path);
    }

    public static String parseCrateNamePrefix(File crateFile) {
        String name = crateFile.getName();
        int x = name.lastIndexOf(46);
        if (x >= 0) {
            name = name.substring(0, x);
        }
        return name;
    }

    protected File getDriveRootDirectory(File dir) {
        String path = dir.getAbsolutePath().replace('\\', '/');
        int x = path.indexOf(47);
        if (x >= 0) {
            path = path.substring(0, x + 1);
        }
        return new File(path).getAbsoluteFile();
    }

    public MediaCrate newCrate(String id, String name) {
        File crateFile = new File(this.path);
        File dir = crateFile.getParentFile();
        String subCrateFileName = SeratoMediaCrate.parseCrateNamePrefix(crateFile) + "%%" + name + ".crate";
        File subCrateFile = new File(dir, subCrateFileName);
        return new SeratoMediaCrate(id, name, subCrateFile.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaCrate cloneMediaCrate() throws CloneNotSupportedException {
        SeratoMediaCrate clone = (SeratoMediaCrate)this.clone();
        clone.setParent(null);
        SeratoMediaCrate seratoMediaCrate = clone;
        synchronized (seratoMediaCrate) {
            clone.crates = null;
            clone.entries = null;
        }
        return clone;
    }

    protected void setParent(AbstractMediaCrate parent) {
        super.setParent(parent);
    }

    public void setName(String name) {
        super.setName(name);
    }

    public void setDescription(String description) {
        super.setDescription(description);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveCrateRecursive() throws IOException {
        if (!this.isDirty()) {
            return;
        }
        File file = new File(this.path);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Saving serato crate file: " + this.path);
        }
        SeratoMediaCrate seratoMediaCrate = this;
        synchronized (seratoMediaCrate) {
            if (this.corrupted) {
                throw new StreamCorruptedException("Existing crate file seems to be corrupted: " + this.path);
            }
        }
        if (this.entries != null || !file.exists()) {
            if (file.exists() && file.isFile()) {
                File backupFile = new File(this.path + ".bak");
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Backup serato crate file: " + file + " -> " + backupFile);
                }
                if (backupFile.exists() && !backupFile.delete()) {
                    throw new IOException("Failed to delete old crate backup file: " + backupFile);
                }
                if (!file.renameTo(backupFile)) {
                    throw new IOException("Failed to rename old crate file: " + file + " -> " + backupFile);
                }
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Writing serato crate file: " + file);
            }
            SeratoCrateFile crateFile = new SeratoCrateFile();
            if (this.entries != null) {
                List list = this.entries;
                synchronized (list) {
                    int num = this.entries.size();
                    for (int i = 0; i < num; ++i) {
                        File track;
                        Resource resource;
                        MediaCrateEntry entry = (MediaCrateEntry)this.entries.get(i);
                        if (entry == null || (resource = entry.getResource()) == null || !resource.isFile() || (track = resource.getFile()) == null) continue;
                        crateFile.addTrack(track.getAbsolutePath());
                    }
                }
            }
            crateFile.writeTo(file);
        }
        if (this.crates != null) {
            MediaCrate[] crateArray;
            File dir = file.getParentFile();
            if (dir != null) {
                String subCrateNamePrefix = file.getName();
                if (subCrateNamePrefix.toLowerCase().endsWith(".crate")) {
                    subCrateNamePrefix = subCrateNamePrefix.substring(0, subCrateNamePrefix.length() - ".crate".length());
                }
                subCrateNamePrefix = subCrateNamePrefix + "%%";
                File[] files = dir.listFiles();
                int num = files == null ? 0 : files.length;
                for (int i = 0; i < num; ++i) {
                    File subFile = files[i];
                    String subName = subFile.getName();
                    if (!subName.startsWith(subCrateNamePrefix) || !subName.toLowerCase().endsWith(".crate")) continue;
                    File backupFile = new File(subFile.getPath() + ".bak");
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer("Backup serato crate file: " + subFile + " -> " + backupFile);
                    }
                    if (backupFile.exists() && !backupFile.delete()) {
                        throw new IOException("Failed to delete old crate backup file: " + backupFile);
                    }
                    if (subFile.renameTo(backupFile)) continue;
                    throw new IOException("Failed to rename old crate file: " + subFile + " -> " + backupFile);
                }
            }
            List files = this.crates;
            synchronized (files) {
                if (this.crates.isEmpty()) {
                    return;
                }
                crateArray = this.crates.toArray(new MediaCrate[this.crates.size()]);
            }
            for (MediaCrate crate : crateArray) {
                if (!crate.isDirty()) continue;
                if (crate instanceof SeratoMediaCrate) {
                    ((SeratoMediaCrate)crate).saveCrateRecursive();
                    continue;
                }
                logger.warning("Invalid nested serato crate: " + crate);
            }
        }
        this.setDirty(false);
    }
}

