/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.library.serato;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;

public class SeratoUtil {
    private SeratoUtil() {
    }

    public static File[] enumerateSeratoFolders() throws IOException {
        File[] roots;
        LinkedList<File> seratoFolderList = new LinkedList<File>();
        String userHome = System.getProperty("user.home");
        if (userHome != null) {
            File seratoFolder = new File(userHome + File.separator + "_Serato_");
            if (seratoFolder.exists()) {
                seratoFolderList.add(seratoFolder);
            } else {
                seratoFolder = new File(userHome + File.separator + "Music" + File.separator + "_Serato_");
                if (seratoFolder.exists()) {
                    seratoFolderList.add(seratoFolder);
                }
            }
        }
        int num = (roots = File.listRoots()) == null ? 0 : roots.length;
        for (int i = 0; i < num; ++i) {
            File root = roots[i];
            File seratoFolder = new File(root, "_Serato_");
            if (!seratoFolder.exists()) continue;
            seratoFolderList.add(seratoFolder);
        }
        return seratoFolderList.toArray(new File[seratoFolderList.size()]);
    }

    public static File[] enumerateSeratoCrateFiles(File[] seratoFolders) throws IOException {
        LinkedList<File> crateFiles = new LinkedList<File>();
        for (File seratoFolder : seratoFolders) {
            File subCratesFolder;
            if (seratoFolder == null || !(subCratesFolder = new File(seratoFolder, "Subcrates")).exists() || !subCratesFolder.isDirectory()) continue;
            File[] files = subCratesFolder.listFiles();
            int num = files == null ? 0 : files.length;
            for (int i = 0; i < num; ++i) {
                File file = files[i];
                String name = file.getName();
                if (!name.toLowerCase().endsWith(".crate")) continue;
                crateFiles.add(file);
            }
        }
        return crateFiles.toArray(new File[crateFiles.size()]);
    }

    public static File[] enumerateSeratoRootCrateFiles(File[] seratoFolders) throws IOException {
        String name;
        File file;
        File[] seratoCrateFiles = SeratoUtil.enumerateSeratoCrateFiles(seratoFolders);
        int numFiles = seratoCrateFiles.length;
        HashSet<String> names = new HashSet<String>();
        for (int i = 0; i < numFiles; ++i) {
            file = seratoCrateFiles[i];
            name = file.getName();
            names.add(name);
        }
        Iterator i = names.iterator();
        block1: while (i.hasNext()) {
            int x;
            name = (String)i.next();
            while ((x = name.lastIndexOf("%%")) >= 0) {
                if (!names.contains(name = name.substring(0, x) + ".crate")) continue;
                i.remove();
                continue block1;
            }
        }
        LinkedList<File> rootCrateFiles = new LinkedList<File>();
        for (int i2 = 0; i2 < numFiles; ++i2) {
            file = seratoCrateFiles[i2];
            name = file.getName();
            if (!names.contains(name)) continue;
            rootCrateFiles.add(file);
        }
        return rootCrateFiles.toArray(new File[rootCrateFiles.size()]);
    }
}

