/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.timecode;

import com.spacekiller.util.Platform;
import com.waxmonster.timecode.TimecodeFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TimecodeManager {
    private static final Logger logger = Logger.getLogger(TimecodeManager.class.getName());
    private static TimecodeManager INSTANCE;
    private List timecodeFormats = new ArrayList();
    private final Comparator timecodeFormatComparator = new TimecodeFormatComparator();

    protected TimecodeManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TimecodeManager getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<TimecodeManager> clazz = TimecodeManager.class;
        synchronized (TimecodeManager.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new TimecodeManager();
            INSTANCE.loadServices();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    protected void loadServices() {
        try {
            Iterator timecodeFormatIter = Platform.getInstance().getServices(TimecodeFormat.class);
            while (timecodeFormatIter.hasNext()) {
                try {
                    Object obj = timecodeFormatIter.next();
                    if (obj == null || !(obj instanceof TimecodeFormat)) continue;
                    TimecodeFormat timecodeFormat = (TimecodeFormat)obj;
                    this.registerTimecodeFormat(timecodeFormat);
                    if (!logger.isLoggable(Level.FINE)) continue;
                    logger.fine("TimecodeFormat: " + timecodeFormat);
                }
                catch (Throwable e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected synchronized void registerTimecodeFormat(TimecodeFormat format) {
        if (format == null) {
            return;
        }
        int index = -1;
        int num = this.timecodeFormats.size();
        for (int i = 0; i < num; ++i) {
            if (this.timecodeFormatComparator.compare(format, (TimecodeFormat)this.timecodeFormats.get(i)) >= 0) continue;
            index = i;
            break;
        }
        if (index < 0) {
            index = num;
        }
        this.timecodeFormats.add(index, format);
    }

    protected synchronized void unregisterTimecodeFormat(TimecodeFormat format) {
        this.timecodeFormats.remove(format);
    }

    public synchronized TimecodeFormat[] getTimecodeFormats() {
        return this.timecodeFormats.toArray(new TimecodeFormat[this.timecodeFormats.size()]);
    }

    protected class TimecodeFormatComparator
    implements Comparator {
        protected TimecodeFormatComparator() {
        }

        public int compare(Object o1, Object o2) {
            double p2;
            if (o1 == null) {
                return o2 == null ? 0 : -1;
            }
            if (o2 == null) {
                return 1;
            }
            TimecodeFormat t1 = (TimecodeFormat)o1;
            TimecodeFormat t2 = (TimecodeFormat)o2;
            double p1 = t1.getPriority();
            if (p1 > (p2 = t2.getPriority())) {
                return -1;
            }
            if (p1 < p2) {
                return 1;
            }
            String n1 = t1.getName();
            String n2 = t2.getName();
            if (n1 == null && n2 != null) {
                return -1;
            }
            if (n2 == null && n1 != null) {
                return 1;
            }
            return 0;
        }
    }
}

