/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.timecode.rane12;

import com.waxmonster.timecode.AbstractTimecodeFormat;
import com.waxmonster.timecode.TimecodeDecoder;
import com.waxmonster.timecode.common.TimecodeShader;
import com.waxmonster.timecode.impl.TimecodeShaderSupport;
import com.waxmonster.timecode.rane12.Rane12MidiTimecodeDecoderV02;

public abstract class AbstractRane12MidiTimecodeFormat
extends AbstractTimecodeFormat {
    public static final double TWELVE_MIDI_TICK_MILLIS = 0.5;
    public static final int TWELVE_POSITION_CONTROL = 6;
    public static final int RANE12_DECK1 = 1;
    public static final int RANE12_DECK2 = 2;
    public static final int RANE12_DECK3 = 3;
    public static final int RANE12_DECK4 = 4;
    public static final int RANE12_DECK1_MIDI_CHANNEL = 0;
    public static final int RANE12_DECK2_MIDI_CHANNEL = 1;
    public static final int RANE12_DECK3_MIDI_CHANNEL = 2;
    public static final int RANE12_DECK4_MIDI_CHANNEL = 3;
    protected static final String NAME_PREFIX = "RaneTwelve";
    protected static final String TITLE_PREFIX = "Rane Twelve";
    private int twelveDeck;

    public AbstractRane12MidiTimecodeFormat(int twelveDeck) {
        this.twelveDeck = twelveDeck;
        this.setName("RaneTwelveDeck" + twelveDeck);
        this.setTitle("Rane Twelve (Deck " + twelveDeck + ")");
    }

    public int getTwelveDeck() {
        return this.twelveDeck;
    }

    protected void setTwelveDeck(int twelveDeck) {
        this.twelveDeck = twelveDeck;
    }

    public boolean isScratchModeSupported(int scratchMode) {
        return Rane12MidiTimecodeDecoderV02.isRane12ScratchModeSupported(scratchMode);
    }

    public boolean isAudioDecoderSupported() {
        return false;
    }

    public boolean isMidiDecoderSupported() {
        return true;
    }

    public TimecodeDecoder createDecoder(float inputRate, int inputBufFrames, float outputRate, int outputBufFrames, double[] outputBuffer) throws IllegalArgumentException {
        int eventQueueSize = outputBufFrames * 2;
        TimecodeShader shader = TimecodeShaderSupport.getInstance().createTimecodeShader();
        shader.setEventQueueSize(eventQueueSize);
        shader.setSampleRate((double)outputRate);
        double millisPerTick = 0.5;
        double minTimePerTick = millisPerTick * 1000000.0 / 5.0;
        int midiChannel = this.getMidiChannelForRane12Deck(this.twelveDeck);
        int controlKeyPosition = 6;
        Rane12MidiTimecodeDecoderV02 decoder = new Rane12MidiTimecodeDecoderV02(this, shader, outputRate, outputBuffer, millisPerTick, minTimePerTick, midiChannel, controlKeyPosition);
        return decoder;
    }

    protected int getMidiChannelForRane12Deck(int twelveDeck) {
        switch (twelveDeck) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 3;
            }
        }
        return -1;
    }
}

