/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.timecode.rane12;

import com.spacekiller.util.midi.MidiConst;
import com.spacekiller.util.sound.SampleBuffer;
import com.waxmonster.timecode.AbstractTimecodeFormat;
import com.waxmonster.timecode.TimecodeFormat;
import com.waxmonster.timecode.common.TimecodeShader;
import com.waxmonster.timecode.impl.BaseTimecodeDecoder;
import com.waxmonster.timecode.impl.TimecodeShaderBase;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Rane12MidiTimecodeDecoderV02
extends BaseTimecodeDecoder
implements MidiConst {
    private static final Logger logger = Logger.getLogger(Rane12MidiTimecodeDecoderV02.class.getName());
    protected int mode = -1;
    protected InternalShader internalShader;
    protected TimecodeShader vinylShader;
    private AbstractTimecodeFormat format;
    private int midiChannel;
    private int controlKeyPosition;
    private volatile long prevTime;
    private volatile int prevTicks = -1;
    private long ticker = 0L;
    private double millisPerTick;
    private double minTimePerTick;

    protected Rane12MidiTimecodeDecoderV02(AbstractTimecodeFormat format, TimecodeShader shader, float outputRate, double[] outputBuffer, double millisPerTick, double minTimePerTick, int midiChannel, int controlKeyPosition) {
        super((double)outputRate, outputBuffer);
        this.format = format;
        this.setMidiChannel(midiChannel);
        this.setControlKeyPosition(controlKeyPosition);
        this.setMillisPerTick(millisPerTick);
        this.setMinTimePerTick(minTimePerTick);
        this.vinylShader = shader;
        this.prepareShader(this.vinylShader);
        this.internalShader = new InternalShader();
        this.prepareShader((TimecodeShader)this.internalShader);
        this.internalShader.setVelocity(this.normVel);
        this.setShader(shader);
        this.mode = -1;
        this.setMode(1);
    }

    public String toString() {
        return super.toString() + "[format=" + this.format + "]";
    }

    public TimecodeFormat getFormat() {
        return this.format;
    }

    protected static boolean isRane12ScratchModeSupported(int mode) {
        switch (mode) {
            case 0: {
                return true;
            }
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
            case 3: {
                return true;
            }
            case 4: {
                return false;
            }
        }
        return false;
    }

    public boolean isAudioDecoder() {
        return false;
    }

    public boolean isMidiDecoder() {
        return true;
    }

    public boolean isModeSupported(int mode) {
        return Rane12MidiTimecodeDecoderV02.isRane12ScratchModeSupported(mode);
    }

    public int getMode() {
        return this.mode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMode(int mode) {
        if (!this.isModeSupported(mode)) {
            return;
        }
        Rane12MidiTimecodeDecoderV02 rane12MidiTimecodeDecoderV02 = this;
        synchronized (rane12MidiTimecodeDecoderV02) {
            TimecodeShader oldShader;
            Object newShader;
            if (this.mode == mode) {
                return;
            }
            this.mode = mode;
            switch (mode) {
                case 1: 
                case 3: {
                    newShader = this.vinylShader;
                    oldShader = this.shader;
                    if (oldShader == newShader || oldShader == null) break;
                    this.ticker = (long)(oldShader.getPosition() / this.millisPerTick);
                    this.prevTicks = -1;
                    break;
                }
                default: {
                    newShader = this.internalShader;
                }
            }
            if (newShader != (oldShader = this.shader) && oldShader != null) {
                double oldPos = oldShader.getPosition();
                double oldVel = oldShader.getVelocity();
                newShader.setPosition(oldPos);
                newShader.setVelocity(oldVel);
            }
            if (newShader == this.internalShader) {
                this.checkInternalVelocity((TimecodeShader)newShader);
            }
            this.setShader((TimecodeShader)newShader);
        }
    }

    public void decode(long time, SampleBuffer buf, int off, int len) {
    }

    public void decode(long time, double[] buf, int off, int len) {
    }

    public void handle(long time, int status, int data1, int data2) {
        switch (status & 0xF0) {
            case 176: {
                if (data1 == this.controlKeyPosition && (this.midiChannel == (status & 0xF) || this.midiChannel == -1)) {
                    if (this.prevTicks < 0) {
                        this.prevTicks = data2;
                        this.prevTime = time;
                        return;
                    }
                    int delta = data2 - this.prevTicks;
                    if (delta > 0) {
                        if (delta > 63) {
                            delta -= 128;
                        }
                    } else if (delta < 0) {
                        if (delta < -63) {
                            delta += 128;
                        }
                    } else {
                        return;
                    }
                    this.ticker += (long)delta;
                    double tpt = (time - this.prevTime) / (long)Math.abs(delta);
                    if (tpt < this.minTimePerTick) {
                        if (logger.isLoggable(Level.FINER)) {
                            logger.finer("DEBUG delta time is too short: " + tpt + " < " + this.minTimePerTick);
                        }
                    } else {
                        this.shader.move(time, (double)this.ticker * this.millisPerTick);
                    }
                    this.prevTicks = data2;
                    this.prevTime = time;
                    return;
                }
                return;
            }
            case 144: {
                return;
            }
            case 128: {
                return;
            }
            case 224: {
                return;
            }
        }
    }

    public void close() {
        this.prevTicks = -1;
    }

    public int getMidiChannel() {
        return this.midiChannel;
    }

    protected void setMidiChannel(int midiChannel) {
        this.midiChannel = midiChannel;
    }

    public int getControlKeyPosition() {
        return this.controlKeyPosition;
    }

    protected void setControlKeyPosition(int controlKeyRelativePosition) {
        this.prevTicks = -1;
        this.controlKeyPosition = controlKeyRelativePosition;
        this.prevTicks = -1;
    }

    public double getMillisPerTick() {
        return this.millisPerTick;
    }

    protected void setMillisPerTick(double millisPerTick) {
        this.millisPerTick = millisPerTick;
    }

    public double getMinTimePerTick() {
        return this.minTimePerTick;
    }

    protected void setMinTimePerTick(double minTimePerTick) {
        this.minTimePerTick = minTimePerTick;
    }

    public long getTicker() {
        return this.ticker;
    }

    protected void setTicker(long ticker) {
        this.ticker = ticker;
    }

    protected class InternalShader
    extends TimecodeShaderBase {
        protected double pos;
        protected double vel;

        public void produce(long time, int frames) {
            for (int i = 0; i < frames; ++i) {
                this.buf[i] = this.pos;
                this.pos += this.vel;
            }
        }

        public double getPosition() {
            return this.pos;
        }

        public void setPosition(double pos) {
            this.pos = pos;
        }

        public double getVelocity() {
            return this.vel;
        }

        public void setVelocity(double vel) {
            this.vel = vel;
        }
    }
}

