/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.timecode.rane12.debug;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.StringTokenizer;

public class DeviceMonitoringStudioLogAnalyzer {
    private static final String KEYWORD_PRINT_INSTR = "$print instruction";
    private static final String KEYWORD_DIRECTION = "Direction";
    private static final String KEYWORD_UP = "\"Up\"";
    private static final String KEYWORD_DOWN = "\"Down\"";
    private static final String KEYWORD_USB_PAYLOAD = "UsbPayload";
    private static final String KEYWORD_PAYLOAD = "Payload";
    private static final String KEYWORD_UNSIGNED_CHAR = "unsigned char[";
    private static final String PAYLOAD_HEX_PREFIX = "00000000 ";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            String path = "C:\\Users\\bene\\Desktop\\Rane12_Files\\DMS Export Files\\twelve_test_20200209\\twelve009_serato_set_remove_cue_points_ch2.txt";
            if (args.length > 0) {
                path = args[0];
            }
            Charset charset = Charset.forName("UTF-16LE");
            System.out.println("Analyzing file: " + path);
            EventInfo[] infos = null;
            File file = new File(path);
            FileInputStream in = new FileInputStream(file);
            try {
                infos = new DeviceMonitoringStudioLogAnalyzer().analyzeLogFile(in, charset);
            }
            finally {
                in.close();
            }
            System.out.println("EventInfo(s): " + infos);
            System.out.println("Done.");
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    public EventInfo[] analyzeLogFile(InputStream in, Charset charset) throws IOException {
        String s;
        BufferedReader reader = new BufferedReader(new InputStreamReader(in, charset));
        String eventId = null;
        String payloadHexString = null;
        int payloadLength = -1;
        boolean usbPayload = false;
        boolean directionUp = false;
        boolean directionDown = false;
        LinkedList<EventInfo> eventList = new LinkedList<EventInfo>();
        while ((s = reader.readLine()) != null) {
            String sLen;
            int pos;
            if ((s = s.trim()).startsWith(PAYLOAD_HEX_PREFIX)) {
                String sPayload = s.substring(PAYLOAD_HEX_PREFIX.length()).trim();
                int pos2 = sPayload.indexOf("  ");
                if (pos2 <= 0) continue;
                payloadHexString = sPayload.substring(0, pos2).trim();
                continue;
            }
            int x = s.indexOf(9);
            if (x < 0) continue;
            String newEventId = s.substring(0, x).trim();
            if (!newEventId.equals(eventId)) {
                if (eventId != null) {
                    EventInfo info = new EventInfo();
                    info.setEventId(eventId);
                    info.setDirectionUp(directionUp);
                    info.setDirectionDown(directionDown);
                    info.setPayloadLength(payloadLength);
                    info.setPayloadHexString(payloadHexString);
                    eventList.add(info);
                    if (usbPayload && directionDown && payloadLength >= 0) {
                        String infoString = this.formatEventInfo(info);
                        System.out.println("DEBUG: " + infoString);
                    }
                }
                eventId = newEventId;
                payloadHexString = null;
                payloadLength = -1;
                usbPayload = false;
                directionUp = false;
                directionDown = false;
            }
            if (s.indexOf(KEYWORD_PRINT_INSTR) >= 0 && s.indexOf(KEYWORD_DIRECTION) >= 0) {
                if (s.indexOf(KEYWORD_UP) >= 0) {
                    directionUp = true;
                    continue;
                }
                if (s.indexOf(KEYWORD_DOWN) >= 0) {
                    directionDown = true;
                    continue;
                }
            }
            if (s.indexOf(KEYWORD_USB_PAYLOAD) >= 0) {
                usbPayload = true;
            }
            if (!usbPayload || s.indexOf(KEYWORD_PAYLOAD) < 0 || (pos = s.indexOf(KEYWORD_UNSIGNED_CHAR)) < 0 || (pos = (sLen = s.substring(pos + KEYWORD_UNSIGNED_CHAR.length())).indexOf(93)) <= 0) continue;
            sLen = sLen.substring(0, pos).trim();
            try {
                payloadLength = Integer.parseInt(sLen);
            }
            catch (NumberFormatException e) {}
        }
        return eventList.toArray(new EventInfo[eventList.size()]);
    }

    public byte[] parseHexString(String str) throws IOException {
        if (str == null) {
            return null;
        }
        byte[] buf = new byte[4];
        int num = 0;
        StringTokenizer tok = new StringTokenizer(str, " ", false);
        while (tok.hasMoreTokens()) {
            String s = tok.nextToken();
            if (s == null || (s = s.trim()).length() <= 0) continue;
            try {
                Integer value = Integer.decode("0x" + s);
                if (value == null) continue;
                if (num >= buf.length) {
                    byte[] arr = new byte[num * 2];
                    System.arraycopy(buf, 0, arr, 0, num);
                    buf = arr;
                }
                buf[num++] = (byte)value.intValue();
            }
            catch (NumberFormatException e) {
                // empty catch block
                break;
            }
        }
        if (num < 1) {
            return null;
        }
        byte[] arr = new byte[num];
        System.arraycopy(buf, 0, arr, 0, num);
        return arr;
    }

    public String byteString(byte[] arr) {
        if (arr == null) {
            return null;
        }
        int num = arr.length;
        if (num < 1) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < num; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(Integer.toString(arr[i] & 0xFF));
        }
        return sb.toString();
    }

    public String formatEventInfo(EventInfo info) throws IOException {
        String eventId = info.getEventId();
        int payloadLength = info.getPayloadLength();
        String payloadHexString = info.getPayloadHexString();
        boolean dirDown = info.isDirectionDown();
        boolean dirUp = info.isDirectionUp();
        StringBuffer sb = new StringBuffer();
        sb.append("Event: #" + eventId + ", dir=");
        if (dirDown) {
            sb.append("<DOWN>");
        } else if (dirUp) {
            sb.append("<UP>");
        } else {
            sb.append("<?DIR?>");
        }
        sb.append(", payload=" + payloadLength);
        sb.append(", hex=[" + payloadHexString + "]");
        byte[] bytes = this.parseHexString(payloadHexString);
        if (bytes != null && bytes.length == 4) {
            sb.append(", midi=[");
            int usbMidiCode = bytes[0] & 0xFF;
            int status = bytes[1] & 0xFF;
            int data1 = bytes[2] & 0xFF;
            int data2 = bytes[3] & 0xFF;
            sb.append(this.formatUsbMidiCode(usbMidiCode));
            sb.append(", " + this.formatMidiStatus(status));
            sb.append(", " + data1);
            sb.append(", " + data2);
            sb.append("]");
        }
        String byteString = this.byteString(bytes);
        sb.append(", bytes=[" + byteString + "]");
        return sb.toString();
    }

    protected String formatUsbMidiCode(int usbMidiCode) {
        switch (usbMidiCode) {
            case 9: {
                return "NOTE_ON";
            }
            case 11: {
                return "CONTROL";
            }
        }
        return "" + usbMidiCode;
    }

    protected String formatMidiStatus(int status) {
        int channel = status & 0xF;
        int command = status & 0xF0;
        switch (command) {
            case 144: {
                return "NOTE_ON ch=" + channel;
            }
            case 128: {
                return "NOTE_OFF ch=" + channel;
            }
            case 160: {
                return "POLY_PRES ch=" + channel;
            }
            case 176: {
                return "CONTROL ch=" + channel;
            }
            case 192: {
                return "PROGRAM ch=" + channel;
            }
            case 208: {
                return "CHANNEL_PRES ch=" + channel;
            }
            case 224: {
                return "PITCH_BEND ch=" + channel;
            }
        }
        switch (status) {
            case 254: {
                return "ACTIVE_SENSING";
            }
            case 255: {
                return "SYSTEM_RESET";
            }
        }
        return "status=" + status;
    }

    protected static class EventInfo {
        private String eventId = null;
        private String payloadHexString = null;
        private int payloadLength = -1;
        private boolean directionUp = false;
        private boolean directionDown = false;

        protected EventInfo() {
        }

        public String getEventId() {
            return this.eventId;
        }

        public void setEventId(String eventId) {
            this.eventId = eventId;
        }

        public String getPayloadHexString() {
            return this.payloadHexString;
        }

        public void setPayloadHexString(String payloadHexString) {
            this.payloadHexString = payloadHexString;
        }

        public int getPayloadLength() {
            return this.payloadLength;
        }

        public void setPayloadLength(int payloadLength) {
            this.payloadLength = payloadLength;
        }

        public boolean isDirectionUp() {
            return this.directionUp;
        }

        public void setDirectionUp(boolean directionUp) {
            this.directionUp = directionUp;
        }

        public boolean isDirectionDown() {
            return this.directionDown;
        }

        public void setDirectionDown(boolean directionDown) {
            this.directionDown = directionDown;
        }
    }
}

