/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.process.plugin;

import com.spacekiller.util.process.ProcessManager;
import com.spacekiller.util.process.ProcessTableViewer;
import com.spacekiller.util.process.plugin.ProcessPlugin;
import com.spacekiller.util.workbench.View;
import java.awt.Component;
import java.awt.Dimension;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ProcessView
extends View {
    private ProcessTableViewer processTableViewer;
    private static final Logger logger = Logger.getLogger(ProcessView.class.getName());

    protected Component createComponent() {
        return this.getProcessTableViewer();
    }

    protected void installChildComponent(View child, Component childComponent) {
    }

    protected void uninstallChildComponent(View child, Component childComponent) {
    }

    protected void finalize() throws Throwable {
        if (this.processTableViewer != null) {
            logger.fine("Dispose: " + this.processTableViewer);
            this.processTableViewer.dispose();
            this.processTableViewer = null;
        }
        super.finalize();
    }

    protected ProcessTableViewer createProcessTableViewer() {
        ProcessTableViewer viewer = new ProcessTableViewer();
        ProcessManager manager = null;
        try {
            manager = ProcessPlugin.getInstance().getProcessManager();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        viewer.setProcessManager(manager);
        viewer.setPreferredSize(new Dimension(540, 250));
        return viewer;
    }

    public synchronized ProcessTableViewer getProcessTableViewer() {
        if (this.processTableViewer == null) {
            this.setProcessTableViewer(this.createProcessTableViewer());
        }
        return this.processTableViewer;
    }

    protected void setProcessTableViewer(ProcessTableViewer executionTableViewer) {
        this.processTableViewer = executionTableViewer;
    }

    protected void parentChanged(View oldParent, View newParent) {
        super.parentChanged(oldParent, newParent);
        if (newParent == null && this.processTableViewer != null) {
            this.processTableViewer.dispose();
        }
    }
}

