/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.ogg;

import com.spacekiller.util.Tools;
import com.spacekiller.util.sound.AudioFileReaderWrapper;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.sound.sampled.spi.AudioFileReader;

public class OggAudioFileReader
extends AudioFileReaderWrapper {
    private static final String READER_CLASS = "javazoom.spi.vorbis.sampled.file.VorbisAudioFileReader";
    private static final Logger logger = Logger.getLogger(OggAudioFileReader.class.getName());
    private static final byte[] OGGS_HEADER = new byte[]{79, 103, 103, 83};
    private static final int OGGS_HEADER_LEN = OGGS_HEADER.length;

    public OggAudioFileReader() {
        try {
            Class<?> clazz = Class.forName(READER_CLASS);
            AudioFileReader r = (AudioFileReader)Tools.newInstance(clazz);
            this.setReader(r);
        }
        catch (Throwable e) {
            logger.log(Level.WARNING, e.getMessage(), e);
        }
    }

    public AudioFileFormat getAudioFileFormat(InputStream stream) throws UnsupportedAudioFileException, IOException {
        this.checkHeader(stream);
        return super.getAudioFileFormat(stream);
    }

    public AudioFileFormat getAudioFileFormat(URL url) throws UnsupportedAudioFileException, IOException {
        this.checkHeader(url);
        return super.getAudioFileFormat(url);
    }

    public AudioFileFormat getAudioFileFormat(File file) throws UnsupportedAudioFileException, IOException {
        this.checkHeader(file);
        return super.getAudioFileFormat(file);
    }

    public AudioInputStream getAudioInputStream(InputStream stream) throws UnsupportedAudioFileException, IOException {
        this.checkHeader(stream);
        return super.getAudioInputStream(stream);
    }

    public AudioInputStream getAudioInputStream(URL url) throws UnsupportedAudioFileException, IOException {
        this.checkHeader(url);
        return super.getAudioInputStream(url);
    }

    public AudioInputStream getAudioInputStream(File file) throws UnsupportedAudioFileException, IOException {
        this.checkHeader(file);
        return super.getAudioInputStream(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkHeader(File file) throws UnsupportedAudioFileException, IOException {
        FileInputStream fis = new FileInputStream(file);
        try {
            this.checkHeader(fis);
        }
        finally {
            fis.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkHeader(URL url) throws UnsupportedAudioFileException, IOException {
        InputStream is = url.openStream();
        try {
            this.checkHeader(is);
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkHeader(InputStream stream) throws UnsupportedAudioFileException, IOException {
        stream.mark(OGGS_HEADER_LEN);
        try {
            byte[] b = new byte[OGGS_HEADER_LEN];
            this.readFully(stream, b, 0, OGGS_HEADER_LEN);
            for (int i = 0; i < 4; ++i) {
                if (b[i] == OGGS_HEADER[i]) continue;
                throw new UnsupportedAudioFileException("Invalid ogg file header");
            }
        }
        finally {
            stream.reset();
        }
    }

    protected void readFully(InputStream stream, byte[] b, int off, int len) throws IOException {
        while (len > 0) {
            int n = stream.read(b, off, len);
            if (n <= 0) {
                throw new EOFException();
            }
            off += n;
            len -= n;
        }
    }
}

