/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.ogg;

import com.spacekiller.util.Tools;
import com.spacekiller.util.format.AbstractFileFormat;
import com.spacekiller.util.format.FileFormat;
import com.spacekiller.util.format.FileFormatSignature;
import com.spacekiller.util.format.SimpleFileFormatSignature;
import com.spacekiller.util.media.MediaFileFormat;
import com.spacekiller.util.media.MediaScanner;

public class OggMediaFileFormat
extends AbstractFileFormat
implements MediaFileFormat {
    public static final String FORMAT_NAME = "OGG";
    private static final String DEFAULT_FILE_EXTENSION = ".ogg";
    private static final String[] SUPPORTED_FILE_EXTENSIONS = new String[]{".ogg"};
    private static final String FILE_FORMAT_TITLE = "Ogg Vorbis Audio File";
    private SimpleFileFormatSignature oggFileSignature;
    private MediaScanner mediaScanner;

    public OggMediaFileFormat() {
        super(FORMAT_NAME);
        this.initMediaFileFormat();
    }

    protected void initMediaFileFormat() {
        this.setFormatTitle(FILE_FORMAT_TITLE);
        this.setDefaultFormatIcon(Tools.getIcon(((Object)((Object)this)).getClass(), (String)"/com/spacekiller/util/media/ogg/icons/ogg_format.png"));
        this.setDefaultExtension(DEFAULT_FILE_EXTENSION);
        this.setSupportedExtensions(SUPPORTED_FILE_EXTENSIONS);
        this.oggFileSignature = new SimpleFileFormatSignature("OGG Header", (FileFormat)this, 0, new byte[]{79, 103, 103, 83});
        this.setSupportedSignatures(new FileFormatSignature[]{this.oggFileSignature});
    }

    public int getSupportedMediaFlags() {
        return 1;
    }

    public MediaScanner getMediaScanner() {
        if (this.mediaScanner == null) {
            // empty if block
        }
        return this.mediaScanner;
    }
}

