/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.net;

import com.spacekiller.util.ListenerList;
import com.spacekiller.util.net.Handshake;
import com.spacekiller.util.net.InetAddressFilter;
import com.spacekiller.util.net.Server;
import com.spacekiller.util.net.ServerConfig;
import com.spacekiller.util.net.ServerListener;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractServer
implements Server {
    private static long nextHandshakeId = 1L;
    private Logger logger;
    private String name;
    private ServerConfig serverConfig;
    private volatile int status;
    private volatile boolean shutdown;
    private SocketAddress endpoint;
    private int backlog;
    private ServerSocket serverSocket;
    private Thread serverThread;
    private int serverThreadPriority;
    private int handshakeThreadPriority;
    private Map handshakes;
    private int handshakeCount;
    private int handshakeTimeout;
    private int maxConcurrentHandshakes;
    private int maxConcurrentHandshakesPerAddress;
    private int handshakeWarningInterval;
    private long nextHandshakeWarningTime;
    private InetAddressFilter inetAddressFilter;
    private ListenerList<ServerListener> serverListeners;

    public AbstractServer(String name, ServerConfig serverConfig) {
        this(name, serverConfig, null);
    }

    public AbstractServer(String name, ServerConfig serverConfig, Logger logger) {
        if (logger == null) {
            logger = Logger.getLogger(this.getClass().getName());
        }
        this.logger = logger;
        this.name = name;
        this.status = 0;
        this.shutdown = false;
        this.handshakes = new HashMap();
        this.handshakeCount = 0;
        this.nextHandshakeWarningTime = Long.MIN_VALUE;
        this.serverListeners = new ListenerList(ServerListener.class);
        this.setServerConfig(serverConfig);
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public void addServerListener(ServerListener l) {
        if (l != null) {
            this.serverListeners.add((Object)l);
        }
    }

    @Override
    public void removeServerListener(ServerListener l) {
        if (l != null) {
            this.serverListeners.remove((Object)l);
        }
    }

    private void fireServerStarting() {
        try {
            for (ServerListener l : (ServerListener[])this.serverListeners.array()) {
                l.serverStarting(this);
            }
        }
        catch (Throwable e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    private void fireServerStarted() {
        try {
            for (ServerListener l : (ServerListener[])this.serverListeners.array()) {
                l.serverStarted(this);
            }
        }
        catch (Throwable e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    private void fireServerStopping() {
        try {
            for (ServerListener l : (ServerListener[])this.serverListeners.array()) {
                l.serverStopping(this);
            }
        }
        catch (Throwable e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    private void fireServerStopped() {
        try {
            for (ServerListener l : (ServerListener[])this.serverListeners.array()) {
                l.serverStopped(this);
            }
        }
        catch (Throwable e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    @Override
    public final synchronized void stop() throws Exception {
        int status = this.status;
        if (status == 0) {
            return;
        }
        Thread srvThread = this.serverThread;
        if (srvThread == null) {
            return;
        }
        this.shutdown = true;
        ServerSocket srv = this.serverSocket;
        if (srv != null) {
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.finer("Closing server socket: " + srv);
            }
            srv.close();
        }
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("Waiting for shutdown of server thread: " + srvThread);
        }
        srvThread.join();
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Server thread stopped: " + srvThread);
        }
    }

    @Override
    public final synchronized void start() throws IOException {
        ServerSocket srv;
        int status = this.status;
        if (status != 0) {
            throw new IllegalStateException("Server is already running.");
        }
        String serverName = this.getName();
        if (serverName == null) {
            serverName = super.toString();
        }
        if ((srv = this.createServerSocket()) == null) {
            throw new NullPointerException("Unable to create server socket using implementation " + this.getClass());
        }
        this.serverSocket = srv;
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.finer("Server socket address: " + srv.getLocalSocketAddress());
        }
        this.status = 2;
        this.fireServerStarting();
        MainLoop mainLoop = new MainLoop();
        Thread thread = new Thread((Runnable)mainLoop, serverName);
        int prio = this.serverThreadPriority;
        if (prio >= 1 && prio <= 10) {
            thread.setPriority(prio);
        }
        this.serverThread = thread;
        this.shutdown = false;
        thread.start();
    }

    protected ServerSocket createServerSocket() throws IOException {
        SocketAddress endpoint = this.endpoint;
        int backlog = this.backlog;
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.finer("Binding server socket '" + endpoint + "' to " + this);
        }
        ServerSocket srv = new ServerSocket();
        srv.bind(endpoint, backlog);
        return srv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void run() {
        try {
            this.status = 1;
            if (this.logger.isLoggable(Level.INFO)) {
                this.logger.info("Server started: " + this);
            }
            this.fireServerStarted();
            while (!this.shutdown) {
                this.accept();
            }
        }
        catch (SocketException e) {
            if (!this.shutdown) {
                this.logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        catch (Throwable e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
        }
        finally {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Stopping server: " + this);
            }
            this.status = 3;
            this.fireServerStopping();
            try {
                if (this.serverSocket != null) {
                    this.serverSocket.close();
                }
            }
            catch (Throwable e) {
                this.logger.log(Level.SEVERE, e.getMessage(), e);
            }
            if (this.logger.isLoggable(Level.INFO)) {
                this.logger.info("Server stopped: " + this);
            }
            this.status = 0;
            this.fireServerStopped();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void accept() throws Exception {
        HandshakeImpl handshake;
        LinkedList<HandshakeImpl> handshakeList;
        String hostAddress;
        Map map;
        long time;
        Socket socket;
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("Waiting for new connections...");
        }
        try {
            socket = this.serverSocket.accept();
            time = System.currentTimeMillis();
        }
        catch (SecurityException e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
            return;
        }
        catch (SocketException e) {
            if (!this.shutdown) {
                this.logger.log(Level.SEVERE, e.getMessage(), e);
            }
            return;
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
            return;
        }
        try {
            boolean finest = this.logger.isLoggable(Level.FINEST);
            if (finest) {
                this.logger.finest("Socket: " + socket);
            }
            InetAddress addr = socket.getInetAddress();
            socket.setSoTimeout(this.handshakeTimeout);
            map = this.handshakes;
            synchronized (map) {
                int numPending;
                if (this.handshakeCount >= this.maxConcurrentHandshakes) {
                    if (finest) {
                        this.logger.finest("WARNING: Reached maximum concurrent handshake requests: " + this.handshakeCount);
                    }
                    if (time >= this.nextHandshakeWarningTime) {
                        this.nextHandshakeWarningTime = time + (long)this.handshakeWarningInterval;
                        this.logger.warning("Reached maximum concurrent handshake requests: " + this.handshakeCount);
                    }
                    this.closeSocket(socket);
                    return;
                }
                hostAddress = addr.getHostAddress();
                handshakeList = (LinkedList<HandshakeImpl>)this.handshakes.get(hostAddress);
                int n = numPending = handshakeList == null ? 0 : handshakeList.size();
                if (numPending >= this.maxConcurrentHandshakesPerAddress) {
                    if (finest) {
                        this.logger.finest("WARNING: Reached maximum concurrent handshake requests for address: " + addr);
                    }
                    if (time >= this.nextHandshakeWarningTime) {
                        this.nextHandshakeWarningTime = time + (long)this.handshakeWarningInterval;
                        this.logger.warning("Reached maximum concurrent handshake requests for address: " + addr);
                    }
                    this.closeSocket(socket);
                    return;
                }
                InetAddressFilter addressFilter = this.inetAddressFilter;
                if (addressFilter != null && !addressFilter.accept(addr)) {
                    if (finest) {
                        this.logger.finest("Client network address not accepted: " + addr);
                    }
                    this.closeSocket(socket);
                    return;
                }
                if (handshakeList == null) {
                    handshakeList = new LinkedList<HandshakeImpl>();
                    this.handshakes.put(hostAddress, handshakeList);
                }
                handshake = new HandshakeImpl(socket, time, hostAddress, handshakeList);
                handshakeList.add(handshake);
                ++this.handshakeCount;
            }
        }
        catch (Throwable e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
            this.closeSocket(socket);
            return;
        }
        try {
            long handshakeId = AbstractServer.nextHandshakeId();
            String threadName = "Handshake-" + handshakeId;
            Thread thread = new Thread((Runnable)handshake, threadName);
            thread.setDaemon(true);
            int prio = this.handshakeThreadPriority;
            if (prio >= 1 && prio <= 10) {
                thread.setPriority(prio);
            }
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.finer("Starting handshake: " + thread);
            }
            thread.start();
        }
        catch (Throwable e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
            map = this.handshakes;
            synchronized (map) {
                if (handshakeList.remove(handshake)) {
                    --this.handshakeCount;
                    if (handshakeList.isEmpty()) {
                        this.handshakes.remove(hostAddress);
                    }
                }
            }
            this.closeSocket(socket);
            return;
        }
    }

    protected abstract boolean handshake(Handshake var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long nextHandshakeId() {
        Class<AbstractServer> clazz = AbstractServer.class;
        synchronized (AbstractServer.class) {
            long id = nextHandshakeId++;
            // ** MonitorExit[var2] (shouldn't be in output)
            return id;
        }
    }

    private boolean closeSocket(Socket s) {
        if (s == null) {
            return false;
        }
        try {
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.finer("Closing socket: " + s);
            }
            s.close();
            return true;
        }
        catch (Throwable e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
            return false;
        }
    }

    protected Logger getLogger() {
        return this.logger;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public SocketAddress getSocketAddress() {
        SocketAddress addr;
        ServerSocket s = this.serverSocket;
        if (s != null && (addr = s.getLocalSocketAddress()) != null) {
            return addr;
        }
        return this.endpoint;
    }

    public String toString() {
        return super.toString() + "[name='" + this.name + "', endpoint=" + this.endpoint + "]";
    }

    protected ServerConfig getServerConfig() {
        return this.serverConfig;
    }

    protected synchronized void setServerConfig(ServerConfig serverConfig) {
        int status = this.status;
        if (status != 0) {
            throw new IllegalStateException("Cannot set configuration while server is running.");
        }
        this.serverConfig = serverConfig;
        this.endpoint = serverConfig.getSocketAddress();
        this.backlog = serverConfig.getBacklog();
        this.inetAddressFilter = serverConfig.getInetAddressFilter();
        this.serverThreadPriority = serverConfig.getServerThreadPriority();
        this.setHandshakeThreadPriority(serverConfig.getHandshakeThreadPriority());
        this.setHandshakeTimeout(serverConfig.getHandshakeTimeout());
        this.setHandshakeWarningInterval(serverConfig.getHandshakeWarningInterval());
        this.setMaxConcurrentHandshakes(serverConfig.getMaxConcurrentHandshakes());
        this.setMaxConcurrentHandshakesPerAddress(serverConfig.getMaxConcurrentHandshakesPerAddress());
        this.applyServerConfig(serverConfig);
    }

    protected void applyServerConfig(ServerConfig serverConfig) {
    }

    protected int getMaxConcurrentHandshakes() {
        return this.maxConcurrentHandshakes;
    }

    protected void setMaxConcurrentHandshakes(int maxConcurrentHandshakes) {
        this.maxConcurrentHandshakes = maxConcurrentHandshakes;
    }

    protected int getMaxConcurrentHandshakesPerAddress() {
        return this.maxConcurrentHandshakesPerAddress;
    }

    protected void setMaxConcurrentHandshakesPerAddress(int maxConcurrentHandshakesPerAddress) {
        this.maxConcurrentHandshakesPerAddress = maxConcurrentHandshakesPerAddress;
    }

    protected int getHandshakeCount() {
        return this.handshakeCount;
    }

    protected int getHandshakeTimeout() {
        return this.handshakeTimeout;
    }

    protected void setHandshakeTimeout(int handshakeTimeout) {
        this.handshakeTimeout = handshakeTimeout;
    }

    protected int getHandshakeWarningInterval() {
        return this.handshakeWarningInterval;
    }

    protected synchronized void setHandshakeWarningInterval(int handshakeWarningInterval) {
        if (this.handshakeWarningInterval == handshakeWarningInterval) {
            return;
        }
        this.handshakeWarningInterval = handshakeWarningInterval;
        this.nextHandshakeWarningTime = Long.MIN_VALUE;
    }

    protected InetAddressFilter getInetAddressFilter() {
        return this.inetAddressFilter;
    }

    protected void setInetAddressFilter(InetAddressFilter inetAddressFilter) {
        this.inetAddressFilter = inetAddressFilter;
    }

    protected int getHandshakeThreadPriority() {
        return this.handshakeThreadPriority;
    }

    protected void setHandshakeThreadPriority(int handshakeThreadPriority) {
        this.handshakeThreadPriority = handshakeThreadPriority;
    }

    protected class HandshakeImpl
    implements Handshake,
    Runnable {
        private Socket socket;
        private long time;
        private String hostAddress;
        private List handshakeList;

        public HandshakeImpl(Socket socket, long time, String hostAddress, List handshakeList) {
            this.socket = socket;
            this.time = time;
            this.hostAddress = hostAddress;
            this.handshakeList = handshakeList;
        }

        @Override
        public Socket getSocket() {
            return this.socket;
        }

        @Override
        public long getTime() {
            return this.time;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean success = false;
            try {
                success = AbstractServer.this.handshake(this);
            }
            catch (Throwable e) {
                AbstractServer.this.logger.log(Level.SEVERE, e.getMessage(), e);
            }
            finally {
                if (!success) {
                    AbstractServer.this.closeSocket(this.socket);
                    this.socket = null;
                }
                if (this.handshakeList != null) {
                    Map map = AbstractServer.this.handshakes;
                    synchronized (map) {
                        if (this.handshakeList.remove(this)) {
                            AbstractServer.this.handshakeCount--;
                            if (this.handshakeList.isEmpty() && this.hostAddress != null) {
                                AbstractServer.this.handshakes.remove(this.hostAddress);
                            }
                        }
                    }
                }
            }
        }
    }

    protected class MainLoop
    implements Runnable {
        protected MainLoop() {
        }

        @Override
        public void run() {
            AbstractServer.this.run();
        }
    }
}

