/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.net;

import com.spacekiller.util.Platform;
import com.spacekiller.util.PreferencesObject;
import com.spacekiller.util.net.InetAddressFilter;
import com.spacekiller.util.net.ServerConfig;
import java.io.Serializable;
import java.net.SocketAddress;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractServerConfig
extends PreferencesObject
implements ServerConfig,
Serializable,
Cloneable {
    private static final Logger logger = Platform.getLogger(AbstractServerConfig.class);
    private static final long serialVersionUID = 37698292639786L;
    private SocketAddress socketAddress;
    private int backlog;
    private InetAddressFilter inetAddressFilter;
    private int serverThreadPriority = 0;
    private int handshakeThreadPriority = 0;
    private int handshakeTimeout = 60000;
    private int handshakeWarningInterval = 60000;
    private int maxConcurrentHandshakes = 50;
    private int maxConcurrentHandshakesPerAddress = 10;

    public AbstractServerConfig() {
        super(false);
    }

    protected void setDefaults() {
        super.setDefaults();
        try {
            this.setFieldValues((AbstractServerConfig)this.getClass().newInstance());
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected AbstractServerConfig cloneAbstractServerConfig() throws CloneNotSupportedException {
        return (AbstractServerConfig)super.clone();
    }

    @Override
    public SocketAddress getSocketAddress() {
        return this.socketAddress;
    }

    public void setSocketAddress(SocketAddress socketAddress) {
        this.socketAddress = socketAddress;
    }

    @Override
    public int getBacklog() {
        return this.backlog;
    }

    public void setBacklog(int backlog) {
        this.backlog = backlog;
    }

    @Override
    public InetAddressFilter getInetAddressFilter() {
        return this.inetAddressFilter;
    }

    public void setInetAddressFilter(InetAddressFilter inetAddressFilter) {
        this.inetAddressFilter = inetAddressFilter;
    }

    @Override
    public int getHandshakeTimeout() {
        return this.handshakeTimeout;
    }

    public void setHandshakeTimeout(int handshakeTimeout) {
        this.handshakeTimeout = handshakeTimeout;
    }

    @Override
    public int getHandshakeWarningInterval() {
        return this.handshakeWarningInterval;
    }

    public void setHandshakeWarningInterval(int handshakeWarningInterval) {
        this.handshakeWarningInterval = handshakeWarningInterval;
    }

    @Override
    public int getMaxConcurrentHandshakes() {
        return this.maxConcurrentHandshakes;
    }

    public void setMaxConcurrentHandshakes(int maxConcurrentHandshakes) {
        this.maxConcurrentHandshakes = maxConcurrentHandshakes;
    }

    @Override
    public int getMaxConcurrentHandshakesPerAddress() {
        return this.maxConcurrentHandshakesPerAddress;
    }

    public void setMaxConcurrentHandshakesPerAddress(int maxConcurrentHandshakesPerAddress) {
        this.maxConcurrentHandshakesPerAddress = maxConcurrentHandshakesPerAddress;
    }

    @Override
    public int getServerThreadPriority() {
        return this.serverThreadPriority;
    }

    public void setServerThreadPriority(int serverThreadPriority) {
        this.serverThreadPriority = serverThreadPriority;
    }

    @Override
    public int getHandshakeThreadPriority() {
        return this.handshakeThreadPriority;
    }

    public void setHandshakeThreadPriority(int handshakeThreadPriority) {
        this.handshakeThreadPriority = handshakeThreadPriority;
    }
}

