/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.net;

import com.spacekiller.util.net.InetAddressContainer;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class InetAddressList
implements InetAddressContainer,
Serializable {
    private static final long serialVersionUID = 76456577665166569L;
    private volatile Set addresses = this.createEmptySet();

    public InetAddressList() {
    }

    public InetAddressList(InetAddress[] addrs) {
        this();
        if (addrs != null) {
            for (InetAddress addr : addrs) {
                String hostAddress;
                if (addr == null || (hostAddress = addr.getHostAddress()) == null) continue;
                this.addresses.add(hostAddress);
            }
        }
    }

    private Set createEmptySet() {
        return new HashSet();
    }

    @Override
    public boolean contains(InetAddress addr) {
        if (addr == null) {
            return false;
        }
        String hostAddress = addr.getHostAddress();
        return this.contains(hostAddress);
    }

    public boolean contains(String hostAddress) {
        return this.addresses.contains(hostAddress);
    }

    public int size() {
        return this.addresses.size();
    }

    public boolean isEmpty() {
        return this.addresses.isEmpty();
    }

    public Enumeration elements() {
        return new ElementEnum();
    }

    public boolean add(InetAddress addr) {
        String hostAddress = addr.getHostAddress();
        return this.add(hostAddress);
    }

    public synchronized boolean add(String hostAddress) {
        if (this.addresses.contains(hostAddress)) {
            return false;
        }
        Set newSet = this.createEmptySet();
        newSet.addAll(this.addresses);
        newSet.add(hostAddress);
        this.addresses = newSet;
        return true;
    }

    public boolean remove(InetAddress addr) {
        String hostAddress = addr.getHostAddress();
        return this.remove(hostAddress);
    }

    public synchronized boolean remove(String hostAddress) {
        if (!this.addresses.contains(hostAddress)) {
            return false;
        }
        Set newSet = this.createEmptySet();
        newSet.addAll(this.addresses);
        newSet.remove(hostAddress);
        this.addresses = newSet;
        return true;
    }

    public synchronized void clear() {
        this.addresses = this.createEmptySet();
    }

    public String toString() {
        Set set = this.addresses;
        int num = set == null ? 0 : set.size();
        return super.toString() + "[count=" + num + "]";
    }

    protected class ElementEnum
    implements Enumeration {
        private Iterator iter;

        public ElementEnum() {
            this.iter = InetAddressList.this.addresses.iterator();
        }

        @Override
        public boolean hasMoreElements() {
            return this.iter.hasNext();
        }

        public Object nextElement() {
            return this.iter.next();
        }
    }
}

