/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.net;

import com.spacekiller.util.net.InetAddressContainer;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class InetAddressRange
implements InetAddressContainer,
Serializable {
    private static final long serialVersionUID = 7735278651694705566L;
    private byte[] pattern;
    private byte[] mask;

    public InetAddressRange(InetAddress pattern, InetAddress mask) {
        this(pattern.getAddress(), mask.getAddress());
    }

    public InetAddressRange(byte[] pattern, byte[] mask) {
        int len = pattern.length;
        if (mask.length != len) {
            throw new IllegalArgumentException("Invalid length of mask and pattern: " + mask.length + " != " + len);
        }
        byte[] theMask = new byte[len];
        System.arraycopy(mask, 0, theMask, 0, len);
        byte[] thePattern = new byte[len];
        for (int i = 0; i < len; ++i) {
            thePattern[i] = (byte)(pattern[i] & theMask[i]);
        }
        this.pattern = thePattern;
        this.mask = theMask;
    }

    @Override
    public boolean contains(InetAddress addr) {
        if (addr == null) {
            return false;
        }
        return this.containsAddress(addr.getAddress());
    }

    private boolean containsAddress(byte[] addr) {
        if (addr == null) {
            return false;
        }
        int len = addr.length;
        if (len != this.pattern.length) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if ((addr[i] & this.mask[i]) == this.pattern[i]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        String p = this.formatAddress(this.pattern);
        String m = this.formatAddress(this.mask);
        return super.toString() + "[pattern=" + p + ", mask=" + m + "]";
    }

    private String formatAddress(byte[] addr) {
        try {
            return InetAddress.getByAddress(addr).getHostAddress();
        }
        catch (UnknownHostException e) {
            return "" + addr;
        }
    }
}

