/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.net;

import java.io.Serializable;
import java.net.Socket;
import java.net.SocketException;

public class SocketConfig
implements Serializable {
    private static final long serialVersionUID = -601099145942290363L;
    private boolean keepAlive = false;
    private boolean tcpNoDelay = false;
    private int soTimeout = -1;
    private int receiveBufferSize = -1;
    private int sendBufferSize = -1;
    private int trafficClass = -1;
    private boolean reuseAddress = false;

    public SocketConfig() {
    }

    public SocketConfig(Socket socket) throws SocketException {
        this.tcpNoDelay = socket.getTcpNoDelay();
        this.soTimeout = socket.getSoTimeout();
        this.receiveBufferSize = socket.getReceiveBufferSize();
        this.sendBufferSize = socket.getSendBufferSize();
        this.keepAlive = socket.getKeepAlive();
        this.trafficClass = socket.getTrafficClass();
        this.reuseAddress = socket.getReuseAddress();
    }

    public void configureSocket(Socket socket) throws SocketException {
        socket.setTcpNoDelay(this.tcpNoDelay);
        if (this.soTimeout >= 0) {
            socket.setSoTimeout(this.soTimeout);
        }
        if (this.receiveBufferSize > 0) {
            socket.setReceiveBufferSize(this.receiveBufferSize);
        }
        if (this.sendBufferSize > 0) {
            socket.setSendBufferSize(this.sendBufferSize);
        }
        socket.setKeepAlive(this.keepAlive);
        if (this.trafficClass >= 0) {
            socket.setTrafficClass(this.trafficClass);
        }
        socket.setReuseAddress(this.reuseAddress);
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    public void setSoTimeout(int soTimeout) {
        this.soTimeout = soTimeout;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public void setReceiveBufferSize(int receiveBufferSize) {
        this.receiveBufferSize = receiveBufferSize;
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public void setSendBufferSize(int sendBufferSize) {
        this.sendBufferSize = sendBufferSize;
    }

    public int getTrafficClass() {
        return this.trafficClass;
    }

    public void setTrafficClass(int trafficClass) {
        this.trafficClass = trafficClass;
    }
}

