/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.net.filter;

import com.spacekiller.util.net.InetAddressFilter;
import java.io.Serializable;
import java.net.InetAddress;

public final class AllOfManyInetAddressFilter
implements InetAddressFilter,
Serializable {
    private static final long serialVersionUID = 4835645668412357473L;
    private InetAddressFilter[] filters;
    private int count;

    public AllOfManyInetAddressFilter(InetAddressFilter[] filters) {
        int n = filters.length;
        InetAddressFilter[] array = new InetAddressFilter[n];
        for (int i = 0; i < n; ++i) {
            InetAddressFilter f = filters[i];
            if (f == null) {
                throw new NullPointerException("Filter is null at index " + i);
            }
            array[i] = f;
        }
        this.count = n;
        this.filters = array;
    }

    @Override
    public boolean accept(InetAddress addr) {
        for (int i = 0; i < this.count; ++i) {
            if (this.filters[i].accept(addr)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(super.toString());
        sbuf.append('[');
        for (int i = 0; i < this.count; ++i) {
            if (i > 0) {
                sbuf.append(", ");
            }
            sbuf.append(String.valueOf(this.filters[i]));
        }
        sbuf.append(']');
        return sbuf.toString();
    }
}

