/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.workspace;

import com.spacekiller.util.workspace.DefaultProject;
import com.spacekiller.util.workspace.DefaultProjectPersistence;
import com.spacekiller.util.workspace.Project;
import com.spacekiller.util.workspace.ProjectPersistence;
import com.spacekiller.util.workspace.ProjectType;
import java.beans.beancontext.BeanContext;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public abstract class AbstractProjectType
implements ProjectType {
    public static final long DEFAULT_PROJECT_FORMAT_ID = 75354770544267891L;
    public static final String DEFAULT_ZIP_ENTRY_NAME = "project";
    private String name;
    private Class projectType;
    private String title;
    private String description;
    private Icon icon;
    private static final Logger logger = Logger.getLogger(AbstractProjectType.class.getName());

    public AbstractProjectType(String name, Class projectType) {
        this.setName(name);
        this.setProjectType(projectType);
    }

    public static Comparator createDefaultProjectChildComparator() {
        return new Comparator(){

            public int compare(Object a, Object b) {
                if (a instanceof BeanContext) {
                    if (!(b instanceof BeanContext)) {
                        return -1;
                    }
                } else if (b instanceof BeanContext) {
                    return 1;
                }
                return String.valueOf(a).compareTo(String.valueOf(b));
            }
        };
    }

    protected ImageIcon createIcon(String s) {
        try {
            return new ImageIcon(this.getClass().getResource(s));
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
    }

    protected Comparator createProjectChildComparator() {
        return AbstractProjectType.createDefaultProjectChildComparator();
    }

    protected Object getChildByName(BeanContext parent, String name) {
        Iterator i;
        if (parent != null && name != null && (i = parent.iterator()) != null) {
            while (i.hasNext()) {
                Object o = i.next();
                if (o == null || !name.equals(String.valueOf(o))) continue;
                return o;
            }
        }
        return null;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Icon getIcon() {
        return this.icon;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    public final Class getProjectType() {
        return this.projectType;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    protected Project migrateProject(Project project) {
        return project;
    }

    @Override
    public ProjectPersistence annotateProject(Project project) throws Exception {
        DefaultProjectPersistence rc = new DefaultProjectPersistence();
        rc.setProject(project);
        rc.setProjectReference(project.getProjectReference());
        int count = project.getImportedProjectCount();
        Project[] imported = new Project[count];
        for (int c = 0; c < count; ++c) {
            imported[c] = project.getImportedProjectAt(c);
        }
        rc.setImportedProjects(imported);
        count = project.getExportedProjectCount();
        Project[] exported = new Project[count];
        for (int c = 0; c < count; ++c) {
            exported[c] = project.getExportedProjectAt(c);
        }
        rc.setExportedProjects(exported);
        count = project.getAccessibleProjectCount();
        Project[] acc = new Project[count];
        for (int c = 0; c < count; ++c) {
            acc[c] = project.getAccessibleProjectAt(c);
        }
        rc.setAccessibleProjects(acc);
        return rc;
    }

    protected void removeEmptyContexts(BeanContext parent) {
        Vector<BeanContext> toRemove = new Vector<BeanContext>();
        Iterator i = parent.iterator();
        if (i != null) {
            while (i.hasNext()) {
                BeanContext bc;
                Object o = i.next();
                if (o == null || !(o instanceof BeanContext) || !(bc = (BeanContext)o).isEmpty()) continue;
                toRemove.add(bc);
            }
        }
        int count = toRemove.size();
        for (int c = 0; c < count; ++c) {
            parent.remove(toRemove.get(c));
        }
    }

    @Override
    public Project resolveProject(ProjectPersistence persistence) throws Exception {
        Project project = null;
        Object projectObject = persistence.getProject();
        if (projectObject == null) {
            throw new NullPointerException(DEFAULT_ZIP_ENTRY_NAME);
        }
        if (!(projectObject instanceof Project)) {
            throw new ClassCastException("Invalid project class: " + projectObject.getClass().getName());
        }
        project = (Project)projectObject;
        if (project instanceof DefaultProject) {
            Project[] exported;
            Project[] imported;
            DefaultProject ap = (DefaultProject)project;
            if (ap.getProjectType() == null) {
                ap.setProjectType(this);
            }
            if ((imported = persistence.getImportedProjects()) != null) {
                for (int c = 0; c < imported.length; ++c) {
                    if (imported[c] == null) continue;
                    ap.addImportedProject(imported[c]);
                }
            }
            if ((exported = persistence.getExportedProjects()) != null) {
                for (int c = 0; c < exported.length; ++c) {
                    if (exported[c] == null) continue;
                    ap.addExportedProject(exported[c]);
                }
            }
        }
        Project migrated = this.migrateProject(project);
        return migrated;
    }

    public void setDescription(String newDescription) {
        this.description = newDescription;
    }

    public void setIcon(Icon newIcon) {
        this.icon = newIcon;
    }

    private void setName(String newName) {
        this.name = newName;
    }

    private void setProjectType(Class newProjectType) {
        this.projectType = newProjectType;
    }

    public void setTitle(String newTitle) {
        this.title = newTitle;
    }

    public String toString() {
        return String.valueOf(this.getName());
    }
}

